/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.container;

import io.github.kadir1243.rivalrebels.common.block.trap.BlockTimedBomb;
import io.github.kadir1243.rivalrebels.common.container.BombContainer;
import io.github.kadir1243.rivalrebels.common.container.SlotRR;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsGuiHandler;
import io.github.kadir1243.rivalrebels.common.item.ItemChip;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import net.minecraft.core.Holder;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ContainerTachyonBomb
extends AbstractContainerMenu
implements BombContainer {
    protected Container bomb;
    private final ContainerData containerData;

    public ContainerTachyonBomb(int syncId, Inventory inventoryPlayer) {
        this(syncId, inventoryPlayer, (Container)new SimpleContainer(36), (ContainerData)new SimpleContainerData(4));
    }

    public ContainerTachyonBomb(int syncId, Inventory inventoryPlayer, Container bomb, ContainerData containerData) {
        super((MenuType)RivalRebelsGuiHandler.TACHYON_SCREEN_HANDLER_TYPE.get(), syncId);
        this.bomb = bomb;
        this.containerData = containerData;
        this.addSlot(new SlotRR(bomb, 0, 18, 48, 1, (Holder<Item>)RRItems.fuse));
        this.addSlot(new SlotRR(bomb, 1, 40, 59, 1, RRItems.antenna.asItem()));
        this.addSlot(new SlotRR(bomb, 2, 40, 37, 1, RRItems.antenna.asItem()));
        for (int i = 0; i <= 3; ++i) {
            this.addSlot(new SlotRR(bomb, i + 3, 62 + i * 18, 19, 1, (Holder<Item>)RRItems.NUCLEAR_ROD).setAcceptsTrollface(true));
            this.addSlot(new SlotRR(bomb, i + 7, 62 + i * 18, 37, 1, (Holder<Item>)RRItems.NUCLEAR_ROD).setAcceptsTrollface(true));
            this.addSlot(new SlotRR(bomb, i + 11, 62 + i * 18, 59, 1, (Holder<Item>)RRItems.hydrod).setAcceptsTrollface(true));
            this.addSlot(new SlotRR(bomb, i + 15, 62 + i * 18, 77, 1, (Holder<Item>)RRItems.hydrod).setAcceptsTrollface(true));
        }
        this.addSlot(new SlotRR(bomb, 19, 138, 48, 1, BlockTimedBomb.class));
        this.addSlot(new SlotRR(bomb, 20, 98, 99, 1, ItemChip.class));
        this.bindPlayerInventory(inventoryPlayer);
        this.addDataSlots(containerData);
    }

    public boolean stillValid(Player player) {
        return this.bomb.stillValid(player);
    }

    protected void bindPlayerInventory(Inventory inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 119 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 175));
        }
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot var4 = (Slot)this.slots.get(slot);
        if (var4 != null && var4.hasItem()) {
            ItemStack var5 = var4.getItem();
            itemStack = var5.copy();
            if (slot <= 19 ? !this.moveItemStackTo(var5, 19, this.slots.size(), true) : !this.moveItemStackTo(var5, 0, 19, false)) {
                return ItemStack.EMPTY;
            }
            if (var5.isEmpty()) {
                var4.setByPlayer(ItemStack.EMPTY);
            } else {
                var4.setChanged();
            }
        }
        return itemStack;
    }

    @Override
    public int getCountdown() {
        return this.containerData.get(0);
    }

    public boolean isUnbalanced() {
        return this.containerData.get(1) == 1;
    }

    public boolean isArmed() {
        return this.containerData.get(2) == 1;
    }

    public float getMegaton() {
        return (float)this.containerData.get(3) / 100.0f;
    }
}

