/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.container;

import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SlotRR
extends Slot {
    private final int maxStack;
    private final Predicate<ItemStack> stackLock;
    boolean acceptsTrollFace = false;
    boolean acceptsTimedBomb = false;
    public boolean locked = false;

    public SlotRR(Container inv, int id, int x, int y, int mstack, Class<?> only) {
        this(inv, id, x, y, mstack, (ItemStack stack) -> {
            BlockItem itemBlock;
            Item patt0$temp;
            return only.isAssignableFrom(stack.getItem().getClass()) || (patt0$temp = stack.getItem()) instanceof BlockItem && only.isAssignableFrom((itemBlock = (BlockItem)patt0$temp).getBlock().getClass());
        });
    }

    public SlotRR(Container inv, int id, int x, int y, int mstack, Item only) {
        this(inv, id, x, y, mstack, (ItemStack stack) -> stack.is(only));
    }

    public SlotRR(Container inv, int id, int x, int y, int mstack, Predicate<ItemStack> stackLock) {
        super(inv, id, x, y);
        this.maxStack = mstack;
        this.stackLock = stackLock;
    }

    public SlotRR(Container inv, int id, int x, int y, int mstack, DataComponentType<?> only) {
        this(inv, id, x, y, mstack, (ItemStack stack) -> stack.has(only));
    }

    public SlotRR(Container inv, int id, int x, int y, int mstack, Holder<Item> only) {
        this(inv, id, x, y, mstack, (ItemStack stack) -> stack.is(only));
    }

    public boolean mayPickup(Player player) {
        return !this.locked;
    }

    public boolean mayPlace(ItemStack stack) {
        if (this.locked) {
            return false;
        }
        if (stack.isEmpty()) {
            return false;
        }
        boolean trollface = this.acceptsTrollFace && stack.is(RRItems.trollmask);
        boolean timedbomb = this.acceptsTimedBomb && stack.is(RRBlocks.timedbomb.asItem());
        return this.stackLock.test(stack) || trollface || timedbomb;
    }

    public int getMaxStackSize() {
        return this.maxStack;
    }

    public SlotRR setAcceptsTrollface(boolean t) {
        this.acceptsTrollFace = t;
        return this;
    }

    public SlotRR setAcceptsTimedBomb(boolean t) {
        this.acceptsTimedBomb = t;
        return this;
    }
}

