/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.core;

import io.github.kadir1243.rivalrebels.RRIdentifiers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.level.Level;

public class RivalRebelsDamageSource {
    public static DamageSource electricity(Level world) {
        return RivalRebelsDamageSource.of(world, RRDamageTypes.ELECTRICITY);
    }

    public static DamageSource radioactivePoisoning(Level world) {
        return RivalRebelsDamageSource.of(world, RRDamageTypes.RADIOACTIVE_POISONING);
    }

    public static DamageSource nuclearBlast(Level world) {
        return RivalRebelsDamageSource.of(world, RRDamageTypes.NUCLEAR_BLAST);
    }

    public static DamageSource cooked(Level world) {
        return RivalRebelsDamageSource.of(world, RRDamageTypes.COOKED);
    }

    public static DamageSource gasGrenade(Level world) {
        return RivalRebelsDamageSource.of(world, RRDamageTypes.GAS_GRENADE);
    }

    public static DamageSource cuchillo(Level world) {
        return RivalRebelsDamageSource.of(world, RRDamageTypes.CUCHILLO);
    }

    public static DamageSource tron(Level world) {
        return RivalRebelsDamageSource.of(world, RRDamageTypes.TRON);
    }

    public static DamageSource cyanide(Level world) {
        return RivalRebelsDamageSource.of(world, RRDamageTypes.CYANIDE);
    }

    public static DamageSource landmine(Level world) {
        return RivalRebelsDamageSource.of(world, RRDamageTypes.LANDMINE);
    }

    public static DamageSource timedBomb(Level world) {
        return RivalRebelsDamageSource.of(world, RRDamageTypes.TIMED_BOMB);
    }

    public static DamageSource flare(Level world) {
        return RivalRebelsDamageSource.of(world, RRDamageTypes.FLARE);
    }

    public static DamageSource charge(Level world) {
        return RivalRebelsDamageSource.of(world, RRDamageTypes.CHARGE);
    }

    public static DamageSource plasmaExplosion(Level world) {
        return RivalRebelsDamageSource.of(world, RRDamageTypes.PLASMA_EXPLOSION);
    }

    public static DamageSource rocket(Level world) {
        return RivalRebelsDamageSource.of(world, RRDamageTypes.ROCKET);
    }

    public static DamageSource laserBurst(Level world) {
        return RivalRebelsDamageSource.of(world, RRDamageTypes.LASER_BURST);
    }

    private static DamageSource of(Level world, ResourceKey<DamageType> key) {
        return world.damageSources().source(key);
    }

    public static class RRDamageTypes {
        public static final List<ResourceKey<DamageType>> REGISTERED_DAMAGE_TYPES = new ArrayList<ResourceKey<DamageType>>();
        public static final ResourceKey<DamageType> ELECTRICITY = RRDamageTypes.register("electricity");
        public static final ResourceKey<DamageType> RADIOACTIVE_POISONING = RRDamageTypes.register("radioactive_poisoning");
        public static final ResourceKey<DamageType> NUCLEAR_BLAST = RRDamageTypes.register("nuclear_blast");
        public static final ResourceKey<DamageType> COOKED = RRDamageTypes.register("cooked");
        public static final ResourceKey<DamageType> GAS_GRENADE = RRDamageTypes.register("gas_grenade");
        public static final ResourceKey<DamageType> CUCHILLO = RRDamageTypes.register("cuchillo");
        public static final ResourceKey<DamageType> TRON = RRDamageTypes.register("tron");
        public static final ResourceKey<DamageType> CYANIDE = RRDamageTypes.register("cyanide");
        public static final ResourceKey<DamageType> LANDMINE = RRDamageTypes.register("landmine");
        public static final ResourceKey<DamageType> TIMED_BOMB = RRDamageTypes.register("timed_bomb");
        public static final ResourceKey<DamageType> FLARE = RRDamageTypes.register("flare");
        public static final ResourceKey<DamageType> CHARGE = RRDamageTypes.register("charge");
        public static final ResourceKey<DamageType> PLASMA_EXPLOSION = RRDamageTypes.register("plasma_explosion");
        public static final ResourceKey<DamageType> ROCKET = RRDamageTypes.register("rocket");
        public static final ResourceKey<DamageType> LASER_BURST = RRDamageTypes.register("laser_burst");

        private static ResourceKey<DamageType> register(String name) {
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)RRIdentifiers.create(name));
            REGISTERED_DAMAGE_TYPES.add((ResourceKey<DamageType>)key);
            return key;
        }

        public static void init() {
        }
    }
}

