/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.AbstractBlastEntity;
import io.github.kadir1243.rivalrebels.common.entity.EntityB83;
import io.github.kadir1243.rivalrebels.common.entity.EntityHackB83;
import io.github.kadir1243.rivalrebels.common.entity.EntityNuclearBlast;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodes;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import io.github.kadir1243.rivalrebels.common.explosion.AntimatterBomb;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityAntimatterBombBlast
extends AbstractBlastEntity<AntimatterBomb> {
    List<Entity> entitylist = new ArrayList<Entity>();

    public EntityAntimatterBombBlast(EntityType<? extends EntityAntimatterBombBlast> entityType, Level level) {
        super(entityType, level);
    }

    public EntityAntimatterBombBlast(Level level) {
        super((EntityType)RREntities.ANTIMATTER_BOMB_BLAST.get(), level);
    }

    public EntityAntimatterBombBlast(Level level, float x, float y, float z, AntimatterBomb tsarBomba, int rad) {
        this(level);
        this.bomb = tsarBomba;
        this.radius = rad;
        this.setDeltaMovement(Math.sqrt(this.radius - (double)RRConfig.SERVER.getTsarBombaStrength()) / 10.0, this.getDeltaMovement().y(), this.getDeltaMovement().z());
        this.setPos(x, y, z);
    }

    public EntityAntimatterBombBlast(Level level, double x, double y, double z, float rad) {
        this(level);
        this.radius = rad;
        this.setDeltaMovement(Math.sqrt(rad - (float)RRConfig.SERVER.getTsarBombaStrength()) / 10.0, this.getDeltaMovement().y(), this.getDeltaMovement().z());
        this.setPos(x, y, z);
    }

    public void tick() {
        super.tick();
        if (this.random.nextInt(30) == 0) {
            this.playSound(SoundEvents.LIGHTNING_BOLT_THUNDER, 10.0f, 0.5f);
        } else if (this.random.nextInt(30) == 0) {
            this.playSound((SoundEvent)RRSounds.MANDELEED.get(), 100.0f, 0.8f);
        }
        ++this.tickCount;
        if (!this.level().isClientSide()) {
            if (this.bomb == null && this.tickCount > 1200) {
                this.kill((ServerLevel)this.level());
            }
            if (this.tickCount % 20 == 0) {
                this.updateEntityList();
            }
            if (this.tickCount < 1200 && this.tickCount % 5 == 0) {
                this.pushAndHurtEntities();
            }
            for (int i = 0; i < RRConfig.SERVER.getTsarBombaSpeed() * 2; ++i) {
                if (this.bomb == null) {
                    return;
                }
                ((AntimatterBomb)this.bomb).tick(this);
            }
        }
    }

    public void updateEntityList() {
        this.entitylist.clear();
        double ldist = this.radius * this.radius;
        List otherEntities = this.level().getEntities((Entity)this, AABB.of((BoundingBox)BoundingBox.infinite()), e -> (!(e instanceof Player) || !((Player)e).isCreative()) && !(e instanceof EntityNuclearBlast) && !(e instanceof EntityAntimatterBombBlast));
        for (Entity e2 : otherEntities) {
            double dist = e2.distanceToSqr(this.getX(), this.getY(), this.getZ());
            if (!(dist < ldist)) continue;
            this.entitylist.add(e2);
        }
    }

    public void pushAndHurtEntities() {
        ArrayList<Entity> remove = new ArrayList<Entity>();
        float invrad = 1.0f / (float)this.radius;
        for (Entity e : this.entitylist) {
            if (!e.isAlive() || e.isInvulnerable()) {
                remove.add(e);
                continue;
            }
            Vec3 vec3 = e.position().subtract(this.position());
            float dist = (float)vec3.length();
            float rsqrt = 1.0f / (dist + 1.0E-4f);
            vec3 = vec3.scale((double)rsqrt);
            double f = 40.0f * (1.0f - dist * invrad) * (e instanceof EntityB83 || e instanceof EntityHackB83 ? -1.0f : 1.0f);
            if (e instanceof EntityRhodes) {
                e.hurt(RivalRebelsDamageSource.nuclearBlast(this.level()), (float)((int)(this.radius * f * (double)0.025f)));
                continue;
            }
            e.hurt(RivalRebelsDamageSource.nuclearBlast(this.level()), (float)((int)(f * f * 2.0 * this.radius + 20.0)));
            e.setDeltaMovement(e.getDeltaMovement().subtract(vec3.scale(f)));
        }
        for (Entity e : remove) {
            this.entitylist.remove(e);
        }
    }

    public EntityAntimatterBombBlast setTime() {
        this.tickCount = 920;
        return this;
    }
}

