/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.EntityInanimate;
import io.github.kadir1243.rivalrebels.common.entity.EntityLaserBurst;
import io.github.kadir1243.rivalrebels.common.entity.EntityPlasmoid;
import io.github.kadir1243.rivalrebels.common.entity.EntityRocket;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import io.github.kadir1243.rivalrebels.common.explosion.Explosion;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityB2Frag
extends EntityInanimate {
    private int ticksInGround;
    private boolean isSliding = false;
    public int type = 0;
    float motionyaw = 0.0f;
    float motionpitch = 0.0f;
    float offset = 0.0f;
    public int health;

    public EntityB2Frag(EntityType<? extends EntityB2Frag> type, Level level) {
        super(type, level);
    }

    public EntityB2Frag(Level level) {
        this((EntityType<? extends EntityB2Frag>)((EntityType)RREntities.B2FRAG.get()), level);
        this.health = 300;
        this.setBoundingBox(new AABB(-2.5, -2.5, -2.5, 2.5, 2.5, 2.5));
    }

    public EntityB2Frag(Level level, Entity toBeGibbed, int Type2) {
        this(level);
        this.health = 300;
        this.setBoundingBox(new AABB(-2.5, -2.5, -2.5, 2.5, 2.5, 2.5));
        this.isSliding = false;
        this.type = Type2;
        this.motionyaw = (float)((this.random.nextDouble() - 0.5) * 35.0);
        this.motionpitch = (float)((this.random.nextDouble() - 0.5) * 25.0);
        this.snapTo(toBeGibbed.getX(), toBeGibbed.getY(), toBeGibbed.getZ(), toBeGibbed.getYRot(), toBeGibbed.getXRot());
        double ox = this.getX();
        double oz = this.getZ();
        if (Type2 == 1) {
            this.setPos(this.getX() - (double)(Mth.cos((float)(-this.getYRot() * ((float)Math.PI / 180))) * 7.5f), this.getY(), this.getZ() - (double)(Mth.sin((float)(-this.getYRot() * ((float)Math.PI / 180))) * 7.5f));
        } else if (Type2 == 0) {
            this.setPos(this.getX() - (double)(Mth.cos((float)((-this.getYRot() + 180.0f) * ((float)Math.PI / 180))) * 7.5f), this.getY(), this.getZ() - (double)(Mth.sin((float)((-this.getYRot() + 180.0f) * ((float)Math.PI / 180))) * 7.5f));
        }
        this.setDeltaMovement(toBeGibbed.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().add((-ox + this.getX()) * 0.1, 0.0, (-oz + this.getZ()) * 0.1));
        this.igniteForSeconds(10.0f);
    }

    public boolean canBeCollidedWith(@Nullable Entity p_423659_) {
        return true;
    }

    public void tick() {
        super.tick();
        if (this.onGround()) {
            ++this.ticksInGround;
            if (this.ticksInGround == 1200) {
                this.kill((ServerLevel)this.level());
            }
            this.setOnGround(false);
            this.setDeltaMovement(this.getDeltaMovement().multiply((double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f)));
            this.ticksInGround = 0;
        }
        Vec3 vec3 = this.position();
        Vec3 vec31 = this.position().add(this.getDeltaMovement());
        BlockHitResult hitResult = this.level().clip(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (hitResult != null) {
            this.isSliding = true;
            this.setPosRaw(this.getX(), hitResult.getLocation().y() + (double)this.offset, this.getZ());
        }
        if (!this.level().isClientSide()) {
            List var5 = this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(this.getDeltaMovement().x(), this.getDeltaMovement().y(), this.getDeltaMovement().z()).inflate(1.0, 1.0, 1.0));
            for (Entity var9 : var5) {
                if (var9 instanceof EntityRocket) {
                    ((EntityRocket)var9).explode();
                }
                if (var9 instanceof EntityPlasmoid) {
                    ((EntityPlasmoid)var9).explode();
                }
                if (!(var9 instanceof EntityLaserBurst)) continue;
                var9.kill((ServerLevel)this.level());
                this.hurt(this.damageSources().generic(), 6.0f);
            }
        }
        this.setXRot(this.getXRot() + this.motionpitch);
        this.setYRot(this.getYRot() + this.motionyaw);
        this.setPosRaw(this.getX() + this.getDeltaMovement().x(), this.getY() + this.getDeltaMovement().y(), this.getZ() + this.getDeltaMovement().z());
        this.setXRot(this.xRotO + (this.getXRot() - this.xRotO) * 0.5f);
        this.setYRot(this.yRotO + (this.getYRot() - this.yRotO) * 0.5f);
        float f2 = 0.99f;
        if (this.isSliding) {
            this.motionpitch = 0.0f;
            this.motionyaw = 0.0f;
            this.setDeltaMovement(this.getDeltaMovement().x(), 0.0, this.getDeltaMovement().z());
            f2 = 0.7f;
        }
        this.motionpitch = (float)((double)this.motionpitch * (double)f2);
        this.motionyaw = (float)((double)this.motionyaw * (double)f2);
        this.setDeltaMovement(this.getDeltaMovement().scale((double)f2));
        this.applyGravity();
        this.reapplyPosition();
    }

    protected double getDefaultGravity() {
        return this.isSliding ? super.getDefaultGravity() : (double)0.05f;
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putInt("Type", this.type);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.type = valueInput.getIntOr("Type", 0);
    }

    @Override
    public boolean hurtServer(ServerLevel level, DamageSource source, float amount) {
        if (this.isAlive()) {
            this.health = (int)((float)this.health - amount);
            if (this.health <= 0) {
                this.kill(level);
                new Explosion(this.level(), this.getX(), this.getY(), this.getZ(), 6, true, true, RivalRebelsDamageSource.rocket(this.level()));
                this.playSound((SoundEvent)RRSounds.ARTILLERY_EXPLODE.get(), 30.0f, 1.0f);
            }
        }
        return true;
    }
}

