/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.entity.EntityB2Frag;
import io.github.kadir1243.rivalrebels.common.entity.EntityLaserBurst;
import io.github.kadir1243.rivalrebels.common.entity.EntityPlasmoid;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodes;
import io.github.kadir1243.rivalrebels.common.entity.EntityRocket;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import io.github.kadir1243.rivalrebels.common.item.weapon.ItemRoda;
import java.util.List;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityB2Spirit
extends Projectile {
    private int ticksSinceStart = 0;
    private int timeLeft = -1;
    private double tx = 0.0;
    private double ty = 0.0;
    private double tz = 0.0;
    public int health;
    public boolean carpet = false;
    public EntityRhodes rhodeswing = null;
    public static int staticEntityIndex = 10;
    public int entityIndex = 10;
    public boolean dropAnything = true;
    public boolean dropOnlyOne = false;
    public static boolean trash = true;
    public static boolean leave = true;
    public int mode = 0;
    Entity rhodes = null;

    public EntityB2Spirit(EntityType<? extends EntityB2Spirit> entityType, Level level) {
        super(entityType, level);
        this.setBoundingBox(new AABB(-10.0, -3.0, -10.0, 10.0, 4.0, 10.0));
        this.health = RRConfig.SERVER.getB2spirithealth();
    }

    public EntityB2Spirit(Level level) {
        this((EntityType<? extends EntityB2Spirit>)((EntityType)RREntities.B2SPIRIT.get()), level);
    }

    public EntityB2Spirit(Level level, double x, double y, double z, double x1, double y1, double z1, boolean c, boolean da) {
        this(level);
        this.carpet = c;
        this.tx = x;
        this.ty = y;
        this.tz = z;
        boolean bl = this.dropOnlyOne = !da;
        if (this.carpet) {
            this.entityIndex = 10;
            if (staticEntityIndex <= 23) {
                this.entityIndex = staticEntityIndex;
            }
        } else {
            this.entityIndex = 24;
            if (staticEntityIndex > 23) {
                this.entityIndex = staticEntityIndex;
            }
        }
        if (!this.level().isClientSide()) {
            this.startBombRun(this.tz - z1, x1 - this.tx);
        }
    }

    public EntityB2Spirit(EntityRhodes r) {
        this(r.level());
        this.rhodeswing = r;
        this.setPosRaw(r.getX() - r.getDeltaMovement().x() * 500.0, 120.0, r.getZ() - r.getDeltaMovement().z() * 500.0);
    }

    public boolean canBeCollidedWith(@Nullable Entity p_423659_) {
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (this.random.nextDouble() > (double)0.8f) {
            this.playSound((SoundEvent)RRSounds.FLAME_THROWER_USE.get(), 4.5f, 1.3f);
        }
        if (this.rhodeswing != null) {
            this.setDeltaMovement(this.rhodeswing.position().subtract(this.position()));
            double t = this.getDeltaMovement().length();
            this.setDeltaMovement(this.getDeltaMovement().normalize());
            this.setYRot(this.rhodeswing.getYRot());
            this.setXRot((float)Math.min(t, 90.0));
            if (t < 25.0 || this.tickCount > 100) {
                this.rhodeswing.setB2Energy(8000);
                this.rhodeswing.freeze = false;
                this.kill((ServerLevel)this.level());
            }
        }
        if (!this.level().isClientSide()) {
            double distfromtarget = Math.sqrt((this.tx - this.getX()) * (this.tx - this.getX()) + (this.tz - this.getZ()) * (this.tz - this.getZ()));
            ++this.ticksSinceStart;
            if (this.ticksSinceStart >= 60 && this.mode == 0) {
                if (this.carpet || (this.dropOnlyOne ? this.ticksSinceStart == 80 : this.ticksSinceStart % 40 == 0)) {
                    this.dropNuke();
                }
                if (distfromtarget > 80.0) {
                    int n = this.mode = this.random.nextBoolean() ? 1 : 2;
                    if (trash) {
                        this.carpet = true;
                        this.entityIndex = this.random.nextInt(ItemRoda.rodaindex);
                    }
                    if (leave) {
                        if (this.ticksSinceStart > 1000 && this.random.nextInt(4) == 1) {
                            this.setDeltaMovement(this.getDeltaMovement().x(), 2.0, this.getDeltaMovement().z());
                        }
                        if (!trash && this.dropOnlyOne) {
                            this.setDeltaMovement(this.getDeltaMovement().x(), 2.0, this.getDeltaMovement().z());
                        }
                    }
                }
            }
            if (this.mode > 0) {
                if (this.mode == 1) {
                    this.setYRot(this.getYRot() + 10.0f);
                } else if (this.mode == 2) {
                    this.setYRot(this.getYRot() - 10.0f);
                }
                this.setDeltaMovement(Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), this.getDeltaMovement().y(), Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))));
                if (distfromtarget < 80.0) {
                    this.mode = 0;
                }
            }
            List var5 = this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0, 1.0, 1.0));
            for (Entity var9 : var5) {
                if (var9 instanceof EntityRocket) {
                    ((EntityRocket)var9).explode();
                }
                if (var9 instanceof EntityPlasmoid) {
                    ((EntityPlasmoid)var9).explode();
                }
                if (!(var9 instanceof EntityLaserBurst)) continue;
                var9.kill((ServerLevel)this.level());
                this.hurt(this.damageSources().generic(), 6.0f);
            }
            --this.timeLeft;
            if (this.timeLeft == 0) {
                this.setDeltaMovement(this.getDeltaMovement().x(), 2.0, this.getDeltaMovement().z());
            }
            if (this.getY() > 256.0) {
                this.kill((ServerLevel)this.level());
            }
        }
        Vec3 vec3d = this.position().add(this.getDeltaMovement());
        this.setPosRaw(vec3d.x(), vec3d.y(), vec3d.z());
        if (this.rhodeswing == null) {
            this.updateRotation();
        }
        this.reapplyPosition();
    }

    public void dropNuke() {
        if (this.dropAnything) {
            ItemRoda.spawn(this.entityIndex, this.level(), this.getX() + this.random.nextDouble() * 4.0 - 2.0, this.getY() - 3.5, this.getZ() + this.random.nextDouble() * 4.0 - 2.0, this.getDeltaMovement().x() * (double)0.1f, -1.0, this.getDeltaMovement().z() * (double)0.1f, 1.0, 0.0);
        }
    }

    public void startBombRun(double x, double z) {
        if (this.rhodes != null) {
            this.tx = this.rhodes.getX();
            this.ty = this.rhodes.getY();
            this.tz = this.rhodes.getZ();
            x = -this.rhodes.getDeltaMovement().x();
            z = -this.rhodes.getDeltaMovement().z();
        }
        double dist = 1.0 / Math.sqrt(x * x + z * z);
        this.setDeltaMovement(-(x *= dist), this.getDeltaMovement().y(), -(z *= dist));
        this.setPos(this.tx + x * 80.0, this.ty + 60.0, this.tz + z * 80.0);
        this.yRotO = (float)(Math.atan2(this.getDeltaMovement().x(), this.getDeltaMovement().z()) * 57.2957763671875);
        this.setYRot(this.yRotO);
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        valueOutput.putInt("drop", this.entityIndex);
        valueOutput.putFloat("tx", (float)this.tx);
        valueOutput.putFloat("ty", (float)this.ty);
        valueOutput.putFloat("tz", (float)this.tz);
        valueOutput.putInt("age", this.ticksSinceStart);
        valueOutput.putInt("health", this.health);
        valueOutput.putInt("duration", this.timeLeft);
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        this.entityIndex = (Integer)valueInput.getInt("drop").orElseThrow();
        this.carpet = this.entityIndex < ItemRoda.rodaindex;
        this.tx = valueInput.getFloatOr("tx", 0.0f);
        this.ty = valueInput.getFloatOr("ty", 0.0f);
        this.tz = valueInput.getFloatOr("tz", 0.0f);
        this.ticksSinceStart = (Integer)valueInput.getInt("age").orElseThrow();
        this.health = (Integer)valueInput.getInt("health").orElseThrow();
        this.timeLeft = (Integer)valueInput.getInt("duration").orElseThrow();
        if (this.ticksSinceStart == 0) {
            double dx = this.tx - this.getX();
            double dy = this.ty - this.getY();
            this.startBombRun(dx, dy);
        }
    }

    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        super.hurt(damageSource, amount);
        if (this.isAlive()) {
            this.health = (int)((float)this.health - amount);
            if (this.health <= 0) {
                this.kill(level);
                this.level().explode(null, this.getX(), this.getY(), this.getZ(), 6.0f, Level.ExplosionInteraction.MOB);
                this.level().addFreshEntity((Entity)new EntityB2Frag(this.level(), (Entity)this, 0));
                this.level().addFreshEntity((Entity)new EntityB2Frag(this.level(), (Entity)this, 1));
                Zombie pz = new Zombie(this.level());
                pz.setPos(this.position());
                this.level().addFreshEntity((Entity)pz);
                this.playSound((SoundEvent)RRSounds.ARTILLERY_EXPLODE.get(), 30.0f, 1.0f);
            }
        }
        return true;
    }
}

