/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.entity.EntityTsarBlast;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import io.github.kadir1243.rivalrebels.common.explosion.NuclearExplosion;
import io.github.kadir1243.rivalrebels.common.util.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityB83
extends ThrowableProjectile {
    public int ticksInAir = 0;

    public EntityB83(EntityType<? extends EntityB83> entityType, Level level) {
        super(entityType, level);
    }

    public EntityB83(Level level, double x, double y, double z, float yaw, float pitch) {
        this((EntityType<? extends EntityB83>)((EntityType)RREntities.B83.get()), level);
        this.snapTo(x, y, z, yaw, pitch);
        this.setDeltaMovement(-(-Mth.sin((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)))), -Mth.sin((float)(pitch * ((float)Math.PI / 180))), Mth.cos((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180))));
    }

    public EntityB83(Level level, double x, double y, double z, float yaw, float pitch, float strength) {
        this((EntityType<? extends EntityB83>)((EntityType)RREntities.B83.get()), level);
        this.snapTo(x, y, z, yaw, pitch);
        this.setDeltaMovement(-(-Mth.sin((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)))) * strength, -Mth.sin((float)(pitch * ((float)Math.PI / 180))) * strength, Mth.cos((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180))) * strength);
    }

    public EntityB83(Level level, double mx, double my, double mz) {
        this((EntityType<? extends EntityB83>)((EntityType)RREntities.B83.get()), level);
        this.yRotO = (float)(Math.atan2(mx, mz) * 57.2957763671875);
        this.setYRot(this.yRotO);
        this.xRotO = (float)(Math.atan2(my, Math.sqrt(mx * mx + mz * mz)) * 57.2957763671875);
        this.setXRot(this.xRotO);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        if (this.ticksInAir == -100 || this.getY() < (double)this.level().getMinY() || this.getY() > (double)this.level().getMaxY()) {
            this.explode();
        }
        ++this.ticksInAir;
        HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
        if (hitResult.getType() != HitResult.Type.MISS) {
            this.onHit(hitResult);
        }
        Vec3 add = this.position().add(this.getDeltaMovement());
        this.setPosRaw(add.x(), add.y(), add.z());
        if (this.isPassenger()) {
            this.updateRotation();
        }
        float var17 = 0.9f;
        this.setDeltaMovement(this.getDeltaMovement().scale((double)var17));
        this.applyGravity();
        this.reapplyPosition();
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        BlockState state = this.level().getBlockState(blockHitResult.getBlockPos());
        if (state.is(BlockTags.LEAVES) || state.is(BlockTags.FLOWERS) || state.is(BlockTags.CROPS) || state.is(Blocks.CAKE) || state.getBlock().getExplosionResistance() < 1.0f || state.is(BlockTags.WOOL) || state.is(Blocks.SNOW_BLOCK) || state.is(ModBlockTags.GLASS_BLOCKS) || state.is(ModBlockTags.GLASS_PANES) || state.is(BlockTags.SAND) || state.is(BlockTags.SNOW) || state.ignitedByLava() || state.canBeReplaced() || state.getFluidState().is(FluidTags.WATER) || state.is(Blocks.SPONGE) || state.is(BlockTags.ICE)) {
            this.level().setBlockAndUpdate(blockHitResult.getBlockPos(), Blocks.AIR.defaultBlockState());
            return;
        }
        this.explode();
    }

    protected double getDefaultGravity() {
        return 0.1f;
    }

    public void explode() {
        new NuclearExplosion(this.level(), (int)this.getX(), (int)this.getY(), (int)this.getZ(), RRConfig.SERVER.getB83Strength());
        this.level().addFreshEntity((Entity)new EntityTsarBlast(this.level(), this.getX(), this.getY(), this.getZ(), (float)RRConfig.SERVER.getB83Strength() * 1.3333334f).setTime());
        this.kill((ServerLevel)this.level());
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
        super.checkFallDamage(y, onGround, state, pos);
    }
}

