/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class EntityBomb
extends ThrowableProjectile {
    public int ticksInAir = 0;
    public int timeleft = 20;
    public boolean exploded = false;
    public boolean hit = false;

    public EntityBomb(EntityType<? extends EntityBomb> type, Level level) {
        super(type, level);
    }

    public EntityBomb(Level level) {
        this((EntityType<? extends EntityBomb>)((EntityType)RREntities.BOMB.get()), level);
    }

    public EntityBomb(Level level, double x, double y, double z, float yaw, float pitch) {
        this(level);
        this.snapTo(x, y, z, yaw, pitch);
        this.setDeltaMovement(-(-Mth.sin((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)))), -Mth.sin((float)(pitch * ((float)Math.PI / 180))), Mth.cos((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180))));
    }

    public EntityBomb(Level level, double x, double y, double z, double mx, double my, double mz) {
        this(level);
        this.setPos(x + mx * (double)1.4f, y + my * (double)1.4f, z + mz * (double)1.4f);
        this.yRotO = (float)(Math.atan2(mx, mz) * 57.2957763671875);
        this.setYRot(this.yRotO);
        this.xRotO = (float)(Math.atan2(my, Math.sqrt(mx * mx + mz * mz)) * 57.2957763671875);
        this.setXRot(this.xRotO);
    }

    public EntityBomb(Level level, Entity entity, float inaccuracy) {
        this(level);
        this.setOwner(entity);
        this.snapTo(entity.getEyePosition(), entity.getYRot(), entity.getXRot());
        this.setPos(this.getX() + this.getDeltaMovement().x(), this.getY() + this.getDeltaMovement().y(), this.getZ() + this.getDeltaMovement().z());
        this.shootFromRotation(entity, entity.getXRot(), entity.getYRot(), 0.0f, 2.5f, inaccuracy);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        if (this.ticksInAir == -100) {
            this.explode(false);
        }
        ++this.ticksInAir;
        if (this.exploded) {
            this.setDeltaMovement(0.0, this.hit ? 1.0 : 0.0, 0.0);
            --this.timeleft;
            if (this.timeleft < 0) {
                this.kill((ServerLevel)this.level());
            }
            ++this.tickCount;
        } else {
            HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
            if (hitResult.getType() != HitResult.Type.MISS) {
                this.onHit(hitResult);
            }
            this.setPosRaw(this.getX() + this.getDeltaMovement().x(), this.getY() + this.getDeltaMovement().y(), this.getZ() + this.getDeltaMovement().z());
            this.updateRotation();
            float var17 = 0.95f;
            this.setDeltaMovement(this.getDeltaMovement().scale((double)var17));
            this.applyGravity();
        }
        this.reapplyPosition();
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.getEntity();
        entity.hurt(RivalRebelsDamageSource.rocket(this.level()), (float)(entity instanceof Player ? 20 : 300));
        this.explode(true);
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        this.explode(false);
    }

    protected double getDefaultGravity() {
        return 0.1f;
    }

    public void explode(boolean b) {
        this.exploded = true;
        this.hit = b;
        this.tickCount = 0;
        if (this.random.nextDouble() > (double)0.8f) {
            this.playSound((SoundEvent)RRSounds.BOMB_EXPLODE.get(), 20.0f, 0.4f + (float)this.random.nextDouble() * 0.3f);
        }
        if (!this.level().isClientSide() && !b) {
            int r = 2;
            for (int x = -r; x <= r; ++x) {
                for (int y = -r; y <= r; ++y) {
                    for (int z = -r; z <= r; ++z) {
                        this.level().setBlockAndUpdate(new BlockPos((int)(this.getX() + (double)x), (int)(Math.max(this.getY(), (double)(r + 1)) + (double)y), (int)(this.getZ() + (double)z)), Blocks.AIR.defaultBlockState());
                    }
                }
            }
        }
    }
}

