/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.common.entity.EntityInanimate;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import java.util.Optional;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class EntityDebris
extends EntityInanimate {
    public static final EntityDataAccessor<Optional<BlockState>> STATE = SynchedEntityData.defineId(EntityDebris.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_STATE);
    public static final EntityDataAccessor<CompoundTag> TILE_ENTITY_DATA = SynchedEntityData.defineId(EntityDebris.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);

    public EntityDebris(EntityType<? extends EntityDebris> type, Level level) {
        super(type, level);
    }

    public EntityDebris(Level level) {
        super((EntityType<? extends EntityInanimate>)((EntityType)RREntities.DEBRIS.get()), level);
    }

    public EntityDebris(Level level, BlockPos pos) {
        this(level);
        this.setState(level.getBlockState(pos));
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null) {
            this.setTileEntityData(blockEntity.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess()));
        }
        level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        this.setPos(Vec3.atLowerCornerOf((Vec3i)pos).add(0.5, 0.5, 0.5));
        this.setOldPosAndRot();
    }

    public EntityDebris(Level level, Block block) {
        this(level);
        this.setState(block.defaultBlockState());
    }

    public BlockState getState() {
        return ((Optional)this.entityData.get(STATE)).orElse(null);
    }

    public void setState(BlockState state) {
        this.entityData.set(STATE, Optional.ofNullable(state));
    }

    public CompoundTag getTileEntityData() {
        return (CompoundTag)this.entityData.get(TILE_ENTITY_DATA);
    }

    public void setTileEntityData(CompoundTag tileEntityData) {
        this.entityData.set(TILE_ENTITY_DATA, (Object)tileEntityData);
    }

    public void tick() {
        this.setOldPosAndRot();
        ++this.tickCount;
        this.applyGravity();
        this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        Vec3 add = this.getDeltaMovement().add(this.position());
        this.setPosRaw(add.x(), add.y(), add.z());
        if (!this.level().isClientSide() && this.level().getBlockState(this.blockPosition()).canOcclude()) {
            this.die(this.xo, this.yo, this.zo);
        }
    }

    protected double getDefaultGravity() {
        return 0.04;
    }

    public void die(double x, double y, double z) {
        this.kill((ServerLevel)this.level());
        BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
        this.level().setBlockAndUpdate(pos, this.getState());
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        if (this.getState() != null) {
            valueOutput.store("Block", CompoundTag.CODEC, (Object)NbtUtils.writeBlockState((BlockState)this.getState()));
        }
        valueOutput.putInt("Age", this.tickCount);
        if (!this.getTileEntityData().isEmpty()) {
            valueOutput.store("TileEntityData", CompoundTag.CODEC, (Object)this.getTileEntityData());
        }
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueInput) {
        valueInput.read("Block", CompoundTag.CODEC).ifPresent(compoundTag -> this.setState(NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)compoundTag)));
        this.tickCount = valueInput.getIntOr("Age", 0);
        valueInput.read("TileEntityData", CompoundTag.CODEC).ifPresent(this::setTileEntityData);
    }

    public void fillCrashReportCategory(CrashReportCategory section) {
        super.fillCrashReportCategory(section);
        if (this.getState() != null) {
            section.setDetail("Immitating BlockState", (Object)this.getState().toString());
        }
        if (!this.getTileEntityData().isEmpty()) {
            section.setDetail("Immitating Block Entity Data", (Object)this.getTileEntityData().toString());
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(STATE, Optional.empty());
        builder.define(TILE_ENTITY_DATA, (Object)new CompoundTag());
    }
}

