/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.FlameBallProjectile;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityReciever;
import io.github.kadir1243.rivalrebels.common.util.ItemUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class EntityFlameBall
extends FlameBallProjectile {
    public EntityFlameBall(EntityType<? extends EntityFlameBall> entityType, Level level) {
        super(entityType, level);
    }

    public EntityFlameBall(Level level) {
        this((EntityType<? extends EntityFlameBall>)((EntityType)RREntities.FLAME_BALL.get()), level);
    }

    public EntityFlameBall(Level level, Entity entity, float speed) {
        this(level);
        this.setPos(entity.getEyePosition());
        this.setDeltaMovement(-Mth.sin((float)(entity.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(entity.getXRot() * ((float)Math.PI / 180))), -Mth.sin((float)(entity.getXRot() * ((float)Math.PI / 180))), Mth.cos((float)(entity.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(entity.getXRot() * ((float)Math.PI / 180))));
        this.setPosRaw(this.getX() - (double)(Mth.cos((float)(entity.getYRot() * ((float)Math.PI / 180))) * 0.2f), this.getY() - 0.13, this.getZ() - (double)(Mth.sin((float)(entity.getYRot() * ((float)Math.PI / 180))) * 0.2f));
        this.setDeltaMovement(this.getDeltaMovement().scale((double)speed));
    }

    public EntityFlameBall(Level level, TileEntityReciever ter, float speed) {
        this(level);
        this.setYRot(180.0f - ter.yaw);
        this.setXRot(-ter.pitch);
        this.setPos((double)((float)ter.getBlockPos().getX() + ter.xO) + 0.5, (double)ter.getBlockPos().getY() + 0.5, (double)((float)ter.getBlockPos().getZ() + ter.zO) + 0.5);
        this.setDeltaMovement(-Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180))), Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180))), -Mth.sin((float)(this.getXRot() * ((float)Math.PI / 180))));
        this.setDeltaMovement(this.getDeltaMovement().scale((double)speed));
    }

    public EntityFlameBall(Level level, double x, double y, double z, double mx, double my, double mz, double d, double r) {
        this(level);
        this.setPos(x + mx * d + this.random.nextGaussian() * r, y + my * d + this.random.nextGaussian() * r, z + mz * d + this.random.nextGaussian() * r);
        this.setDeltaMovement(mx, my, mz);
    }

    public void tick() {
        HitResult hitResult;
        super.tick();
        if (this.tickCount % 3 == 0) {
            ++this.sequence;
        }
        if (this.sequence > 15) {
            this.kill((ServerLevel)this.level());
        }
        if ((hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0))).getType() != HitResult.Type.MISS && this.tickCount >= 5) {
            this.fire();
            this.kill((ServerLevel)this.level());
            if (hitResult.getType() == HitResult.Type.ENTITY) {
                Entity hitEntity = ((EntityHitResult)hitResult).getEntity();
                hitEntity.igniteForSeconds(3.0f);
                hitEntity.hurt(RivalRebelsDamageSource.cooked(this.level()), 12.0f);
                if (hitEntity instanceof Player) {
                    Player player = (Player)hitEntity;
                    ItemUtil.damageRandomArmor((LivingEntity)player, 8, this.random);
                }
            }
        }
        this.setPosRaw(this.getX() + this.getDeltaMovement().x(), this.getY() + this.getDeltaMovement().y(), this.getZ() + this.getDeltaMovement().z());
        this.rotation += this.motionr;
        this.motionr *= 1.06f;
        if (this.isInWater()) {
            this.kill((ServerLevel)this.level());
        }
        float airFriction = 0.96f;
        this.setDeltaMovement(this.getDeltaMovement().scale((double)airFriction));
        this.applyGravity();
        this.reapplyPosition();
    }

    protected double getDefaultGravity() {
        return 0.01;
    }

    private void fire() {
        if (!this.level().isClientSide()) {
            BlockPos.betweenClosedStream((int)-1, (int)-1, (int)-1, (int)2, (int)2, (int)2).map(BlockPos::immutable).map(blockPos -> blockPos.offset((Vec3i)this.blockPosition())).forEach(pos -> {
                BlockState state = this.level().getBlockState(pos);
                if (this.level().isEmptyBlock(pos) || state.is(BlockTags.SNOW) || state.is(BlockTags.ICE) || state.is(BlockTags.LEAVES)) {
                    this.level().setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState());
                }
            });
        }
    }
}

