/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.FlameBallProjectile;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityReciever;
import io.github.kadir1243.rivalrebels.common.util.ItemUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class EntityFlameBallGreen
extends FlameBallProjectile {
    public EntityFlameBallGreen(EntityType<? extends EntityFlameBallGreen> type, Level world) {
        super(type, world);
    }

    public EntityFlameBallGreen(Level level) {
        this((EntityType<? extends EntityFlameBallGreen>)((EntityType)RREntities.FLAME_BALL_GREEN.get()), level);
    }

    public EntityFlameBallGreen(Level level, double x, double y, double z) {
        this(level);
        this.setPos(x, y, z);
    }

    public EntityFlameBallGreen(Level level, Entity entity, float speed) {
        this(level);
        this.setOwner(entity);
        this.setPos(entity.getEyePosition());
        this.setDeltaMovement(-Mth.sin((float)(entity.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(entity.getXRot() * ((float)Math.PI / 180))), -Mth.sin((float)(entity.getXRot() * ((float)Math.PI / 180))), Mth.cos((float)(entity.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(entity.getXRot() * ((float)Math.PI / 180))));
        this.setPosRaw(this.getX() - (double)(Mth.cos((float)(entity.getYRot() * ((float)Math.PI / 180))) * 0.2f), this.getY() - 0.13, this.getZ() - (double)(Mth.sin((float)(entity.getYRot() * ((float)Math.PI / 180))) * 0.2f));
        this.setDeltaMovement(this.getDeltaMovement().scale((double)speed));
    }

    public EntityFlameBallGreen(Level level, TileEntityReciever ter, float speed) {
        this(level);
        this.setYRot(180.0f - ter.yaw);
        this.setXRot(-ter.pitch);
        this.setPos((double)((float)ter.getBlockPos().getX() + ter.xO) + 0.5, (double)ter.getBlockPos().getY() + 0.5, (double)((float)ter.getBlockPos().getZ() + ter.zO) + 0.5);
        this.setDeltaMovement(-Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180))), Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180))), -Mth.sin((float)(this.getXRot() * ((float)Math.PI / 180))));
        this.setDeltaMovement(this.getDeltaMovement().scale((double)speed));
    }

    public EntityFlameBallGreen(Level world, double x, double y, double z, double mx, double my, double mz) {
        this(world);
        this.setPos(x, y, z);
        this.setDeltaMovement(mx, my, mz);
    }

    public EntityFlameBallGreen(Level world, double x, double y, double z, double mx, double my, double mz, double d, double r) {
        this(world);
        this.setPos(x + mx * d + this.random.nextGaussian() * r, y + my * d + this.random.nextGaussian() * r, z + mz * d + this.random.nextGaussian() * r);
        this.setDeltaMovement(mx, my, mz);
    }

    public void tick() {
        HitResult hitResult;
        super.tick();
        if (this.tickCount > 100) {
            this.kill((ServerLevel)this.level());
        }
        if (this.tickCount % 3 == 0) {
            ++this.sequence;
        }
        if (this.sequence > 3) {
            this.sequence = 0;
        }
        if ((hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, entity -> entity.canBeCollidedWith((Entity)this))).getType() != HitResult.Type.MISS && this.tickCount >= 5) {
            this.fire();
            this.kill((ServerLevel)this.level());
            if (hitResult.getType() == HitResult.Type.ENTITY) {
                Entity entity2 = ((EntityHitResult)hitResult).getEntity();
                entity2.igniteForSeconds(3.0f);
                entity2.hurt(RivalRebelsDamageSource.cooked(this.level()), 12.0f);
                if (entity2 instanceof Player) {
                    Player player = (Player)entity2;
                    ItemUtil.damageRandomArmor((LivingEntity)player, 8, this.random);
                }
            }
        }
        this.setPosRaw(this.getX() + this.getDeltaMovement().x(), this.getY() + this.getDeltaMovement().y(), this.getZ() + this.getDeltaMovement().z());
        this.rotation += this.motionr;
        if (this.isInWater()) {
            this.kill((ServerLevel)this.level());
        }
        this.reapplyPosition();
    }

    private void fire() {
        if (!this.level().isClientSide()) {
            for (int x = -3; x < 4; ++x) {
                for (int y = -1; y < 2; ++y) {
                    for (int z = -3; z < 4; ++z) {
                        BlockPos pos = new BlockPos((int)this.getX() + x, (int)this.getY() + y, (int)this.getZ() + z);
                        BlockState state = this.level().getBlockState(pos);
                        if (!this.level().isEmptyBlock(pos) && !state.is(BlockTags.SNOW) && !state.is(BlockTags.ICE) && !state.is(BlockTags.LEAVES)) continue;
                        this.level().setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState());
                    }
                }
            }
        }
    }
}

