/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EntityGasGrenade
extends Projectile {
    public EntityGasGrenade(EntityType<? extends EntityGasGrenade> type, Level world) {
        super(type, world);
    }

    public EntityGasGrenade(Level level) {
        this((EntityType<? extends EntityGasGrenade>)((EntityType)RREntities.GAS_GRENADE.get()), level);
    }

    public EntityGasGrenade(Level level, double mx, double my, double mz) {
        this(level);
        this.yRotO = (float)(Math.atan2(mx, mz) * 57.2957763671875);
        this.setYRot(this.yRotO);
        this.xRotO = (float)(Math.atan2(my, Math.sqrt(mx * mx + mz * mz)) * 57.2957763671875);
        this.setXRot(this.xRotO);
    }

    public EntityGasGrenade(Level level, Entity player, float speed) {
        this(level);
        this.setOwner(player);
        this.snapTo(player.getEyePosition(), player.getYRot(), player.getXRot());
        this.setPos(this.getX() - (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.16f), this.getY() - (double)0.1f, this.getZ() - (double)(Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.16f));
        this.shootFromRotation(player, player.getXRot(), player.getYRot(), 0.0f, speed * 1.5f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setDeltaMovement(double x, double y, double z) {
        super.setDeltaMovement(x, y, z);
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            float var7 = Mth.sqrt((float)((float)(x * x + z * z)));
            this.yRotO = (float)(Math.atan2(x, z) * 57.2957763671875);
            this.setYRot(this.yRotO);
            this.xRotO = (float)(Math.atan2(y, var7) * 57.2957763671875);
            this.setXRot(this.xRotO);
            this.snapTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        HitResult hitResult;
        super.tick();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            float var1 = (float)this.getDeltaMovement().horizontalDistance();
            this.yRotO = (float)(Math.atan2(this.getDeltaMovement().x(), this.getDeltaMovement().z()) * 57.2957763671875);
            this.setYRot(this.yRotO);
            this.xRotO = (float)(Math.atan2(this.getDeltaMovement().y(), var1) * 57.2957763671875);
            this.setXRot(this.xRotO);
        }
        if ((hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0))).getType() != HitResult.Type.MISS && !this.level().isClientSide()) {
            this.pop();
            this.kill((ServerLevel)this.level());
        }
        this.setPosRaw(this.getX() + this.getDeltaMovement().x(), this.getY() + this.getDeltaMovement().y(), this.getZ() + this.getDeltaMovement().z());
        this.updateRotation();
        this.setXRot(this.getXRot() + 90.0f);
        if (this.getXRot() <= -270.0f) {
            this.setXRot(90.0f);
        }
        float var23 = 0.9999f;
        if (this.isInWater()) {
            for (int var26 = 0; var26 < 4; ++var26) {
                float var27 = 0.25f;
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() - this.getDeltaMovement().x() * (double)var27, this.getY() - this.getDeltaMovement().y() * (double)var27, this.getZ() - this.getDeltaMovement().z() * (double)var27, this.getDeltaMovement().x(), this.getDeltaMovement().y(), this.getDeltaMovement().z());
            }
            var23 = 0.8f;
        }
        this.setDeltaMovement(this.getDeltaMovement().scale((double)var23));
        this.applyGravity();
        this.reapplyPosition();
        this.applyEffectsFromBlocks();
    }

    public boolean isAttackable() {
        return false;
    }

    protected double getDefaultGravity() {
        return 0.03;
    }

    private void pop() {
        this.playSound((SoundEvent)RRSounds.GRENADE_UNKNOWN2.get());
        BlockPos.betweenClosedStream((int)-4, (int)-4, (int)-4, (int)4, (int)4, (int)4).map(pos -> pos.offset((Vec3i)this.blockPosition())).filter(pos -> this.level().isEmptyBlock(pos)).forEach(pos -> this.level().setBlockAndUpdate(pos, ((Block)RRBlocks.toxicgas.get()).defaultBlockState()));
    }
}

