/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.core.BlackList;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityPlasmoid
extends Projectile {
    public int rotation = 45;
    public float slide = 0.0f;

    public EntityPlasmoid(EntityType<? extends EntityPlasmoid> type, Level world) {
        super(type, world);
    }

    public EntityPlasmoid(Level level) {
        this((EntityType<? extends EntityPlasmoid>)((EntityType)RREntities.PLASMOID.get()), level);
        this.rotation = this.random.nextInt(360);
        this.slide = this.random.nextInt(21) - 10;
    }

    public EntityPlasmoid(Level level, double x, double y, double z) {
        this(level);
        this.setPos(x, y, z);
    }

    public EntityPlasmoid(Level level, Entity thrower, float speed, boolean drop) {
        this(level);
        this.setNoGravity(!drop);
        int n = this.isNoGravity() ? 1 : 3;
        this.setOwner(thrower);
        this.snapTo(thrower.getX() - (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.16f), thrower.getEyeY(), thrower.getZ() - (double)(Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.16f), thrower.getYRot(), thrower.getXRot());
        this.shootFromRotation(thrower, thrower.getXRot(), thrower.getYRot(), 0.0f, (speed *= (float)n) * 1.5f, 1.0f);
    }

    public EntityPlasmoid(Level world, double px, double py, double pz, double x, double y, double z, float d) {
        this(world);
        Vec3 vector = new Vec3(x, y, z);
        this.setPos(vector.add(px, py, pz).normalize().scale((double)d));
        this.setDeltaMovement(x, y, z);
        double var10 = vector.horizontalDistance();
        this.yRotO = (float)(Math.atan2(x, z) * 57.2957763671875);
        this.setYRot(this.yRotO);
        this.xRotO = (float)(Math.atan2(y, var10) * 57.2957763671875);
        this.setXRot(this.xRotO);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        HitResult mop;
        super.tick();
        this.applyGravity();
        ++this.tickCount;
        this.rotation += (int)this.slide;
        this.slide *= 0.9f;
        if (this.tickCount >= RRConfig.SERVER.getPlasmoidDecay() * (this.isNoGravity() ? 1 : 3)) {
            this.explode();
        }
        if ((mop = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0))).getType() != HitResult.Type.MISS) {
            this.explode();
        }
        this.setPosRaw(this.getX() + this.getDeltaMovement().x(), this.getY() + this.getDeltaMovement().y(), this.getZ() + this.getDeltaMovement().z());
        this.updateRotation();
        this.reapplyPosition();
    }

    protected double getDefaultGravity() {
        return 0.05;
    }

    protected void explode() {
        if (!this.level().isClientSide()) {
            this.kill((ServerLevel)this.level());
            BlockState state = Blocks.STONE.defaultBlockState();
            int i = -1;
            while ((state.canOcclude() || BlackList.plasmaExplosion(state)) && i < 4) {
                state = this.level().getBlockState(BlockPos.containing((Position)this.position().subtract(this.getDeltaMovement().scale((double)(++i)))));
            }
            this.level().setBlockAndUpdate(BlockPos.containing((Position)this.position().subtract(this.getDeltaMovement().scale((double)i))), ((Block)RRBlocks.plasmaexplosion.get()).defaultBlockState());
        }
    }
}

