/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;

public class EntityPropulsionFX
extends ThrowableProjectile {
    private int ticksInAir;

    public EntityPropulsionFX(EntityType<? extends EntityPropulsionFX> type, Level level) {
        super(type, level);
        this.setNoGravity(true);
    }

    public EntityPropulsionFX(Level level) {
        this((EntityType<? extends EntityPropulsionFX>)((EntityType)RREntities.PROPULSION_FX.get()), level);
        this.ticksInAir = 0;
    }

    public EntityPropulsionFX(Level level, double x, double y, double z) {
        this(level);
        this.setPos(x, y - 0.2, z);
    }

    public EntityPropulsionFX(Level level, double x, double y, double z, double mX, double mY, double mZ) {
        this(level);
        this.setPos(x, y, z);
        this.setDeltaMovement(mX, mY, mZ);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        ++this.ticksInAir;
        if (this.ticksInAir >= 5 && this.random.nextInt(2) == 1 || this.isInWater()) {
            this.kill((ServerLevel)this.level());
        }
        this.setPos(this.getX() + this.getDeltaMovement().x() + (this.random.nextDouble() - 0.5) * 0.07, this.getY() + this.getDeltaMovement().y() + (this.random.nextDouble() - 0.5) * 0.07 + 0.005, this.getZ() + this.getDeltaMovement().z() + (this.random.nextDouble() - 0.5) * 0.07);
    }
}

