/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.EntityGore;
import io.github.kadir1243.rivalrebels.common.entity.EntityRoddiskOfficer;
import io.github.kadir1243.rivalrebels.common.entity.EntityRoddiskRebel;
import io.github.kadir1243.rivalrebels.common.entity.EntityRoddiskRegular;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import io.github.kadir1243.rivalrebels.common.entity.RoddiskBase;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.util.ModBlockTags;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityRoddiskLeader
extends RoddiskBase {
    public EntityRoddiskLeader(EntityType<? extends EntityRoddiskLeader> type, Level level) {
        super(type, level);
    }

    public EntityRoddiskLeader(Level level) {
        this((EntityType<? extends EntityRoddiskLeader>)((EntityType)RREntities.RODDISK_LEADER.get()), level);
    }

    public EntityRoddiskLeader(Level level, Entity shooter, float speed) {
        super((EntityType<? extends RoddiskBase>)((EntityType)RREntities.RODDISK_LEADER.get()), level, shooter, speed);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void tick() {
        block20: {
            int n;
            EquipmentSlot[] var62;
            Player player;
            block23: {
                BlockState state;
                Direction side;
                BlockPos pos;
                block25: {
                    block24: {
                        BlockHitResult var3;
                        block21: {
                            Entity entityHit;
                            block22: {
                                if (this.tickCount > 100 && this.getOwner() == null && !this.level().isClientSide()) {
                                    this.kill((ServerLevel)this.level());
                                    this.playSound((SoundEvent)RRSounds.FORCE_FIELD.get());
                                }
                                if (this.tickCount >= 120 && !this.level().isClientSide() && this.getOwner() != null) {
                                    ItemEntity ei = new ItemEntity(this.level(), this.getOwner().getX(), this.getOwner().getY(), this.getOwner().getZ(), RRItems.roddisk.toStack());
                                    this.level().addFreshEntity((Entity)ei);
                                    this.kill((ServerLevel)this.level());
                                    this.playSound((SoundEvent)RRSounds.RODDISK_UNKNOWN1.get());
                                }
                                if (this.tickCount == 10) {
                                    this.playSound((SoundEvent)RRSounds.RODDISK_UNKNOWN0.get());
                                }
                                int radius = 2;
                                AABB aabb = new AABB(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ()).inflate((double)(radius + 1), (double)(-(radius + 1)), (double)(radius + 1));
                                List par9 = this.level().getEntities(null, aabb);
                                for (Entity var31 : par9) {
                                    if (!(var31 instanceof Arrow)) continue;
                                    var31.kill((ServerLevel)this.level());
                                }
                                Vec3 var15 = this.position();
                                Vec3 var2 = this.position().add(this.getDeltaMovement());
                                var3 = this.level().clip(new ClipContext(var15, var2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                                if (var3 != null) {
                                    var2 = var3.getLocation();
                                }
                                if (!this.level().isClientSide()) {
                                    Entity var4 = null;
                                    List var5 = this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0, 1.0, 1.0));
                                    double var62 = 0.0;
                                    for (Entity var9 : var5) {
                                        double var13;
                                        if (var9 instanceof EntityRoddiskRegular || var9 instanceof EntityRoddiskRebel) {
                                            var9.kill((ServerLevel)this.level());
                                            ItemEntity ei = new ItemEntity(this.level(), var9.getX(), var9.getY(), var9.getZ(), RRItems.roddisk.toStack());
                                            this.level().addFreshEntity((Entity)ei);
                                            continue;
                                        }
                                        if (var9 instanceof EntityRoddiskOfficer) {
                                            if (this.getDeltaMovement().x() + this.getDeltaMovement().y() + this.getDeltaMovement().z() >= var9.getDeltaMovement().x() + var9.getDeltaMovement().y() + var9.getDeltaMovement().z()) {
                                                var9.kill((ServerLevel)this.level());
                                            } else {
                                                this.kill((ServerLevel)this.level());
                                            }
                                            ItemEntity ei = new ItemEntity(this.level(), var9.getX(), var9.getY(), var9.getZ(), RRItems.roddisk.toStack());
                                            this.level().addFreshEntity((Entity)ei);
                                            continue;
                                        }
                                        if (!var9.canBeCollidedWith((Entity)this) || this.ownedBy(var9)) continue;
                                        float var10 = 0.3f;
                                        AABB var11 = var9.getBoundingBox().inflate((double)var10, (double)var10, (double)var10);
                                        Optional var12 = var11.clip(var15, var2);
                                        if (!var12.isPresent() || !((var13 = var15.distanceTo((Vec3)var12.get())) < var62) && var62 != 0.0) continue;
                                        var4 = var9;
                                        var62 = var13;
                                    }
                                    if (var4 != null) {
                                        var3 = new EntityHitResult(var4);
                                    }
                                }
                                if (var3 == null) break block20;
                                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, var3.getLocation().x, var3.getLocation().y, var3.getLocation().z, this.getDeltaMovement().x() * 0.1, this.getDeltaMovement().y() * 0.1, this.getDeltaMovement().z() * 0.1);
                                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, var3.getLocation().x, var3.getLocation().y, var3.getLocation().z, this.getDeltaMovement().x() * 0.1, this.getDeltaMovement().y() * 0.1, this.getDeltaMovement().z() * 0.1);
                                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, var3.getLocation().x, var3.getLocation().y, var3.getLocation().z, this.getDeltaMovement().x() * 0.1, this.getDeltaMovement().y() * 0.1, this.getDeltaMovement().z() * 0.1);
                                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, var3.getLocation().x, var3.getLocation().y, var3.getLocation().z, this.getDeltaMovement().x() * 0.1, this.getDeltaMovement().y() * 0.1, this.getDeltaMovement().z() * 0.1);
                                if (var3.getType() != HitResult.Type.ENTITY) break block21;
                                entityHit = ((EntityHitResult)var3).getEntity();
                                this.playSound((SoundEvent)RRSounds.ROD_DISK_HIT_ENTITY.get());
                                if (!(entityHit instanceof Player)) break block22;
                                player = (Player)entityHit;
                                if (!(this.getOwner() instanceof Player) || entityHit == this.getOwner()) break block22;
                                var62 = EquipmentSlot.values();
                                n = var62.length;
                                break block23;
                            }
                            entityHit.hurt(RivalRebelsDamageSource.tron(this.level()), 15.0f);
                            if (entityHit instanceof Skeleton) {
                                entityHit.kill((ServerLevel)this.level());
                                this.level().addFreshEntity((Entity)new EntityGore(this.level(), entityHit, 0, 3));
                                this.level().addFreshEntity((Entity)new EntityGore(this.level(), entityHit, 1, 3));
                                this.level().addFreshEntity((Entity)new EntityGore(this.level(), entityHit, 2, 3));
                                this.level().addFreshEntity((Entity)new EntityGore(this.level(), entityHit, 2, 3));
                                this.level().addFreshEntity((Entity)new EntityGore(this.level(), entityHit, 3, 3));
                                this.level().addFreshEntity((Entity)new EntityGore(this.level(), entityHit, 3, 3));
                            }
                            if (!(entityHit instanceof Zombie) || entityHit instanceof ZombifiedPiglin) break block20;
                            entityHit.kill((ServerLevel)this.level());
                            this.level().addFreshEntity((Entity)new EntityGore(this.level(), entityHit, 0, 1));
                            this.level().addFreshEntity((Entity)new EntityGore(this.level(), entityHit, 1, 1));
                            this.level().addFreshEntity((Entity)new EntityGore(this.level(), entityHit, 2, 1));
                            this.level().addFreshEntity((Entity)new EntityGore(this.level(), entityHit, 2, 1));
                            this.level().addFreshEntity((Entity)new EntityGore(this.level(), entityHit, 3, 1));
                            this.level().addFreshEntity((Entity)new EntityGore(this.level(), entityHit, 3, 1));
                            break block20;
                        }
                        if (var3.getType() != HitResult.Type.BLOCK) break block20;
                        pos = var3.getBlockPos();
                        side = var3.getDirection();
                        state = this.level().getBlockState(pos);
                        if (!state.is(RRBlocks.flare)) break block24;
                        state.getBlock().destroy((LevelAccessor)this.level(), pos, state);
                        break block20;
                    }
                    if (!state.is(RRBlocks.landmine) && !state.is(RRBlocks.alandmine)) break block25;
                    state.entityInside(this.level(), pos, (Entity)this, InsideBlockEffectApplier.NOOP);
                    break block20;
                }
                if (state.is(ModBlockTags.GLASS_BLOCKS) || state.is(ModBlockTags.GLASS_PANES)) {
                    this.level().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                }
                this.playSound((SoundEvent)RRSounds.ROD_DISK_MIRROR_FROM_OBJECT.get());
                if (side == Direction.EAST || side == Direction.WEST) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(-1.0, 1.0, 1.0));
                }
                if (side == Direction.UP || side == Direction.DOWN) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -1.0, 1.0));
                }
                if (side != Direction.NORTH && side != Direction.SOUTH) break block20;
                this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 1.0, -1.0));
                break block20;
            }
            for (int i = 0; i < n; ++i) {
                EquipmentSlot slot = var62[i];
                if (!slot.isArmor()) {
                    return;
                }
                ItemStack armorStack = player.getItemBySlot(slot);
                if (!armorStack.isEmpty()) {
                    armorStack.hurtAndBreak(30, (LivingEntity)player, slot);
                    player.hurt(RivalRebelsDamageSource.tron(this.level()), 1.0f);
                    continue;
                }
                player.hurt(RivalRebelsDamageSource.tron(this.level()), 15.0f);
            }
        }
        this.setPosRaw(this.getX() + this.getDeltaMovement().x(), this.getY() + this.getDeltaMovement().y(), this.getZ() + this.getDeltaMovement().z());
        this.updateRotation();
        if (this.getOwner() != null) {
            this.setDeltaMovement(this.getDeltaMovement().add((this.getOwner().getX() - this.getX()) * (double)0.01f, (this.getOwner().getY() + 1.62 - this.getY()) * (double)0.01f, (this.getOwner().getZ() - this.getZ()) * (double)0.01f));
        }
        this.setDeltaMovement(this.getDeltaMovement().scale((double)0.995f));
        this.reapplyPosition();
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.tickCount < 10 || player != this.getOwner()) {
            return InteractionResult.PASS;
        }
        if (player.getInventory().add(RRItems.roddisk.toStack())) {
            this.kill((ServerLevel)this.level());
            this.playSound((SoundEvent)RRSounds.RODDISK_UNKNOWN1.get());
        }
        return InteractionResult.SUCCESS;
    }
}

