/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodes;
import io.github.kadir1243.rivalrebels.common.entity.EntityTsarBlast;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntitySphereBlast
extends EntityTsarBlast {
    public EntitySphereBlast(EntityType<? extends EntitySphereBlast> type, Level world) {
        super((EntityType<? extends EntityTsarBlast>)type, world);
    }

    public EntitySphereBlast(Level level) {
        this((EntityType<? extends EntitySphereBlast>)((EntityType)RREntities.SPHERE_BLAST.get()), level);
    }

    public EntitySphereBlast(Level level, double x, double y, double z, float rad) {
        this(level);
        this.radius = rad;
        this.setDeltaMovement(Math.sqrt(rad - (float)RRConfig.SERVER.getTsarBombaStrength()) / 10.0, this.getDeltaMovement().y(), this.getDeltaMovement().z());
        this.setPos(x, y, z);
    }

    @Override
    public void tick() {
        if (this.random.nextInt(10) == 0) {
            this.playSound(SoundEvents.LIGHTNING_BOLT_THUNDER, 10.0f, 0.5f);
        } else if (this.random.nextInt(5) == 0) {
            this.playSound((SoundEvent)RRSounds.TIMED_BOMB_SOUND.get(), 100.0f, 0.7f);
        }
        if (this.random.nextBoolean() && this.random.nextBoolean()) {
            this.pushAndHurtEntities();
        }
        ++this.tickCount;
        if (this.tickCount > 400) {
            this.kill((ServerLevel)this.level());
        }
    }

    @Override
    public void pushAndHurtEntities() {
        AABB aabb = new AABB(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ()).inflate(this.radius + 1.0, -(this.radius + 1.0), this.radius + 1.0);
        List var9 = this.level().getEntities((Entity)this, aabb);
        for (Entity entity : var9) {
            if (entity instanceof LivingEntity) {
                Vec3 vec3;
                if (entity instanceof Player && ((Player)entity).isCreative()) continue;
                double var13 = Math.sqrt(entity.distanceToSqr(this.getX(), this.getY(), this.getZ())) / this.radius;
                if (var13 <= 1.0 && (vec3 = entity.getEyePosition().subtract(this.position())).length() != 0.0) {
                    vec3 = vec3.normalize();
                    double var34 = 1.0 - var13;
                    entity.hurt(RivalRebelsDamageSource.nuclearBlast(this.level()), (float)((int)((var34 * var34 + var34) * 20.0 * this.radius + 20.0) * 200));
                    entity.setDeltaMovement(entity.getDeltaMovement().subtract(vec3.scale(var34 * 8.0)));
                }
            }
            if (!(entity instanceof EntityRhodes)) continue;
            entity.hurt(RivalRebelsDamageSource.nuclearBlast(this.level()), 30.0f);
        }
    }
}

