/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.AbstractBlastEntity;
import io.github.kadir1243.rivalrebels.common.entity.EntityB83;
import io.github.kadir1243.rivalrebels.common.entity.EntityHackB83;
import io.github.kadir1243.rivalrebels.common.entity.EntityNuclearBlast;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodes;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import io.github.kadir1243.rivalrebels.common.explosion.TsarBomba;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityTsarBlast
extends AbstractBlastEntity<TsarBomba> {
    List<Entity> entitylist = new ArrayList<Entity>();

    public EntityTsarBlast(EntityType<? extends EntityTsarBlast> type, Level world) {
        super(type, world);
    }

    public EntityTsarBlast(Level level) {
        this((EntityType<? extends EntityTsarBlast>)((EntityType)RREntities.TSAR_BLAST.get()), level);
    }

    public EntityTsarBlast(Level level, float x, float y, float z, TsarBomba tsarBomba, int rad) {
        this(level);
        this.bomb = tsarBomba;
        this.radius = rad;
        this.setDeltaMovement(Math.sqrt(this.radius - (double)RRConfig.SERVER.getTsarBombaStrength()) / 10.0, this.getDeltaMovement().y(), this.getDeltaMovement().z());
        this.setPos(x, y, z);
    }

    public EntityTsarBlast(Level level, double x, double y, double z, float rad) {
        this(level);
        this.radius = rad;
        this.setDeltaMovement(Math.sqrt(rad - (float)RRConfig.SERVER.getTsarBombaStrength()) / 10.0, this.getDeltaMovement().y(), this.getDeltaMovement().z());
        this.setPos(x, y, z);
    }

    public void tick() {
        super.tick();
        if (this.random.nextInt(10) == 0) {
            this.playSound(SoundEvents.LIGHTNING_BOLT_THUNDER, 10.0f, 0.5f);
        } else if (this.random.nextInt(5) == 0) {
            this.playSound((SoundEvent)RRSounds.TIMED_BOMB_SOUND.get(), 100.0f, 0.7f);
        }
        if (!this.level().isClientSide()) {
            if (this.bomb == null && this.tickCount > 1200) {
                this.kill((ServerLevel)this.level());
            }
            if (this.tickCount % 20 == 0) {
                this.updateEntityList();
            }
            if (this.tickCount < 1200 && this.tickCount % 5 == 0) {
                this.pushAndHurtEntities();
            }
            for (int i = 0; i < RRConfig.SERVER.getTsarBombaSpeed() * 2; ++i) {
                if (this.bomb == null) {
                    return;
                }
                ((TsarBomba)this.bomb).tick(this);
            }
        }
    }

    public void updateEntityList() {
        this.entitylist.clear();
        double ldist = this.radius * this.radius;
        List entities = this.level().getEntities((Entity)this, AABB.of((BoundingBox)BoundingBox.infinite()));
        for (Entity e : entities) {
            double dist = e.distanceToSqr(this.getX(), this.getY(), this.getZ());
            if (!(dist < ldist) || e.isInvulnerable() || e instanceof EntityNuclearBlast || e instanceof EntityTsarBlast) continue;
            this.entitylist.add(e);
        }
    }

    public void pushAndHurtEntities() {
        ArrayList<Entity> remove = new ArrayList<Entity>();
        float invrad = 1.0f / (float)this.radius;
        for (Entity e : this.entitylist) {
            if (!e.isAlive() || e.isInvulnerable()) {
                remove.add(e);
                continue;
            }
            Vec3 dpos = e.position().subtract(this.position());
            float dist = (float)dpos.length();
            float rsqrt = 1.0f / (dist + 1.0E-4f);
            dpos = dpos.scale((double)rsqrt);
            double f = 40.0f * (1.0f - dist * invrad) * (e instanceof EntityB83 || e instanceof EntityHackB83 ? -1.0f : 1.0f);
            if (e instanceof EntityRhodes) {
                e.hurt(RivalRebelsDamageSource.nuclearBlast(this.level()), (float)((int)(this.radius * f * (double)0.025f)));
                continue;
            }
            e.hurt(RivalRebelsDamageSource.nuclearBlast(this.level()), (float)((int)(f * f * 2.0 * this.radius + 20.0)));
            e.setDeltaMovement(this.getDeltaMovement().subtract(dpos.scale(f)));
        }
        for (Entity e : remove) {
            this.entitylist.remove(e);
        }
    }

    public EntityTsarBlast setTime() {
        this.tickCount = 920;
        return this;
    }
}

