/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity.brain;

import com.google.common.collect.ImmutableList;
import io.github.kadir1243.rivalrebels.RivalRebels;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodes;
import io.github.kadir1243.rivalrebels.common.entity.brain.Activities;
import io.github.kadir1243.rivalrebels.common.entity.brain.RotateToTarget;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsPlayer;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsTeam;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;

public class IdleBrain
extends Behavior<EntityRhodes> {
    private int counter = 1;

    public IdleBrain() {
        super(Map.of(MemoryModuleType.UNIVERSAL_ANGER, MemoryStatus.REGISTERED), 1);
    }

    protected void tick(ServerLevel level, EntityRhodes owner, long gameTime) {
        super.tick(level, (LivingEntity)owner, gameTime);
        if (owner.raidedOmegaAlready == owner.raidedSigmaAlready) {
            owner.raidedOmegaAlready = false;
            owner.raidedSigmaAlready = false;
        }
        Brain<EntityRhodes> brain = owner.getBrain();
        RandomSource random = owner.getRandom();
        if (owner.endangered && RivalRebels.round.isStarted()) {
            if (owner.teamToRaid == RivalRebelsTeam.NONE) {
                if (owner.raidedOmegaAlready && RivalRebels.round.sigmaData.health > 0) {
                    owner.teamToRaid = RivalRebelsTeam.SIGMA;
                } else if (owner.raidedSigmaAlready && RivalRebels.round.omegaData.health > 0) {
                    owner.teamToRaid = RivalRebelsTeam.OMEGA;
                } else if (RivalRebels.round.omegaData.health > 0 && RivalRebels.round.sigmaData.health > 0) {
                    int o = 0;
                    int s = 0;
                    for (RivalRebelsPlayer rrp : RivalRebels.round.rrplayerlist.players()) {
                        if (rrp.rrteam == RivalRebelsTeam.OMEGA) {
                            ++o;
                            continue;
                        }
                        if (rrp.rrteam != RivalRebelsTeam.SIGMA) continue;
                        ++s;
                    }
                    if (o > s) {
                        owner.teamToRaid = RivalRebelsTeam.OMEGA;
                        owner.raidedOmegaAlready = true;
                    }
                    if (o < s) {
                        owner.teamToRaid = RivalRebelsTeam.SIGMA;
                        owner.raidedSigmaAlready = true;
                    }
                    if (o == s) {
                        RivalRebelsTeam rivalRebelsTeam = owner.teamToRaid = random.nextBoolean() ? RivalRebelsTeam.SIGMA : RivalRebelsTeam.OMEGA;
                        if (owner.teamToRaid == RivalRebelsTeam.OMEGA) {
                            owner.raidedOmegaAlready = true;
                        } else {
                            owner.raidedSigmaAlready = true;
                        }
                    }
                }
            }
            if (owner.teamToRaid != RivalRebelsTeam.NONE) {
                float dz;
                float dx = (float)((double)(owner.teamToRaid == RivalRebelsTeam.OMEGA ? RivalRebels.round.omegaData.objPos().getX() : RivalRebels.round.sigmaData.objPos().getX()) - owner.getX());
                float angle = (EntityRhodes.atan2(dx, dz = (float)((double)(owner.teamToRaid == RivalRebelsTeam.OMEGA ? RivalRebels.round.omegaData.objPos().getZ() : RivalRebels.round.sigmaData.objPos().getZ()) - owner.getZ())) - owner.bodyyaw) % 360.0f;
                if (angle > 1.0f) {
                    brain.addActivity(Activity.INVESTIGATE, 0, ImmutableList.of((Object)((Object)new RotateToTarget((int)Mth.abs((float)angle), true))));
                } else if (angle < -1.0f) {
                    brain.addActivity(Activity.INVESTIGATE, 0, ImmutableList.of((Object)((Object)new RotateToTarget((int)Mth.abs((float)angle), false))));
                } else {
                    float d = Mth.abs((float)dx) + Mth.abs((float)dz);
                    if (d < 5.0f) {
                        owner.playSound((SoundEvent)RRSounds.MANDELEED.get(), 900.0f, 1.0f);
                        brain.setActiveActivityIfPossible(Activity.RAID);
                    } else if (d > 50.0f && random.nextBoolean()) {
                        brain.setActiveActivityIfPossible((Activity)Activities.SHOOT_AND_ROTATE.get());
                        owner.flying = 50;
                    } else {
                        owner.shootAllWeapons();
                        owner.doWalkingAnimation();
                    }
                }
                brain.setActiveActivityIfPossible(Activity.IDLE);
            }
        } else {
            Entity t = owner.findTarget();
            if (t != null) {
                float dz;
                float dx = (float)(t.getX() - owner.getX());
                float angle = (EntityRhodes.atan2(dx, dz = (float)(t.getZ() - owner.getZ())) - owner.bodyyaw) % 360.0f;
                if (angle > 1.0f && random.nextBoolean()) {
                    brain.addActivity(Activity.INVESTIGATE, 0, ImmutableList.of((Object)((Object)new RotateToTarget((int)Mth.abs((float)angle), true))));
                } else if (angle < -1.0f && random.nextBoolean()) {
                    brain.addActivity(Activity.INVESTIGATE, 0, ImmutableList.of((Object)((Object)new RotateToTarget((int)Mth.abs((float)angle), false))));
                } else if (random.nextInt(20) < (owner.endangered ? 2 : 1)) {
                    brain.setActiveActivityIfPossible((Activity)Activities.SHOOT_AND_ROTATE.get());
                    owner.flying = 50;
                } else {
                    owner.shootAllWeapons();
                    owner.doWalkingAnimation();
                }
                brain.setActiveActivityIfPossible(Activity.IDLE);
            } else {
                owner.rightthighpitch = EntityRhodes.approach(owner.rightthighpitch, 0.0f);
                owner.leftthighpitch = EntityRhodes.approach(owner.leftthighpitch, 0.0f);
                owner.rightshinpitch = EntityRhodes.approach(owner.rightshinpitch, 0.0f);
                owner.leftshinpitch = EntityRhodes.approach(owner.leftshinpitch, 0.0f);
                owner.rightarmpitch = EntityRhodes.approach(owner.rightarmpitch, 0.0f);
                owner.leftarmpitch = EntityRhodes.approach(owner.leftarmpitch, 0.0f);
                owner.rightarmyaw = EntityRhodes.approach(owner.rightarmyaw, 0.0f);
                owner.leftarmyaw = EntityRhodes.approach(owner.leftarmyaw, 0.0f);
                owner.headpitch = EntityRhodes.approach(owner.headpitch, 0.0f);
                ++this.counter;
            }
        }
        --this.counter;
    }

    protected boolean canStillUse(ServerLevel level, EntityRhodes entity, long gameTime) {
        return (super.canStillUse(level, (LivingEntity)entity, gameTime) || this.counter > 0) && entity.getBrain().isMemoryValue(MemoryModuleType.UNIVERSAL_ANGER, (Object)true);
    }

    protected boolean timedOut(long gameTime) {
        return super.timedOut(gameTime) || this.counter < 0;
    }
}

