/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity.brain;

import io.github.kadir1243.rivalrebels.common.entity.EntityB83NoShroom;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodes;
import io.github.kadir1243.rivalrebels.common.entity.EntitySeekB83;
import io.github.kadir1243.rivalrebels.common.entity.EntityTsar;
import io.github.kadir1243.rivalrebels.common.entity.brain.MemoryModuleTypes;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ShootRocket
extends Behavior<EntityRhodes> {
    private int lastshot;
    private int shotstaken;
    boolean nuke = false;

    public ShootRocket() {
        super(Map.of(MemoryModuleType.ATTACK_TARGET, MemoryStatus.REGISTERED, (MemoryModuleType)MemoryModuleTypes.ROCKET_BLOCK_TARGET.get(), MemoryStatus.REGISTERED));
    }

    protected void start(ServerLevel level, EntityRhodes entity, long gameTime) {
        super.start(level, (LivingEntity)entity, gameTime);
        entity.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).ifPresent(livingEntity -> entity.setPose(Pose.SHOOTING));
    }

    protected void stop(ServerLevel level, EntityRhodes entity, long gameTime) {
        super.stop(level, (LivingEntity)entity, gameTime);
        if (entity.getPose() == Pose.SHOOTING) {
            entity.setPose(Pose.STANDING);
        }
    }

    protected void tick(ServerLevel level, EntityRhodes owner, long gameTime) {
        super.tick(level, (LivingEntity)owner, gameTime);
        float syaw = Mth.sin((float)(owner.bodyyaw * ((float)Math.PI / 180)));
        float cyaw = Mth.cos((float)(owner.bodyyaw * ((float)Math.PI / 180)));
        this.shootRocketsAtBestTarget(owner, -syaw, cyaw);
        Brain<EntityRhodes> brain = owner.getBrain();
        if (brain.getMemory(MemoryModuleType.ATTACK_TARGET).filter(arg_0 -> ((EntityRhodes)owner).canAttack(arg_0)).isEmpty()) {
            brain.eraseMemory(MemoryModuleType.ATTACK_TARGET);
        }
        if (brain.getMemory((MemoryModuleType)MemoryModuleTypes.ROCKET_BLOCK_TARGET.get()).filter(Predicate.not(BlockEntity::isRemoved)).isEmpty()) {
            brain.eraseMemory((MemoryModuleType)MemoryModuleTypes.ROCKET_BLOCK_TARGET.get());
        }
    }

    private void shootRocketsAtBestTarget(EntityRhodes owner, float syaw, float cyaw) {
        if (owner.getRocketCount() < 0) {
            return;
        }
        LivingEntity targetEntity = owner.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
        BlockEntity targetBlock = owner.getBrain().getMemory((MemoryModuleType)MemoryModuleTypes.ROCKET_BLOCK_TARGET.get()).orElse(null);
        float px = (float)owner.getX() + cyaw * 6.4f * owner.getScale();
        float py = (float)owner.getY() + 6.26759f * owner.getScale();
        float pz = (float)owner.getZ() + syaw * 6.4f * owner.getScale();
        if (targetBlock != null && !this.nuke) {
            float x = px - (float)targetBlock.getBlockPos().getX();
            float y = py - (float)targetBlock.getBlockPos().getY();
            float z = pz - (float)targetBlock.getBlockPos().getZ();
            float yaw = (EntityRhodes.atan2(x, z) - owner.bodyyaw + 630.0f) % 360.0f - 90.0f;
            float pitch = -EntityRhodes.atan2(Mth.sqrt((float)(x * x + z * z)), y);
            boolean pointing = true;
            if (Mth.abs((float)(owner.leftarmyaw - yaw)) >= 0.001f) {
                owner.leftarmyaw += Math.max(-3.0f, Math.min(3.0f, yaw - owner.leftarmyaw));
                pointing = Mth.abs((float)(owner.leftarmyaw - yaw)) < 3.0f ? (pointing &= true) : false;
            }
            if (Mth.abs((float)(owner.leftarmpitch - pitch)) >= 0.001f) {
                owner.leftarmpitch += Math.max(-3.0f, Math.min(3.0f, pitch - owner.leftarmpitch));
                pointing = Mth.abs((float)(owner.leftarmpitch - pitch)) < 3.0f ? (pointing &= true) : false;
            }
            if (pointing && owner.tickCount - this.lastshot > ((double)owner.getScale() >= 2.0 ? 30 : (this.shotstaken == 21 ? 80 : 5))) {
                owner.setRocketCount(owner.getRocketCount() - 1);
                this.lastshot = owner.tickCount;
                if (this.shotstaken == 21) {
                    this.shotstaken = 0;
                }
                ++this.shotstaken;
                float cp = -0.5f / Mth.sqrt((float)(x * x + y * y + z * z));
                if ((double)owner.getScale() >= 2.0) {
                    owner.level().addFreshEntity((Entity)new EntityB83NoShroom(owner.level(), (double)px, (double)py, (double)pz, (double)(x * cp), (double)(y * cp), (double)(z * cp)));
                } else {
                    owner.level().addFreshEntity((Entity)new EntitySeekB83(owner.level(), px, py, pz, x * cp, y * cp, z * cp));
                }
            }
        } else if (targetEntity != null && targetEntity.canBeSeenAsEnemy()) {
            float x = px - (float)targetEntity.getX();
            float y = py - (float)targetEntity.getY();
            float z = pz - (float)targetEntity.getZ();
            float yaw = (EntityRhodes.atan2(x, z) - owner.bodyyaw + 630.0f) % 360.0f - 90.0f;
            float pitch = -EntityRhodes.atan2(Mth.sqrt((float)(x * x + z * z)), y);
            boolean pointing = true;
            if (Mth.abs((float)(owner.leftarmyaw - yaw)) >= 0.001f) {
                owner.leftarmyaw += Math.max(-3.0f, Math.min(3.0f, yaw - owner.leftarmyaw));
                pointing = Mth.abs((float)(owner.leftarmyaw - yaw)) < 3.0f ? (pointing &= true) : false;
            }
            if (Mth.abs((float)(owner.leftarmpitch - pitch)) >= 0.001f) {
                owner.leftarmpitch += Math.max(-3.0f, Math.min(3.0f, pitch - owner.leftarmpitch));
                pointing = Mth.abs((float)(owner.leftarmpitch - pitch)) < 3.0f ? (pointing &= true) : false;
            }
            if (targetEntity.getMaxHealth() > 1000.0f) {
                if (pointing && owner.tickCount % 100 == 0) {
                    float cp = -0.5f / Mth.sqrt((float)(x * x + y * y + z * z));
                    if ((double)owner.getScale() >= 2.0) {
                        owner.level().addFreshEntity((Entity)new EntityTsar(owner.level(), px, py, pz, x * cp * 5.0f, y * cp * 5.0f, z * cp * 5.0f));
                    } else {
                        owner.level().addFreshEntity((Entity)new EntityB83NoShroom(owner.level(), (double)px, (double)py, (double)pz, (double)(x * cp), (double)(y * cp), (double)(z * cp)));
                    }
                }
            } else if (pointing && owner.tickCount - this.lastshot > ((double)owner.getScale() >= 2.0 ? 30 : (this.shotstaken == 21 ? 80 : 5))) {
                owner.setRocketCount(owner.getRocketCount() - 1);
                this.lastshot = owner.tickCount;
                if (this.shotstaken == 21) {
                    this.shotstaken = 0;
                }
                ++this.shotstaken;
                float cp = -0.5f / Mth.sqrt((float)(x * x + y * y + z * z));
                if ((double)owner.getScale() >= 2.0) {
                    owner.level().addFreshEntity((Entity)new EntityB83NoShroom(owner.level(), (double)px, (double)py, (double)pz, (double)(x * cp), (double)(y * cp), (double)(z * cp)));
                } else {
                    owner.level().addFreshEntity((Entity)new EntitySeekB83(owner.level(), px, py, pz, x * cp, y * cp, z * cp));
                }
            }
        }
    }
}

