/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.explosion;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.RivalRebels;
import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.block.trap.BlockPetrifiedStone;
import io.github.kadir1243.rivalrebels.common.block.trap.BlockPetrifiedWood;
import io.github.kadir1243.rivalrebels.common.entity.EntityTsarBlast;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TsarBomba {
    public int posX;
    public int posY;
    public int posZ;
    public int lastposX = 0;
    public int lastposZ = 0;
    public int radius;
    public Level world;
    private int n = 1;
    private int nlimit;
    private int shell;
    private int leg;
    private int element;
    private int repeatCount = 0;
    private boolean isTree;
    private int treeHeight;

    public TsarBomba(int x, int y, int z, Level world, int rad) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.world = world;
        this.radius = rad;
        this.nlimit = (this.radius + 25) * (this.radius + 25) * 4;
        if (world.isClientSide()) {
            return;
        }
        int clamprad = this.radius;
        BlockPos.betweenClosedStream((int)(-clamprad), (int)world.getMinY(), (int)(-clamprad), (int)clamprad, (int)(this.posY + 70), (int)clamprad).map(BlockPos::immutable).filter(blockPos -> Vec3.atLowerCornerOf((Vec3i)blockPos).horizontalDistanceSqr() < (double)(this.radius * this.radius)).map(pos -> pos.offset(x, 0, z)).forEach(offset -> {
            BlockState state = world.getBlockState(offset);
            if (!state.getFluidState().isEmpty() && !state.is(BlockTags.FEATURES_CANNOT_REPLACE)) {
                world.destroyBlock(offset, false);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public void tick(EntityTsarBlast tsarblast) {
        if (this.n > 0 && this.n < this.nlimit) {
            boolean repeat = this.processChunk(this.lastposX, this.lastposZ);
            this.shell = Mth.floor((float)((Mth.sqrt((float)this.n) + 1.0f) / 2.0f));
            int shell2 = 2 * this.shell;
            this.leg = Mth.floor((float)((this.n - (shell2 - 1) * (shell2 - 1)) / shell2));
            this.element = this.n - (shell2 - 1) * (shell2 - 1) - shell2 * this.leg - this.shell + 1;
            int n = this.leg == 0 ? this.shell : (this.leg == 1 ? -this.element : (this.lastposX = this.leg == 2 ? -this.shell : this.element));
            this.lastposZ = this.leg == 0 ? this.element : (this.leg == 1 ? this.shell : (this.leg == 2 ? -this.element : -this.shell));
            ++this.n;
            if (repeat) return;
            ++this.repeatCount;
            if (this.repeatCount < RRConfig.SERVER.getTsarBombaSpeed() * 2) {
                this.tick(tsarblast);
                return;
            }
            this.repeatCount = 0;
            return;
        }
        tsarblast.bomb = null;
        tsarblast.kill((ServerLevel)this.world);
    }

    private boolean processChunk(int x, int z) {
        double dist = x * x + z * z;
        if (dist < (double)(this.radius * this.radius)) {
            dist = Math.sqrt(dist);
            int y = this.getTopBlock(x + this.posX, z + this.posZ, dist);
            float yele = (float)this.posY + (float)(y - this.posY) * 0.5f;
            if (RRConfig.SERVER.isElevation()) {
                yele = y;
            }
            int ylimit = Mth.floor((double)((double)yele - ((double)this.radius - dist) / 2.0 + Math.sin(dist * 0.5) * 1.15));
            for (int Y = y; Y > ylimit && Y != this.world.getMinY(); --Y) {
                BlockPos pos = new BlockPos(x + this.posX, Y, z + this.posZ);
                BlockState state = this.world.getBlockState(pos);
                if (state.is(RRBlocks.omegaobj)) {
                    RivalRebels.round.winSigma();
                } else if (state.is(RRBlocks.sigmaobj)) {
                    RivalRebels.round.winOmega();
                }
                this.world.destroyBlock(pos, false);
            }
            double limit = (double)(this.radius / 2 + this.world.random.nextInt(this.radius / 4)) + 7.5;
            if (dist < limit) {
                int blockType = this.world.random.nextInt(4) + 1;
                if (x >= 0 && z < 0) {
                    blockType = 1;
                }
                if (x > 0 && z >= 0) {
                    blockType = 2;
                }
                if (x <= 0 && z > 0) {
                    blockType = 3;
                }
                if (x < 0 && z <= 0) {
                    blockType = 4;
                }
                int metadata = Mth.ceil((double)(16.0 / limit * dist));
                if ((metadata -= this.radius / 10 - 1) < 0) {
                    metadata = -metadata;
                }
                if (++metadata > 15) {
                    metadata = 15;
                }
                for (int Y = ylimit; Y > ylimit - (this.world.random.nextInt(5) + 2) && Y != this.world.getMinY(); --Y) {
                    BlockPos pos = new BlockPos(x + this.posX, Y, z + this.posZ);
                    BlockState state = this.world.getBlockState(pos);
                    if (state.is(RRBlocks.omegaobj)) {
                        RivalRebels.round.winSigma();
                    } else if (state.is(RRBlocks.sigmaobj)) {
                        RivalRebels.round.winOmega();
                    }
                    if (blockType == 1) {
                        this.world.setBlockAndUpdate(pos, (BlockState)((Block)RRBlocks.petrifiedstone1.get()).defaultBlockState().setValue((Property)BlockPetrifiedStone.META, (Comparable)Integer.valueOf(metadata)));
                        continue;
                    }
                    if (blockType == 2) {
                        this.world.setBlockAndUpdate(pos, (BlockState)((Block)RRBlocks.petrifiedstone2.get()).defaultBlockState().setValue((Property)BlockPetrifiedStone.META, (Comparable)Integer.valueOf(metadata)));
                        continue;
                    }
                    if (blockType == 3) {
                        this.world.setBlockAndUpdate(pos, (BlockState)((Block)RRBlocks.petrifiedstone3.get()).defaultBlockState().setValue((Property)BlockPetrifiedStone.META, (Comparable)Integer.valueOf(metadata)));
                        continue;
                    }
                    this.world.setBlockAndUpdate(pos, (BlockState)((Block)RRBlocks.petrifiedstone4.get()).defaultBlockState().setValue((Property)BlockPetrifiedStone.META, (Comparable)Integer.valueOf(metadata)));
                }
            }
            if (this.isTree) {
                this.isTree = false;
                int metadata = Mth.floor((double)(16.0 / (double)this.radius * dist));
                if (metadata < 0) {
                    metadata = 0;
                }
                if (++metadata > 15) {
                    metadata = 15;
                }
                for (int Y = ylimit; Y > ylimit - this.treeHeight && Y != this.world.getMinY(); --Y) {
                    this.world.setBlockAndUpdate(new BlockPos(x + this.posX, Y, z + this.posZ), (BlockState)((Block)RRBlocks.petrifiedwood.get()).defaultBlockState().setValue((Property)BlockPetrifiedWood.META, (Comparable)Integer.valueOf(metadata)));
                }
            }
            return true;
        }
        if (dist <= (double)(this.radius * this.radius) * 1.3125 * 1.3125) {
            dist = Math.sqrt(dist);
            int y = this.getTopBlock(x + this.posX, z + this.posZ, dist);
            int ylimit = Mth.ceil((double)(Math.sin((dist - (double)this.radius - (double)(this.radius / 16)) * (double)this.radius * 0.001875) * (double)(this.radius / 16)));
            if (dist >= (double)(this.radius + 5)) {
                int metadata = Mth.floor((double)(16.0 / (double)this.radius * dist));
                if (metadata < 0) {
                    metadata = 0;
                }
                if (++metadata > 15) {
                    metadata = 15;
                }
                for (int Y = ylimit; Y >= this.world.getMinY(); --Y) {
                    int yy = Y + y;
                    BlockState state = this.world.getBlockState(new BlockPos(x + this.posX, yy, z + this.posZ));
                    if (state.is(RRBlocks.omegaobj)) {
                        RivalRebels.round.winSigma();
                        continue;
                    }
                    if (state.is(RRBlocks.sigmaobj)) {
                        RivalRebels.round.winOmega();
                        continue;
                    }
                    if (!this.isTree) {
                        BlockState state1 = this.world.getBlockState(new BlockPos(x + this.posX, yy - ylimit, z + this.posZ));
                        this.world.setBlockAndUpdate(new BlockPos(x + this.posX, yy, z + this.posZ), state1);
                        continue;
                    }
                    this.isTree = false;
                    for (int Yy = 0; Yy >= -this.treeHeight; --Yy) {
                        this.world.setBlockAndUpdate(new BlockPos(x + this.posX, yy + Yy, z + this.posZ), (BlockState)((Block)RRBlocks.petrifiedwood.get()).defaultBlockState().setValue((Property)BlockPetrifiedWood.META, (Comparable)Integer.valueOf(metadata)));
                    }
                    break;
                }
            } else {
                BlockState state = this.world.getBlockState(new BlockPos(x + this.posX, y, z + this.posZ));
                if (!state.is(Blocks.BEDROCK) && !state.canOcclude()) {
                    this.world.setBlockAndUpdate(new BlockPos(x + this.posX, y, z + this.posZ), Blocks.AIR.defaultBlockState());
                }
                if (this.isTree) {
                    this.isTree = false;
                    int metadata = Mth.floor((double)(16.0 / (double)this.radius * dist));
                    if (metadata < 0) {
                        metadata = 0;
                    }
                    if (++metadata > 15) {
                        metadata = 15;
                    }
                    for (int Y = ylimit; Y > ylimit - this.treeHeight; --Y) {
                        this.world.setBlockAndUpdate(new BlockPos(x + this.posX, Y, z + this.posZ), (BlockState)((Block)RRBlocks.petrifiedwood.get()).defaultBlockState().setValue((Property)BlockPetrifiedWood.META, (Comparable)Integer.valueOf(metadata)));
                    }
                }
            }
            return true;
        }
        return false;
    }

    private int getTopBlock(int x, int z, double dist) {
        int foundY = this.world.getMinY();
        boolean found = false;
        for (int y = this.world.getMaxY(); y > this.world.getMinY(); --y) {
            BlockPos pos = new BlockPos(x, y, z);
            BlockState state = this.world.getBlockState(pos);
            if (state.isAir()) continue;
            if (state.is(RRBlocks.omegaobj)) {
                RivalRebels.round.winSigma();
            } else if (state.is(RRBlocks.sigmaobj)) {
                RivalRebels.round.winOmega();
            }
            if (state.is(RRBlocks.reactive)) {
                int i = 0;
                while ((double)i < (1.0 - dist / (double)this.radius) * 16.0 + this.world.random.nextDouble() * 2.0) {
                    this.world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    ++i;
                }
            }
            if (!state.canOcclude() || state.is(BlockTags.LOGS)) {
                this.world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                if (dist > (double)(this.radius / 2) && state.is(BlockTags.LOGS) && this.world.getBlockState(pos.below()).is(BlockTags.LOGS)) {
                    this.isTree = true;
                }
                if (found || !this.isTree) continue;
                foundY = y;
                found = true;
                continue;
            }
            if (!found) {
                return y;
            }
            this.treeHeight = foundY - y;
            return foundY;
        }
        return foundY;
    }
}

