/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.item;

import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.block.trap.BlockRemoteCharge;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.item.components.RRComponents;
import io.github.kadir1243.rivalrebels.common.util.ItemUtil;
import io.github.kadir1243.rivalrebels.common.util.Translations;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ItemRemote
extends Item {
    public ItemRemote(Item.Properties properties) {
        super(properties.stacksTo(1).component(RRComponents.REMOTE_CONTROLLED_BOMB_POS, (Object)BlockPos.ZERO));
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level world = context.getLevel();
        BlockPos RCpos = (BlockPos)context.getItemInHand().get(RRComponents.REMOTE_CONTROLLED_BOMB_POS);
        if (player.level().getBlockState(RCpos.above()).is(RRBlocks.remotecharge) && player.isShiftKeyDown()) {
            player.playSound((SoundEvent)RRSounds.REMOTE_EXPLODE.get());
            BlockRemoteCharge.explode(world, RCpos.above());
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.getPlayer();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack itemStack = ItemUtil.getItemStack(player, RRBlocks.remotecharge.asItem());
        if ((player.getAbilities().invulnerable && world.isEmptyBlock(pos.above()) || !itemStack.isEmpty() && world.isEmptyBlock(pos.above())) && !player.isShiftKeyDown()) {
            player.playSound((SoundEvent)RRSounds.REMOTE_PLANT.get());
            player.displayClientMessage((Component)Translations.orders().append(" ").append((Component)Component.literal((String)"Shift-click (Sneak) to detonate.").withStyle(ChatFormatting.RED)), false);
            itemStack.set(RRComponents.REMOTE_CONTROLLED_BOMB_POS, (Object)pos);
            itemStack.consume(1, (LivingEntity)context.getPlayer());
            world.setBlockAndUpdate(pos.above(), ((Block)RRBlocks.remotecharge.get()).defaultBlockState());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

