/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.item.weapon;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.entity.EntityLaserBurst;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.util.ItemUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.Level;

public class ItemAstroBlaster
extends Item {
    boolean isA = true;

    public ItemAstroBlaster(Item.Properties properties) {
        super(properties);
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BOW;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 2000;
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ItemStack itemStack = ItemUtil.getItemStack(player, RRItems.redrod.asItem());
        if (player.hasInfiniteMaterials() || !itemStack.isEmpty() || RRConfig.SERVER.isInfiniteAmmo()) {
            if (world.isClientSide()) {
                stack.set(DataComponents.REPAIR_COST, (Object)1);
            }
            player.startUsingItem(hand);
            player.playSound((SoundEvent)RRSounds.LAPTOP.get(), 0.7f, 0.7f);
        } else if (!world.isClientSide()) {
            player.displayClientMessage(Component.nullToEmpty((String)"\u00a7cNot enough redstone rods"), false);
        }
        return InteractionResult.SUCCESS;
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (!(user instanceof Player)) {
            return;
        }
        Player player = (Player)user;
        if (remainingUseTicks < 1980 && !world.isClientSide()) {
            if (!RRConfig.SERVER.isInfiniteAmmo()) {
                ItemStack redrodStack = ItemUtil.getItemStack(user, RRItems.redrod.asItem());
                if (!redrodStack.isEmpty()) {
                    redrodStack.hurtAndBreak(1, (ServerLevel)world, (ServerPlayer)player, item -> {});
                    if (redrodStack.getDamageValue() == redrodStack.getMaxDamage()) {
                        redrodStack.consume(1, user);
                        player.addItem(RRItems.emptyrod.toStack());
                    }
                } else {
                    return;
                }
            }
            if (this.isA) {
                user.playSound((SoundEvent)RRSounds.BLASTER_MESSAGE_FROM_OTHER_PLANETS.get(), 0.5f, 0.3f);
            } else {
                user.playSound((SoundEvent)RRSounds.BLASTER_MESSAGE_FROM_OTHER_PLANETS2.get(), 0.4f, 1.7f);
            }
            this.isA = !this.isA;
            world.addFreshEntity((Entity)new EntityLaserBurst(world, (Entity)user, stack.isEnchanted()));
        } else if (world.isClientSide()) {
            stack.set(DataComponents.REPAIR_COST, (Object)(2000 - remainingUseTicks + 1));
        }
    }

    public boolean releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (world.isClientSide()) {
            stack.set(DataComponents.REPAIR_COST, (Object)0);
        }
        return false;
    }
}

