/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.item.weapon;

import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.entity.EntityCuchillo;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.util.ItemUtil;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.Level;

public class ItemCuchillo
extends Item {
    public ItemCuchillo(Item.Properties properties) {
        super(properties);
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BOW;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 72000;
    }

    public boolean releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        ItemStack itemStack = ItemUtil.getItemStack(user, RRItems.knife.asItem());
        if (user.hasInfiniteMaterials() || !itemStack.isEmpty()) {
            float f = (float)(this.getUseDuration(stack, user) - remainingUseTicks) / 20.0f;
            if ((double)(f = (f * f + f * 2.0f) * 0.3333f) < 0.1) {
                return false;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            stack.consume(1, user);
            user.playSound((SoundEvent)RRSounds.CUCHILLO_UNKNOWN3.get());
            if (!world.isClientSide()) {
                world.addFreshEntity((Entity)new EntityCuchillo(world, (Entity)user, 0.5f + f));
            }
            return true;
        }
        return false;
    }

    public InteractionResult use(Level world, Player user, InteractionHand hand) {
        user.startUsingItem(hand);
        return super.use(world, user, hand);
    }
}

