/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.item.weapon;

import io.github.kadir1243.rivalrebels.RRClient;
import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.client.gui.GuiFlameThrower;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.entity.EntityFlameBall;
import io.github.kadir1243.rivalrebels.common.entity.EntityFlameBall1;
import io.github.kadir1243.rivalrebels.common.entity.EntityFlameBall2;
import io.github.kadir1243.rivalrebels.common.entity.EntityFlameBallGreen;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.item.components.FlameThrowerMode;
import io.github.kadir1243.rivalrebels.common.item.components.RRComponents;
import io.github.kadir1243.rivalrebels.common.util.ItemUtil;
import io.github.kadir1243.rivalrebels.common.util.Translations;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ItemFlameThrower
extends Item {
    public static final Translations.TranslationKey OUT_OF_FUEL = new Translations.TranslationKey("out_of_fuel");
    boolean message = true;

    public ItemFlameThrower(Item.Properties properties) {
        super(properties);
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BOW;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 64;
    }

    public InteractionResult use(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.getItemInHand(hand);
        ItemStack itemStack = ItemUtil.getItemStack(user, RRItems.fuel.asItem());
        if (user.hasInfiniteMaterials() || !itemStack.isEmpty() || RRConfig.SERVER.isInfiniteAmmo()) {
            user.startUsingItem(hand);
            if (!user.hasInfiniteMaterials() && !RRConfig.SERVER.isInfiniteAmmo()) {
                itemStack.consume(1, (LivingEntity)user);
                if (this.getMode(stack) != 2) {
                    ItemUtil.findAndConsumeItem((LivingEntity)user, RRItems.fuel.asItem());
                }
                if (this.getMode(stack) != 2) {
                    ItemUtil.findAndConsumeItem((LivingEntity)user, RRItems.fuel.asItem());
                }
                if (this.getMode(stack) == 0) {
                    ItemUtil.findAndConsumeItem((LivingEntity)user, RRItems.fuel.asItem());
                }
                if (this.getMode(stack) == 0) {
                    ItemUtil.findAndConsumeItem((LivingEntity)user, RRItems.fuel.asItem());
                }
            }
            if (stack.isEnchanted() && !world.isClientSide()) {
                world.addFreshEntity((Entity)new EntityFlameBallGreen(world, (Entity)user, world.random.nextFloat() + 1.0f));
            }
        } else {
            user.displayClientMessage((Component)OUT_OF_FUEL.translate().withStyle(ChatFormatting.RED), false);
        }
        if (this.message) {
            user.displayClientMessage((Component)Translations.orders().append(" ").append((Component)Component.translatable((String)"RivalRebels.message.use")).append(" [R]."), false);
            this.message = false;
        }
        return InteractionResult.PASS;
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (!world.isClientSide()) {
            if (world.random.nextInt(10) == 0 && !user.isInWater()) {
                user.playSound((SoundEvent)RRSounds.FLAME_THROWER_USE.get(), 0.03f, 1.0f);
                if (world.random.nextInt(3) == 0 && !user.isInWater()) {
                    user.playSound((SoundEvent)RRSounds.FLAME_THROWER_EXTINGUISH.get(), 0.1f, 1.0f);
                }
            }
            if (!stack.isEnchanted()) {
                switch (this.getMode(stack)) {
                    case 0: {
                        for (int i = 0; i < 4; ++i) {
                            world.addFreshEntity((Entity)new EntityFlameBall2(world, (Entity)user, world.random.nextFloat() + 0.5f));
                        }
                        break;
                    }
                    case 1: {
                        world.addFreshEntity((Entity)new EntityFlameBall1(world, (Entity)user, 1.0f));
                        break;
                    }
                    case 2: {
                        world.addFreshEntity((Entity)new EntityFlameBall(world, (Entity)user, 1.0f));
                    }
                }
            }
        }
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        if (entity instanceof Player && slot != null && level.random.nextInt(10) == 0 && !entity.isInWater()) {
            entity.playSound((SoundEvent)RRSounds.FLAME_THROWER_USE.get(), 0.03f, 1.0f);
        }
        if (level.isClientSide()) {
            this.openGui(stack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openGui(ItemStack item) {
        if (RRClient.USE_KEY.isDown() && Minecraft.getInstance().screen == null) {
            Minecraft.getInstance().setScreen((Screen)new GuiFlameThrower(this.getMode(item)));
        }
    }

    public int getMode(ItemStack item) {
        return ((FlameThrowerMode)item.getOrDefault(RRComponents.FLAME_THROWER_MODE, (Object)FlameThrowerMode.DEFAULT)).mode();
    }
}

