/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.item.weapon;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.entity.EntityGasGrenade;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.util.ItemUtil;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.Level;

public class ItemGasGrenade
extends Item {
    public ItemGasGrenade(Item.Properties properties) {
        super(properties);
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BOW;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 75;
    }

    public boolean releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        ItemStack itemStack = ItemUtil.getItemStack(user, RRItems.gasgrenade.asItem());
        if (user.hasInfiniteMaterials() || !itemStack.isEmpty() || RRConfig.SERVER.isInfiniteGrenades()) {
            float f = (float)(this.getUseDuration(stack, user) - remainingUseTicks) / 20.0f;
            if ((f = (f * f + f * 2.0f) * 0.3333f) > 1.0f) {
                f = 1.0f;
            }
            EntityGasGrenade entitysuperarrow = new EntityGasGrenade(world, (Entity)user, 0.3f + f * 0.5f);
            stack.consume(1, user);
            user.playSound((SoundEvent)RRSounds.CUCHILLO_UNKNOWN3.get(), 1.0f, 0.9f);
            if (!world.isClientSide()) {
                world.addFreshEntity((Entity)entitysuperarrow);
                entitysuperarrow.setPos(entitysuperarrow.getX(), entitysuperarrow.getY() - 0.05, entitysuperarrow.getZ());
            }
        }
        return false;
    }

    public InteractionResult use(Level world, Player user, InteractionHand hand) {
        user.startUsingItem(hand);
        user.playSound(SoundEvents.SLIME_ATTACK, 1.0f, 1.0f);
        return super.use(world, user, hand);
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        int time = 75 - remainingUseTicks;
        if (time == 15 || time == 30 || time == 45 || time == 60) {
            user.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_SNARE.value());
        }
        if (time == 75) {
            user.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_SNARE.value());
            user.addEffect(new MobEffectInstance(MobEffects.POISON, 80, 1));
            user.addEffect(new MobEffectInstance(MobEffects.NAUSEA, 200, 0));
            user.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 80, 0));
            user.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 80, 0));
            stack.consume(1, user);
        }
    }
}

