/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.tileentity;

import io.github.kadir1243.rivalrebels.common.container.ContainerLoader;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.item.components.RRComponents;
import io.github.kadir1243.rivalrebels.common.tileentity.RRTileEntities;
import io.github.kadir1243.rivalrebels.common.tileentity.Tickable;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityReactor;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityReciever;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class TileEntityLoader
extends BaseContainerBlockEntity
implements Tickable {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)64, (Object)ItemStack.EMPTY);
    public float slide = 0.0f;
    private float test = (float)Math.PI;
    private int counter;
    public List<BlockEntity> machines = new ArrayList<BlockEntity>();

    public TileEntityLoader(BlockPos pos, BlockState state) {
        super((BlockEntityType)RRTileEntities.LOADER.get(), pos, state);
    }

    public int getContainerSize() {
        return 60;
    }

    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        ContainerHelper.loadAllItems((ValueInput)valueInput, this.items);
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        ContainerHelper.saveAllItems((ValueOutput)valueOutput, this.items);
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player, (float)64.0f);
    }

    @Override
    public void tick() {
        this.slide = (Mth.cos((float)this.test) + 1.0f) / 32.0f * 14.0f;
        if (this.level.hasNearbyAlivePlayer((double)((float)this.getBlockPos().getX() + 0.5f), (double)((float)this.getBlockPos().getY() + 0.5f), (double)((float)this.getBlockPos().getZ() + 0.5f), 9.0)) {
            if ((double)this.slide < 0.871) {
                this.test += 0.05f;
            }
        } else if ((double)this.slide > 0.004) {
            this.test -= 0.05f;
        }
        ++this.counter;
        if (this.counter % 10 == 0) {
            BlockEntity te;
            for (int x = 1; x < 7; ++x) {
                te = this.level.getBlockEntity(this.getBlockPos().east(x));
                if (te instanceof TileEntityReactor || te instanceof TileEntityReciever) {
                    this.machines.add(te);
                }
                if ((te = this.level.getBlockEntity(this.getBlockPos().west(x))) instanceof TileEntityReactor || te instanceof TileEntityReciever) {
                    this.machines.add(te);
                }
                if ((te = this.level.getBlockEntity(this.getBlockPos().south(x))) instanceof TileEntityReactor || te instanceof TileEntityReciever) {
                    this.machines.add(te);
                }
                if (!((te = this.level.getBlockEntity(this.getBlockPos().north(x))) instanceof TileEntityReactor) && !(te instanceof TileEntityReciever)) continue;
                this.machines.add(te);
            }
            for (int index = 0; index < this.machines.size(); ++index) {
                te = this.machines.get(index);
                if (te != null && !te.isRemoved()) {
                    Tickable ter;
                    if (te instanceof TileEntityReactor) {
                        ter = (TileEntityReactor)te;
                        if (((TileEntityReactor)ter).on) {
                            for (int q = 0; q < this.items.size() && ((TileEntityReactor)ter).getFuel().isEmpty(); ++q) {
                                if (!this.getItem(q).has(RRComponents.ROD_POWER)) continue;
                                ((TileEntityReactor)ter).setFuel(this.getItem(q));
                                this.setItem(q, RRItems.emptyrod.toStack());
                            }
                        }
                    }
                    if (!(te instanceof TileEntityReciever)) continue;
                    ter = (TileEntityReciever)te;
                    this.transferItemsToReciever((TileEntityReciever)ter);
                    continue;
                }
                this.machines.remove(index);
            }
            BlockEntity te2 = this.level.getBlockEntity(this.getBlockPos().below());
            if (te2 instanceof TileEntityLoader) {
                TileEntityLoader tel = (TileEntityLoader)te2;
                for (int q = 0; q < this.items.size(); ++q) {
                    if (this.getItem(q).isEmpty()) continue;
                    for (int j = 0; j < tel.items.size(); ++j) {
                        if (!tel.getItem(j).isEmpty()) continue;
                        tel.setItem(j, this.getItem(q));
                        this.setItem(q, ItemStack.EMPTY);
                        return;
                    }
                }
            }
        }
    }

    private void transferItemsToReciever(TileEntityReciever ter) {
        for (ItemStack item : this.getItems()) {
            int amount;
            if (item.isEmpty()) continue;
            if (item.is(RRItems.fuel)) {
                amount = item.getCount();
                for (int slot : new int[]{0, 1, 2}) {
                    if (!ter.getItem(slot).isEmpty() && ter.getItem(slot).getCount() >= 64) continue;
                    if (ter.getItem(slot).isEmpty()) {
                        ter.setItem(slot, item.copyWithCount(amount));
                    } else {
                        ter.getItem(slot).grow(amount);
                    }
                    amount = 0;
                    if (ter.getItem(slot).getCount() <= 64) break;
                    amount = ter.getItem(slot).getCount() - 64;
                    ter.getItem(slot).setCount(64);
                    break;
                }
                item.setCount(amount);
                continue;
            }
            if (!item.is(RRItems.battery)) continue;
            amount = item.getCount();
            for (int slot : new int[]{3, 4, 5}) {
                if (!ter.getItem(slot).isEmpty() && ter.getItem(slot).getCount() >= 16) continue;
                if (ter.getItem(slot).isEmpty()) {
                    ter.setItem(slot, item.copyWithCount(amount));
                } else {
                    ter.getItem(slot).grow(amount);
                }
                amount = 0;
                if (ter.getItem(slot).getCount() <= 16) break;
                amount = ter.getItem(slot).getCount() - 16;
                ter.getItem(slot).setCount(16);
                break;
            }
            item.setCount(amount);
        }
    }

    protected Component getDefaultName() {
        return Component.literal((String)"Loader");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new ContainerLoader(containerId, inventory, (Container)this);
    }
}

