/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.tileentity;

import io.github.kadir1243.rivalrebels.common.tileentity.Tickable;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityReactor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class TileEntityMachineBase
extends BlockEntity
implements Tickable {
    public static final Map<BlockPos, TileEntityMachineBase> BLOCK_ENTITIES = new HashMap<BlockPos, TileEntityMachineBase>();
    public float pInM = 0.0f;
    public float pInR = 0.0f;
    public float edist = 0.0f;
    public float decay = 0.0f;
    public float powerGiven = 0.0f;
    public BlockPos worldPosition = BlockPos.ZERO;

    public TileEntityMachineBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        BLOCK_ENTITIES.put(pos, this);
    }

    @Override
    public void tick() {
        if (this.pInR > 0.0f) {
            this.pInR = this.powered(this.pInR, this.edist);
        }
        this.pInR -= this.decay;
    }

    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        valueInput.getLong("rpos").map(BlockPos::of).ifPresent(pos -> {
            this.worldPosition = pos;
        });
        this.edist = valueInput.getFloatOr("edist", 0.0f);
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        valueOutput.putLong("rpos", this.worldPosition.asLong());
        valueOutput.putFloat("edist", this.edist);
    }

    public void setRemoved() {
        super.setRemoved();
        BlockEntity connectedTo = this.level.getBlockEntity(this.worldPosition);
        if (connectedTo instanceof TileEntityReactor) {
            ((TileEntityReactor)connectedTo).machines.remove(this);
        }
        BLOCK_ENTITIES.remove(this.getBlockPos());
    }

    public abstract float powered(float var1, float var2);
}

