/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.tileentity;

import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.EntityNuclearBlast;
import io.github.kadir1243.rivalrebels.common.entity.EntityPlasmoid;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodes;
import io.github.kadir1243.rivalrebels.common.tileentity.RRTileEntities;
import io.github.kadir1243.rivalrebels.common.tileentity.Tickable;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TileEntityMeltDown
extends BlockEntity
implements Tickable {
    private static final float INCREMENT_AMOUNT = 0.075f;
    public float size = 0.0f;

    public TileEntityMeltDown(BlockPos pos, BlockState state) {
        super((BlockEntityType)RRTileEntities.MELT_DOWN.get(), pos, state);
    }

    @Override
    public void tick() {
        if (this.size == 0.0f) {
            this.level.playSound(null, this.getBlockPos(), (SoundEvent)RRSounds.PLASMA.get(), SoundSource.BLOCKS, 4.0f, 1.0f);
        }
        this.size += 0.075f;
        if (this.size > 9.3f) {
            this.size = 0.0f;
            this.level.setBlockAndUpdate(this.getBlockPos(), Blocks.AIR.defaultBlockState());
            this.setRemoved();
        }
        float fsize = Mth.sin((float)this.size) * 5.9f;
        List l = this.level.getEntities(null, new AABB((double)((float)this.getBlockPos().getX() - (fsize *= 2.0f)) + 0.5, (double)((float)this.getBlockPos().getY() - fsize) + 0.5, (double)((float)this.getBlockPos().getZ() - fsize) + 0.5, (double)((float)this.getBlockPos().getX() + fsize) + 0.5, (double)((float)this.getBlockPos().getY() + fsize) + 0.5, (double)((float)this.getBlockPos().getZ() + fsize) + 0.5));
        for (Entity e : l) {
            Vec3 vec3;
            double var13 = Math.sqrt(e.distanceToSqr((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ())) / (double)fsize;
            if (!(var13 <= 1.0) || (vec3 = e.getEyePosition().subtract(Vec3.atLowerCornerOf((Vec3i)this.getBlockPos()))).length() == 0.0) continue;
            vec3 = vec3.normalize();
            double var32 = ServerExplosion.getSeenPercent((Vec3)Vec3.atLowerCornerOf((Vec3i)this.getBlockPos()), (Entity)e);
            double var34 = (1.0 - var13) * var32;
            if (e instanceof EntityNuclearBlast || e instanceof EntityPlasmoid || e instanceof EntityRhodes) continue;
            e.hurt(RivalRebelsDamageSource.plasmaExplosion(this.level), (float)((int)((var34 * var34 + var34) / 16.0 * (double)fsize + 1.0)));
            e.push(vec3.scale(var34 * 4.0));
        }
    }
}

