/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.tileentity;

import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.EntityNuclearBlast;
import io.github.kadir1243.rivalrebels.common.entity.EntityPlasmoid;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodes;
import io.github.kadir1243.rivalrebels.common.entity.EntityTsarBlast;
import io.github.kadir1243.rivalrebels.common.tileentity.RRTileEntities;
import io.github.kadir1243.rivalrebels.common.tileentity.Tickable;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class TileEntityPlasmaExplosion
extends BlockEntity
implements Tickable {
    public float size = 0.0f;
    float increment = 0.3f;
    float prevsize = 0.0f;

    public TileEntityPlasmaExplosion(BlockPos pos, BlockState state) {
        super((BlockEntityType)RRTileEntities.PLASMA_EXPLOSION.get(), pos, state);
    }

    @Override
    public void tick() {
        this.prevsize = this.size;
        this.size += this.increment;
        if (this.prevsize == 0.0f) {
            this.level.playSound(null, this.getBlockPos(), (SoundEvent)RRSounds.PLASMA.get(), SoundSource.BLOCKS, 4.0f, 1.0f);
        }
        if (this.size > 3.1f) {
            this.size = 0.0f;
            this.level.setBlockAndUpdate(this.getBlockPos(), Blocks.AIR.defaultBlockState());
            this.setRemoved();
        }
        float fsize = Mth.sin((float)this.size) * 5.9f * 2.0f;
        double fsqr = fsize * fsize;
        List l = this.level.getEntities(null, new AABB((double)((float)this.getBlockPos().getX() - fsize) + 0.5, (double)((float)this.getBlockPos().getY() - fsize) + 0.5, (double)((float)this.getBlockPos().getZ() - fsize) + 0.5, (double)((float)this.getBlockPos().getX() + fsize) + 0.5, (double)((float)this.getBlockPos().getY() + fsize) + 0.5, (double)((float)this.getBlockPos().getZ() + fsize) + 0.5));
        for (Entity e : l) {
            double var19;
            double var17;
            double var15 = e.getZ() - (double)this.getBlockPos().getX();
            double dist = 0.5 / (Math.sqrt(var15 * var15 + (var17 = e.getEyeY() - (double)this.getBlockPos().getY() + 1.5) * var17 + (var19 = e.getZ() - (double)this.getBlockPos().getZ()) * var19) + (double)0.01f);
            if (!(dist <= 0.5) || e instanceof EntityNuclearBlast || e instanceof EntityPlasmoid || e instanceof EntityTsarBlast || e instanceof EntityRhodes) continue;
            e.hurt(RivalRebelsDamageSource.plasmaExplosion(this.level), 2.0f);
            e.push(var15 * dist, var17 * dist, var19 * dist);
        }
    }
}

