/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.tileentity;

import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.container.ContainerReactor;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodes;
import io.github.kadir1243.rivalrebels.common.explosion.Explosion;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.item.components.RRComponents;
import io.github.kadir1243.rivalrebels.common.packet.ReactorMachinesPacket;
import io.github.kadir1243.rivalrebels.common.tileentity.RRTileEntities;
import io.github.kadir1243.rivalrebels.common.tileentity.Tickable;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityMachineBase;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityReactive;
import io.github.kadir1243.rivalrebels.common.util.Translations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class TileEntityReactor
extends BaseContainerBlockEntity
implements Tickable {
    public double slide = 90.0;
    private float test = (float)Math.PI;
    private NonNullList<ItemStack> items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    public boolean on = false;
    public boolean prevOn = false;
    public boolean melt = false;
    public int meltTick = 0;
    public boolean eject = false;
    public double consumed = 0.0;
    public double lasttickconsumed = 0.0;
    public int tickssincelastrod = 0;
    public boolean lastrodwasredstone = false;
    public final Map<BlockPos, ReactorMachinesPacket.MachineEntry> entries = new HashMap<BlockPos, ReactorMachinesPacket.MachineEntry>();
    public List<TileEntityMachineBase> machines = new ArrayList<TileEntityMachineBase>();
    public int tick = 0;
    private final ContainerData propertyDelegate = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> {
                    if (TileEntityReactor.this.on) {
                        yield 1;
                    }
                    yield 0;
                }
                case 1 -> (int)(TileEntityReactor.this.getPower() * 100.0f);
                case 2 -> (int)TileEntityReactor.this.consumed;
                case 3 -> {
                    if (TileEntityReactor.this.melt) {
                        yield 1;
                    }
                    yield 0;
                }
                case 4 -> TileEntityReactor.this.getBlockPos().getX();
                case 5 -> TileEntityReactor.this.getBlockPos().getY();
                case 6 -> TileEntityReactor.this.getBlockPos().getZ();
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityReactor.this.on = value == 1;
                    break;
                }
                case 2: {
                    TileEntityReactor.this.consumed = value;
                    break;
                }
                case 3: {
                    TileEntityReactor.this.melt = value == 1;
                    break;
                }
            }
        }

        public int getCount() {
            return 7;
        }
    };

    public TileEntityReactor(BlockPos pos, BlockState state) {
        super((BlockEntityType)RRTileEntities.REACTOR.get(), pos, state);
        EntityRhodes.BLOCK_ENTITIES.put(pos, (BlockEntity)this);
    }

    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        ContainerHelper.loadAllItems((ValueInput)valueInput, this.items);
        this.consumed = valueInput.getDoubleOr("consumed", 0.0);
        this.on = valueInput.getBooleanOr("on", false);
        this.lasttickconsumed = valueInput.getDoubleOr("lasttickconsumed", 0.0);
        this.melt = valueInput.getBooleanOr("melt", false);
        this.eject = valueInput.getBooleanOr("eject", false);
        int i = 0;
        while (valueInput.child("mpos" + i).isPresent()) {
            BlockEntity te;
            if (this.hasLevel() && (te = this.level.getBlockEntity(BlockPos.of((long)valueInput.getLongOr("mpos" + i, 0L)))) instanceof TileEntityMachineBase) {
                TileEntityMachineBase machineBase = (TileEntityMachineBase)te;
                machineBase.powerGiven = valueInput.getFloatOr("mpowerGiven" + i, 0.0f);
                machineBase.pInR = valueInput.getFloatOr("mpInR" + i, 0.0f);
                machineBase.worldPosition = this.getBlockPos();
                machineBase.edist = (float)Math.sqrt(machineBase.getBlockPos().distSqr((Vec3i)this.getBlockPos()));
                this.machines.add(machineBase);
            }
            ++i;
        }
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        ContainerHelper.saveAllItems((ValueOutput)valueOutput, this.items);
        valueOutput.putDouble("consumed", this.consumed);
        valueOutput.putBoolean("on", this.on);
        valueOutput.putDouble("lasttickconsumed", this.lasttickconsumed);
        valueOutput.putBoolean("melt", this.melt);
        valueOutput.putBoolean("eject", this.eject);
        if (this.on) {
            for (int i = 0; i < this.machines.size(); ++i) {
                TileEntityMachineBase te = this.machines.get(i);
                if (te == null || te instanceof TileEntityReactive) continue;
                valueOutput.putLong("mpos" + i, te.getBlockPos().asLong());
                valueOutput.putFloat("mpowerGiven" + i, te.powerGiven);
                valueOutput.putFloat("mpInR" + i, te.pInR);
            }
        }
    }

    @Override
    public void clientTick() {
        this.slide = (Mth.cos((float)this.test) + 1.0f) * 45.0f;
        boolean flag = this.level.hasNearbyAlivePlayer((double)((float)this.getBlockPos().getX() + 0.5f), (double)((float)this.getBlockPos().getY() + 0.5f), (double)((float)this.getBlockPos().getZ() + 0.5f), 9.0);
        if (flag) {
            if (this.slide < 89.995) {
                this.test += 0.05f;
            }
        } else if (this.slide > 0.004) {
            this.test -= 0.05f;
        }
        if (this.getCore().isEmpty()) {
            this.on = false;
            this.consumed = 0.0;
            this.lasttickconsumed = 0.0;
            this.melt = false;
            this.meltTick = 0;
        }
        if (this.eject) {
            this.consumed = 0.0;
            this.lasttickconsumed = 0.0;
            this.clearContent();
            this.melt = false;
            this.meltTick = 0;
            this.on = false;
            this.eject = false;
        }
        this.prevOn = this.on;
    }

    @Override
    public void serverTick() {
        if (this.eject && !this.getCore().isEmpty()) {
            this.consumed = 0.0;
            this.lasttickconsumed = 0.0;
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)this.getBlockPos().getX() + 0.5, (double)(this.getBlockPos().getY() + 1), (double)this.getBlockPos().getZ() + 0.5, this.getCore()));
            this.clearContent();
            this.melt = false;
            this.meltTick = 0;
            this.on = false;
        }
        if (this.melt) {
            if (!this.getCore().isEmpty()) {
                if (this.meltTick % 20 == 0) {
                    this.level.playLocalSound(this.getBlockPos(), (SoundEvent)RRSounds.REACTOR_RUNNING.get(), SoundSource.BLOCKS, 1.0f, 1.0f, true);
                }
                this.on = true;
                ++this.meltTick;
                if (this.meltTick == 300) {
                    this.meltDown(10);
                } else if (this.meltTick == 1) {
                    MutableComponent text = Translations.warning().append(" ").append((Component)Component.translatable((String)"rivalrebels.warning_meltdown").withStyle(ChatFormatting.RED));
                    for (Object player : this.level.players()) {
                        player.displayClientMessage((Component)text, false);
                    }
                }
                for (int i = 0; i < 4; ++i) {
                    this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5, this.level.random.nextDouble() - 0.5, this.level.random.nextDouble() / 2.0, this.level.random.nextDouble() - 0.5);
                }
            } else {
                this.melt = false;
                this.meltTick = 0;
                this.on = false;
            }
        }
        if (this.getFuel().isEmpty() && this.tickssincelastrod != 0) {
            ++this.tickssincelastrod;
            if (this.tickssincelastrod >= 100) {
                if (this.lastrodwasredstone) {
                    this.on = false;
                } else {
                    this.melt = true;
                }
            }
            if (this.tickssincelastrod == 20 && !this.lastrodwasredstone) {
                for (Player player : this.getLevel().players()) {
                    player.displayClientMessage((Component)Translations.warning().append(" ").append((Component)Translations.OVERHEAT_TRANSLATION.translate().withStyle(ChatFormatting.RED)), false);
                }
            }
        } else {
            this.tickssincelastrod = 0;
        }
        if (this.melt) {
            this.machines.clear();
        }
        if (this.getCore().isEmpty()) {
            this.on = false;
            this.consumed = 0.0;
            this.lasttickconsumed = 0.0;
            this.melt = false;
            this.meltTick = 0;
        }
        if (this.on && this.getCore().has(RRComponents.CORE_TIME_MULTIPLIER) && !this.getFuel().isEmpty() && this.getFuel().has(RRComponents.ROD_POWER)) {
            float power;
            if (!this.prevOn && this.on) {
                this.level.playLocalSound(this.getBlockPos(), (SoundEvent)RRSounds.REACTOR_DISABLING.get(), SoundSource.BLOCKS, 1.0f, 1.0f, true);
            } else {
                ++this.tick;
                if (this.on && this.tick % 39 == 0) {
                    this.level.playLocalSound(this.getBlockPos(), (SoundEvent)RRSounds.REACTOR_RUNNING_2.get(), SoundSource.BLOCKS, 0.9f, 0.77f, true);
                }
            }
            float temp = power = (float)((Integer)this.getFuel().get(RRComponents.ROD_POWER)).intValue() * ((Float)this.getCore().get(RRComponents.CORE_TIME_MULTIPLIER)).floatValue() - (float)((Integer)this.getFuel().getOrDefault(RRComponents.REACTOR_FUEL_LEFT, (Object)0)).intValue();
            for (BlockEntity blockEntity : TileEntityMachineBase.BLOCK_ENTITIES.values()) {
                double dist;
                if (!(blockEntity instanceof TileEntityMachineBase)) continue;
                TileEntityMachineBase temb = (TileEntityMachineBase)blockEntity;
                if (this.level.getBlockEntity(temb.worldPosition) == null && (dist = temb.getBlockPos().distSqr((Vec3i)this.getBlockPos())) < 1024.0) {
                    temb.worldPosition = this.getBlockPos();
                    temb.edist = (float)Math.sqrt(dist);
                    this.machines.add(temb);
                }
                if (!temb.worldPosition.equals((Object)this.getBlockPos())) continue;
                this.machines.add(temb);
                temb.powerGiven = power;
                if (power > temb.pInM - temb.pInR) {
                    power -= temb.pInM - temb.pInR;
                    temb.pInR = temb.pInM;
                } else {
                    temb.pInR += power;
                    power = 0.0f;
                }
                temb.powerGiven -= power;
            }
            this.lasttickconsumed = temp - power;
            this.consumed += this.lasttickconsumed;
            if (this.getFuel().has(RRComponents.REACTOR_FUEL_LEFT)) {
                this.getFuel().set(RRComponents.REACTOR_FUEL_LEFT, (Object)((int)this.consumed));
                double fuelLeft = (int)this.consumed;
                double fuelPercentage = fuelLeft / (double)temp;
                if (this.getFuel().is(RRItems.NUCLEAR_ROD)) {
                    double f2 = fuelPercentage * fuelPercentage;
                    double f4 = f2 * f2;
                    double f8 = f4 * f4;
                    if ((double)this.level.random.nextFloat() < f8) {
                        this.melt = true;
                    }
                }
            } else {
                this.getFuel().set(RRComponents.REACTOR_FUEL_LEFT, (Object)0);
            }
            if ((float)((Integer)this.getFuel().getOrDefault(RRComponents.REACTOR_FUEL_LEFT, (Object)0)).intValue() >= temp) {
                this.lastrodwasredstone = this.getFuel().is(RRItems.redrod);
                this.consumed = 0.0;
                this.lasttickconsumed = 0.0;
                this.tickssincelastrod = 1;
                this.setFuel(ItemStack.EMPTY);
            }
        } else {
            this.machines.clear();
        }
        this.eject = false;
        this.prevOn = this.on;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void meltDown(int radius) {
        this.level.setBlockAndUpdate(this.getBlockPos(), ((Block)RRBlocks.meltdown.get()).defaultBlockState());
        new Explosion(this.level, this.getBlockPos().getX(), this.getBlockPos().getY() - 2, this.getBlockPos().getZ(), 4, false, false, RivalRebelsDamageSource.rocket(this.getLevel()));
    }

    public int getContainerSize() {
        return 2;
    }

    public ItemStack getCore() {
        return (ItemStack)this.items.getFirst();
    }

    public void setCore(ItemStack core) {
        this.setItem(0, core);
    }

    public ItemStack getFuel() {
        return (ItemStack)this.items.get(1);
    }

    public void setFuel(ItemStack fuel) {
        this.setItem(1, fuel);
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (slot == 0 && stack.has(RRComponents.CORE_TIME_MULTIPLIER)) {
            return this.getFuel().isEmpty() || !this.on;
        }
        if (slot == 1 && stack.has(RRComponents.ROD_POWER)) {
            return !this.on;
        }
        return false;
    }

    public void setRemoved() {
        super.setRemoved();
        this.on = false;
        for (TileEntityMachineBase machine : this.machines) {
            if (machine.isRemoved()) continue;
            machine.worldPosition = BlockPos.ZERO;
            machine.edist = 0.0f;
        }
        EntityRhodes.BLOCK_ENTITIES.remove(this.getBlockPos());
    }

    public float getPower() {
        if (this.getCore().has(RRComponents.CORE_TIME_MULTIPLIER) && this.getFuel().has(RRComponents.ROD_POWER)) {
            return (float)((Integer)this.getFuel().get(RRComponents.ROD_POWER)).intValue() * ((Float)this.getCore().get(RRComponents.CORE_TIME_MULTIPLIER)).floatValue() - (float)((Integer)this.getFuel().getOrDefault(RRComponents.REACTOR_FUEL_LEFT, (Object)0)).intValue();
        }
        return 0.0f;
    }

    public void toggleOn() {
        this.on = !this.on;
    }

    public void ejectCore() {
        this.eject = true;
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new ContainerReactor(containerId, inventory, (Container)this, this.propertyDelegate);
    }

    protected Component getDefaultName() {
        return Component.literal((String)"Reactor");
    }
}

