/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.datagen;

import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.common.block.BlockConduit;
import io.github.kadir1243.rivalrebels.common.block.BlockGore;
import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.loaders.ObjModelBuilder;
import net.neoforged.neoforge.client.model.generators.template.ExtendedModelTemplateBuilder;
import net.neoforged.neoforge.client.model.generators.template.RootTransformsBuilder;
import net.neoforged.neoforge.client.model.generators.template.TransformVecBuilder;

public class BlockStateDataGen
extends ModelProvider {
    public static final ModelTemplate CONDUIT_TEMPLATE = new ModelTemplate(ModelTemplates.CUBE_ALL.model, Optional.of("_variant"), new TextureSlot[]{TextureSlot.ALL});

    public BlockStateDataGen(PackOutput p_388260_) {
        super(p_388260_, "rivalrebels");
    }

    private void simpleBlock(BlockModelGenerators blockModels, Holder<Block> block, String textureLoc) {
        blockModels.createTrivialBlock((Block)block.value(), TexturedModel.CUBE.updateTexture(textureMapping -> textureMapping.put(TextureSlot.ALL, this.idBlock(textureLoc))));
    }

    private void simpleBlock(BlockModelGenerators blockModels, Holder<Block> block, Block textureBlock) {
        blockModels.copyModel(textureBlock, (Block)block.value());
    }

    private void simpleBlock(BlockModelGenerators blockModels, Holder<Block> block, String sides, String down, String up) {
        blockModels.createTrivialBlock((Block)block.value(), TexturedModel.CUBE_TOP_BOTTOM.updateTexture(textureMapping -> {
            textureMapping.put(TextureSlot.BOTTOM, this.idBlock(down));
            textureMapping.put(TextureSlot.TOP, this.idBlock(up));
            textureMapping.put(TextureSlot.SIDE, this.idBlock(sides));
        }));
    }

    private void simpleBlock(BlockModelGenerators blockModels, Holder<Block> block, String sides, String up_and_down) {
        this.simpleBlock(blockModels, block, sides, up_and_down, up_and_down);
    }

    private void simpleSidedBlock(BlockModelGenerators blockModels, Holder<Block> block, String northAndSouthSide, String westAndEastSide, String up, String down) {
        blockModels.createTrivialBlock((Block)block.value(), TexturedModel.CUBE.updateTexture(textureMapping -> {
            textureMapping.put(TextureSlot.NORTH, this.idBlock(northAndSouthSide));
            textureMapping.put(TextureSlot.SOUTH, this.idBlock(northAndSouthSide));
            textureMapping.put(TextureSlot.WEST, this.idBlock(westAndEastSide));
            textureMapping.put(TextureSlot.EAST, this.idBlock(westAndEastSide));
            textureMapping.put(TextureSlot.BOTTOM, this.idBlock(down));
            textureMapping.put(TextureSlot.TOP, this.idBlock(up));
        }));
    }

    public final void createConduitVariant(BlockModelGenerators blockModels, Holder<Block> block) {
        MultiVariant meta1 = BlockModelGenerators.plainVariant((ResourceLocation)CONDUIT_TEMPLATE.createWithSuffix((Block)block.value(), "_1", TextureMapping.cube((ResourceLocation)this.idBlock("co")), blockModels.modelOutput));
        MultiVariant meta2 = BlockModelGenerators.plainVariant((ResourceLocation)CONDUIT_TEMPLATE.createWithSuffix((Block)block.value(), "_2", TextureMapping.cube((ResourceLocation)this.idBlock("cp")), blockModels.modelOutput));
        MultiVariant meta3 = BlockModelGenerators.plainVariant((ResourceLocation)CONDUIT_TEMPLATE.createWithSuffix((Block)block.value(), "_3", TextureMapping.cube((ResourceLocation)this.idBlock("cq")), blockModels.modelOutput));
        MultiVariant meta4 = BlockModelGenerators.plainVariant((ResourceLocation)CONDUIT_TEMPLATE.createWithSuffix((Block)block.value(), "_4", TextureMapping.cube((ResourceLocation)this.idBlock("cr")), blockModels.modelOutput));
        MultiVariant meta5 = BlockModelGenerators.plainVariant((ResourceLocation)CONDUIT_TEMPLATE.createWithSuffix((Block)block.value(), "_5", TextureMapping.cube((ResourceLocation)this.idBlock("cs")), blockModels.modelOutput));
        MultiVariant meta6 = BlockModelGenerators.plainVariant((ResourceLocation)CONDUIT_TEMPLATE.createWithSuffix((Block)block.value(), "_6", TextureMapping.cube((ResourceLocation)this.idBlock("ct")), blockModels.modelOutput));
        MultiVariant meta7 = BlockModelGenerators.plainVariant((ResourceLocation)CONDUIT_TEMPLATE.createWithSuffix((Block)block.value(), "_7", TextureMapping.cube((ResourceLocation)this.idBlock("cu")), blockModels.modelOutput));
        MultiVariant meta8 = BlockModelGenerators.plainVariant((ResourceLocation)CONDUIT_TEMPLATE.createWithSuffix((Block)block.value(), "_8", TextureMapping.cube((ResourceLocation)this.idBlock("cv")), blockModels.modelOutput));
        MultiVariant meta9 = BlockModelGenerators.plainVariant((ResourceLocation)CONDUIT_TEMPLATE.createWithSuffix((Block)block.value(), "_9", TextureMapping.cube((ResourceLocation)this.idBlock("cw")), blockModels.modelOutput));
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)block.value())).with((PropertyDispatch)PropertyDispatch.initial((Property)BlockConduit.VARIANT).select((Comparable)Integer.valueOf(0), (Object)meta1).select((Comparable)Integer.valueOf(1), (Object)meta1).select((Comparable)Integer.valueOf(2), (Object)meta2).select((Comparable)Integer.valueOf(3), (Object)meta3).select((Comparable)Integer.valueOf(4), (Object)meta4).select((Comparable)Integer.valueOf(5), (Object)meta5).select((Comparable)Integer.valueOf(6), (Object)meta6).select((Comparable)Integer.valueOf(7), (Object)meta7).select((Comparable)Integer.valueOf(8), (Object)meta8).select((Comparable)Integer.valueOf(9), (Object)meta9)));
    }

    private ResourceLocation idBlock(String name) {
        return this.modLocation(name).withPrefix("block/");
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        super.registerModels(blockModels, itemModels);
        this.registerItems(itemModels);
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.steel, "bx");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.smartcamo, "bq");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.reactive, "cf", "cn");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.plasmaexplosion, "ak");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.meltdown, "ak");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.light, "ad");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.light2, "ad");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.fshield, "ao", "ap");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.cycle, "ak");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.camo3, "by");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.camo2, "bn");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.camo1, "as");
        this.objModelWithHorizontalRotation(blockModels, (Block)RRBlocks.antimatterbombblock.value(), RRIdentifiers.getModelLocation("t"), RRIdentifiers.etantimatterbomb, transformVecBuilder -> transformVecBuilder.rotation(0.5f, 1.0f, 0.5f));
        this.flareBlock(blockModels, (Holder<Block>)RRBlocks.flare, "an");
        this.objModelWithRotation(blockModels, (Block)RRBlocks.nuclearBomb.value(), RRIdentifiers.getModelLocation("wacknuke"), RRIdentifiers.etwacknuke, transformVecBuilder -> transformVecBuilder.rotation(0.5f, 0.5f, 0.5f));
        this.simpleModelHorizontallyRotated(blockModels, (Block)RRBlocks.tsarbombablock.value(), "ak");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.toxicgas, "ak");
        this.simpleModelHorizontallyRotated(blockModels, (Block)RRBlocks.theoreticaltsarbombablock.value(), "ak");
        this.objModelWithHorizontalRotation(blockModels, (Block)RRBlocks.tachyonbombblock.value(), RRIdentifiers.getModelLocation("t"), RRIdentifiers.ettachyonbomb, transformVecBuilder -> transformVecBuilder.rotation(0.5f, 1.0f, 0.5f));
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.petrifiedstone1, "bc", "bb");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.petrifiedstone2, "bd", "bb");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.petrifiedstone3, "be", "bb");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.petrifiedstone4, "bf", "bb");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.radioactivedirt, Blocks.DIRT);
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.radioactivesand, Blocks.SAND);
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.remotecharge, "af", "ag");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.omegaobj, "ba");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.sigmaobj, "bp");
        this.simpleModelHorizontallyRotated(blockModels, (Block)RRBlocks.ffreciever.value(), "dj");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.rhodesactivator, "ci", "ch");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.reactor, "bj");
        this.simpleModelHorizontallyRotated(blockModels, (Block)RRBlocks.loader.value(), "av");
        this.simpleModelHorizontallyRotated(blockModels, (Block)RRBlocks.controller.value(), "dc");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.forcefield, "di");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.ammunition, "aa", "ah", "ai");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.explosives, "am", "ah", "ai");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.nukeCrateTop, "ay");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.nukeCrateBottom, "ax");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.weapons, "ce", "ah", "ai");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.barricade, "cx", "cz", "da");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.bunker, "bl", "ah");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.easteregg, "ah", "ah", "ai");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.bastion, "db", "cz", "da");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.mariotrap, "de", "dh");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.supplies, "bz", "ah", "ai");
        blockModels.createTrivialBlock((Block)RRBlocks.breadbox.value(), TexturedModel.CUBE.updateTexture(textureMapping -> {
            textureMapping.put(TextureSlot.TOP, this.idBlock("cc"));
            textureMapping.put(TextureSlot.BOTTOM, this.idBlock("ca"));
            textureMapping.put(TextureSlot.NORTH, this.idBlock("cb"));
            textureMapping.put(TextureSlot.SOUTH, this.idBlock("ca"));
            textureMapping.put(TextureSlot.WEST, this.idBlock("ca"));
            textureMapping.put(TextureSlot.EAST, this.idBlock("ca"));
        }));
        this.goreBlock(blockModels, (Holder<Block>)RRBlocks.goreblock);
        this.createConduitVariant(blockModels, (Holder<Block>)RRBlocks.conduit);
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.quicksandtrap, "dg", "dh");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.tower, "cy", "ah", "ai");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.buildrhodes, "dk", "cz", "da");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.jump, "at", "ah", "au");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.petrifiedwood, "bg", "bh");
        this.simpleBlock(blockModels, (Holder<Block>)RRBlocks.minetrap, "df", "dh");
        this.simpleSidedBlock(blockModels, (Holder<Block>)RRBlocks.timedbomb, "ac", "ab", "ae", "ac");
        this.simpleSidedBlock(blockModels, (Holder<Block>)RRBlocks.sigmaarmor, "bo", "ah", "ai", "ah");
        this.simpleSidedBlock(blockModels, (Holder<Block>)RRBlocks.omegaarmor, "az", "ah", "ai", "ah");
        this.simpleSidedBlock(blockModels, (Holder<Block>)RRBlocks.gamestart, "ai", "ah", "ah", "ah");
        this.simpleSidedBlock(blockModels, (Holder<Block>)RRBlocks.flagbox1, "ai", "ah", "bi", "ah");
        this.simpleSidedBlock(blockModels, (Holder<Block>)RRBlocks.flagbox3, "ai", "ah", "ar", "ah");
        this.simpleSidedBlock(blockModels, (Holder<Block>)RRBlocks.flagbox4, "ai", "ah", "aw", "ah");
        this.simpleSidedBlock(blockModels, (Holder<Block>)RRBlocks.flagbox5, "ai", "ah", "aq", "ah");
        this.simpleSidedBlock(blockModels, (Holder<Block>)RRBlocks.flagbox6, "ai", "ah", "al", "ah");
        this.simpleSidedBlock(blockModels, (Holder<Block>)RRBlocks.flagbox7, "ai", "ah", "aj", "ah");
        this.createForceFieldNodeBlock(blockModels, (Block)RRBlocks.forcefieldnode.value());
        this.flagBlock(blockModels, (Holder<Block>)RRBlocks.flag1, "bi");
        this.flagBlock(blockModels, (Holder<Block>)RRBlocks.trollFlag, "dd");
        this.flagBlock(blockModels, (Holder<Block>)RRBlocks.flag3, "ar");
        this.flagBlock(blockModels, (Holder<Block>)RRBlocks.flag4, "aw");
        this.flagBlock(blockModels, (Holder<Block>)RRBlocks.flag5, "aq");
        this.flagBlock(blockModels, (Holder<Block>)RRBlocks.flag6, "al");
        this.flagBlock(blockModels, (Holder<Block>)RRBlocks.flag7, "aj");
        this.landmineBlock(blockModels, (Holder<Block>)RRBlocks.landmine);
        this.landmineBlock(blockModels, (Holder<Block>)RRBlocks.alandmine);
        this.quicksandBlock(blockModels, (Holder<Block>)RRBlocks.quicksand);
        this.quicksandBlock(blockModels, (Holder<Block>)RRBlocks.aquicksand);
        this.marioBlock(blockModels, (Holder<Block>)RRBlocks.mario);
        this.marioBlock(blockModels, (Holder<Block>)RRBlocks.amario);
        this.registerBlockItemModels(blockModels, itemModels);
    }

    public void registerBlockItemModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        this.customItemModel(itemModels, RRBlocks.controller.asItem());
        this.customItemModel(itemModels, RRBlocks.loader.asItem());
        this.customItemModel(itemModels, RRBlocks.reactor.asItem());
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.amario);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.aquicksand);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.barricade);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.tower);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.easteregg);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.bunker);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.smartcamo);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.camo1);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.camo2);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.camo3);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.steel);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.flagbox1);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.flagbox5);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.flagbox6);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.flagbox3);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.flagbox4);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.flagbox7);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.sigmaarmor);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.omegaarmor);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.weapons);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.ammunition);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.explosives);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.supplies);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.jump);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.remotecharge);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.timedbomb);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.flare);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.cycle);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.fshield);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.gamestart);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.breadbox);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.alandmine);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.nukeCrateTop);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.nukeCrateBottom);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.omegaobj);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.sigmaobj);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.petrifiedwood);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.petrifiedstone1);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.petrifiedstone2);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.petrifiedstone3);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.petrifiedstone4);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.forcefieldnode);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.goreblock);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.reactive);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.bastion);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.conduit);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.mariotrap);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.minetrap);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.quicksandtrap);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.ffreciever);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.buildrhodes);
        this.simpleBlockItem(blockModels, (Holder<Block>)RRBlocks.rhodesactivator);
    }

    private void simpleBlockItem(BlockModelGenerators blockModels, Holder<Block> holder) {
        blockModels.createFlatItemModelWithBlockTexture(((Block)holder.value()).asItem(), (Block)holder.value());
    }

    private void customItemModel(ItemModelGenerators itemModels, Item item) {
        itemModels.declareCustomModelItem(item);
    }

    private void objModelWithHorizontalRotation(BlockModelGenerators blockModels, Block block, ResourceLocation modelLocation, ResourceLocation texture, Consumer<TransformVecBuilder> transform) {
        blockModels.createHorizontallyRotatedBlock(block, BlockStateDataGen.getObjTexturedModel(modelLocation, texture, transform));
    }

    private void objModelWithRotation(BlockModelGenerators blockModels, Block block, ResourceLocation modelLocation, ResourceLocation texture, Consumer<TransformVecBuilder> transform) {
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block, (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)BlockStateDataGen.getObjTexturedModel(modelLocation, texture, transform).create(block, blockModels.modelOutput))).with(BlockModelGenerators.ROTATION_FACING));
    }

    private void simpleModelRotated(BlockModelGenerators blockModels, Block block, String texture) {
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block, (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)TexturedModel.CUBE.updateTexture(textureMapping -> textureMapping.put(TextureSlot.ALL, this.idBlock(texture))).create(block, blockModels.modelOutput))).with(BlockModelGenerators.ROTATION_FACING));
    }

    private void simpleModelHorizontallyRotated(BlockModelGenerators blockModels, Block block, String texture) {
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block, (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)TexturedModel.CUBE.updateTexture(textureMapping -> textureMapping.put(TextureSlot.ALL, this.idBlock(texture))).create(block, blockModels.modelOutput))).with(BlockModelGenerators.ROTATION_HORIZONTAL_FACING));
    }

    private static TexturedModel.Provider getObjTexturedModel(ResourceLocation modelLocation, ResourceLocation texture, Consumer<TransformVecBuilder> transform) {
        return TexturedModel.createDefault(block1 -> TextureMapping.defaultTexture((ResourceLocation)texture), (ModelTemplate)ExtendedModelTemplateBuilder.builder().customLoader(ObjModelBuilder::new, objModelBuilder -> objModelBuilder.modelLocation(modelLocation)).requiredTextureSlot(TextureSlot.TEXTURE).transform(ItemDisplayContext.NONE, transform).build());
    }

    private void createForceFieldNodeBlock(BlockModelGenerators blockModels, Block block) {
        ResourceLocation icon = this.idBlock("cf");
        ResourceLocation icon2 = this.idBlock("cg");
        ResourceLocation icontop1 = this.idBlock("cj");
        ResourceLocation icontop2 = this.idBlock("ck");
        ResourceLocation icontop3 = this.idBlock("cl");
        ResourceLocation icontop4 = this.idBlock("cm");
        blockModels.createHorizontallyRotatedBlock(block, TexturedModel.CUBE.updateTexture(textureMapping -> {
            textureMapping.put(TextureSlot.NORTH, icon);
            textureMapping.put(TextureSlot.SOUTH, icon);
            textureMapping.put(TextureSlot.WEST, icon2);
            textureMapping.put(TextureSlot.EAST, icon);
            textureMapping.put(TextureSlot.BOTTOM, icontop2);
            textureMapping.put(TextureSlot.TOP, icontop2);
        }));
    }

    private void flagBlock(BlockModelGenerators blockModels, Holder<Block> flag, String texture) {
        this.simpleBlock(blockModels, flag, texture);
    }

    private void flareBlock(BlockModelGenerators blockModels, Holder<Block> flare, String texture) {
        blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)((Block)flare.value()), (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)ModelTemplates.TORCH.create((Block)flare.value(), new TextureMapping().put(TextureSlot.TORCH, this.idBlock(texture)), blockModels.modelOutput))));
    }

    private void goreBlock(BlockModelGenerators blockModels, Holder<Block> block) {
        MultiVariant icon = BlockModelGenerators.plainVariant((ResourceLocation)TexturedModel.createAllSame((ResourceLocation)this.idBlock("br")).createWithSuffix((Block)block.value(), "icon1", blockModels.modelOutput));
        MultiVariant icon2 = BlockModelGenerators.plainVariant((ResourceLocation)TexturedModel.createAllSame((ResourceLocation)this.idBlock("bs")).createWithSuffix((Block)block.value(), "icon2", blockModels.modelOutput));
        MultiVariant icon3 = BlockModelGenerators.plainVariant((ResourceLocation)TexturedModel.createAllSame((ResourceLocation)this.idBlock("bt")).createWithSuffix((Block)block.value(), "icon3", blockModels.modelOutput));
        MultiVariant icon4 = BlockModelGenerators.plainVariant((ResourceLocation)TexturedModel.createAllSame((ResourceLocation)this.idBlock("bu")).createWithSuffix((Block)block.value(), "icon4", blockModels.modelOutput));
        MultiVariant icon5 = BlockModelGenerators.plainVariant((ResourceLocation)TexturedModel.createAllSame((ResourceLocation)this.idBlock("bv")).createWithSuffix((Block)block.value(), "icon5", blockModels.modelOutput));
        MultiVariant icon6 = BlockModelGenerators.plainVariant((ResourceLocation)TexturedModel.createAllSame((ResourceLocation)this.idBlock("bw")).createWithSuffix((Block)block.value(), "icon6", blockModels.modelOutput));
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)block.value())).with((PropertyDispatch)PropertyDispatch.initial((Property)BlockGore.META).select((Comparable)Integer.valueOf(0), (Object)icon).select((Comparable)Integer.valueOf(1), (Object)icon2).select((Comparable)Integer.valueOf(2), (Object)icon3).select((Comparable)Integer.valueOf(3), (Object)icon4).select((Comparable)Integer.valueOf(4), (Object)icon5).select((Comparable)Integer.valueOf(5), (Object)icon6)));
    }

    private void landmineBlock(BlockModelGenerators blockModels, Holder<Block> block) {
        this.simpleBlock(blockModels, block, "notexisting");
    }

    private void marioBlock(BlockModelGenerators blockModels, Holder<Block> block) {
        this.simpleBlock(blockModels, block, "notexisting");
    }

    private void quicksandBlock(BlockModelGenerators blockModels, Holder<Block> block) {
        this.simpleBlock(blockModels, block, "notexisting");
    }

    protected Stream<? extends Holder<Item>> getKnownItems() {
        return BuiltInRegistries.ITEM.listElements();
    }

    private void simpleItem(ItemModelGenerators generator, ItemLike item, String tex) {
        generator.itemModelOutput.accept(item.asItem(), ItemModelUtils.plainModel((ResourceLocation)ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)item.asItem()), TextureMapping.layer0((ResourceLocation)this.modLocation(tex).withPrefix("item/")), generator.modelOutput)));
    }

    private void customModel(ItemModelGenerators generator, ItemLike item) {
        generator.declareCustomModelItem(item.asItem());
    }

    private void objModel(ItemModelGenerators generator, ItemLike item, ResourceLocation modelLocation, ResourceLocation texture, Consumer<RootTransformsBuilder> action) {
        generator.itemModelOutput.accept(item.asItem(), ItemModelUtils.plainModel((ResourceLocation)ExtendedModelTemplateBuilder.builder().customLoader(ObjModelBuilder::new, o -> o.modelLocation(modelLocation)).requiredTextureSlot(TextureSlot.TEXTURE).rootTransforms(action).build().create(item.asItem(), TextureMapping.defaultTexture((ResourceLocation)texture), generator.modelOutput)));
    }

    protected void registerItems(ItemModelGenerators itemModels) {
        this.simpleItem(itemModels, (ItemLike)RRItems.trollmask, "bf");
        this.simpleItem(itemModels, (ItemLike)RRItems.safepill, "ak");
        this.simpleItem(itemModels, (ItemLike)RRItems.remote, "am");
        this.simpleItem(itemModels, (ItemLike)RRItems.pliers, "ap");
        this.simpleItem(itemModels, (ItemLike)RRItems.fuse, "ag");
        this.objModel(itemModels, (ItemLike)RRItems.fuel, RRIdentifiers.getModelLocation("o"), RRIdentifiers.etflamethrower, rootTransformsBuilder -> rootTransformsBuilder.translation(0.8f, 0.5f, -0.03f).rotation(Axis.XP.rotationDegrees(-90.0f)).rotation(Axis.ZP.rotationDegrees(160.0f)).scale(0.15f));
        this.simpleItem(itemModels, (ItemLike)RRItems.expill, "ai");
        this.simpleItem(itemModels, (ItemLike)RRItems.core2, "az");
        this.simpleItem(itemModels, (ItemLike)RRItems.core3, "ba");
        this.simpleItem(itemModels, (ItemLike)RRItems.core1, "ay");
        this.simpleItem(itemModels, (ItemLike)RRItems.chip, "bd");
        this.simpleItem(itemModels, (ItemLike)RRItems.antenna, "aa");
        this.simpleItem(itemModels, (ItemLike)RRItems.armyshovel, "aw");
        this.simpleItem(itemModels, (ItemLike)RRItems.camera, "bi");
        this.simpleItem(itemModels, (ItemLike)RRItems.knife, "ad");
        this.objModel(itemModels, (ItemLike)RRItems.battery, RRIdentifiers.getModelLocation("k"), RRIdentifiers.etbattery, rootTransformsBuilder -> rootTransformsBuilder.translation(0.8f, 0.3f, -0.03f).rotation(Axis.ZP.rotationDegrees(35.0f)).rotation(Axis.YP.rotationDegrees(90.0f)).scale(0.3f, 0.3f, 0.3f));
        this.customModel(itemModels, (ItemLike)RRItems.einsten);
        this.customModel(itemModels, (ItemLike)RRItems.redrod);
        this.customModel(itemModels, (ItemLike)RRItems.hydrod);
        this.customModel(itemModels, (ItemLike)RRItems.NUCLEAR_ROD);
        this.objModel(itemModels, (ItemLike)RRItems.binoculars, RRIdentifiers.getModelLocation("b"), RRIdentifiers.etbinoculars, rootTransformsBuilder -> rootTransformsBuilder.translation(0.5f, 0.5f, -0.03f).rotation(Axis.ZP.rotationDegrees(35.0f)).rotation(Axis.YP.rotationDegrees(90.0f)).scale(0.35f, 0.35f, 0.35f).translation(0.6f, 0.05f, 0.3f));
        this.customModel(itemModels, (ItemLike)RRItems.emptyrod);
        this.customModel(itemModels, (ItemLike)RRItems.gasgrenade);
        this.customModel(itemModels, (ItemLike)RRItems.rocket);
        this.customModel(itemModels, (ItemLike)RRItems.tesla);
        this.customModel(itemModels, (ItemLike)RRItems.hackm202);
        this.customModel(itemModels, (ItemLike)RRItems.plasmacannon);
        this.customModel(itemModels, (ItemLike)RRItems.rpg);
        this.customModel(itemModels, (ItemLike)RRItems.roda);
        this.customModel(itemModels, (ItemLike)RRItems.roddisk);
        this.customModel(itemModels, (ItemLike)RRItems.seekm202);
        this.objModel(itemModels, (ItemLike)RRItems.flamethrower, RRIdentifiers.getModelLocation("n"), RRIdentifiers.etflamethrower, rootTransformsBuilder -> rootTransformsBuilder.rotation(Axis.ZP.rotationDegrees(35.0f)).translation(0.7f, 0.1f, 0.0f).rotation(Axis.YP.rotationDegrees(270.0f)).scale(0.18f, 0.18f, 0.18f));
        this.simpleItem(itemModels, (ItemLike)RRItems.camohat, "oh");
        this.simpleItem(itemModels, (ItemLike)RRItems.camoshirt, "ov");
        this.simpleItem(itemModels, (ItemLike)RRItems.camopants, "op");
        this.simpleItem(itemModels, (ItemLike)RRItems.camoshoes, "ob");
        this.simpleItem(itemModels, (ItemLike)RRItems.camohat2, "sh");
        this.simpleItem(itemModels, (ItemLike)RRItems.camoshirt2, "sv");
        this.simpleItem(itemModels, (ItemLike)RRItems.camopants2, "sp");
        this.simpleItem(itemModels, (ItemLike)RRItems.camoshoes2, "sb");
        this.simpleItem(itemModels, (ItemLike)RRItems.orebelhelmet, "roh");
        this.simpleItem(itemModels, (ItemLike)RRItems.orebelchest, "roc");
        this.simpleItem(itemModels, (ItemLike)RRItems.orebelpants, "rop");
        this.simpleItem(itemModels, (ItemLike)RRItems.orebelboots, "rob");
        this.simpleItem(itemModels, (ItemLike)RRItems.onukerhelmet, "noh");
        this.simpleItem(itemModels, (ItemLike)RRItems.onukerchest, "noc");
        this.simpleItem(itemModels, (ItemLike)RRItems.onukerpants, "nop");
        this.simpleItem(itemModels, (ItemLike)RRItems.onukerboots, "nob");
        this.simpleItem(itemModels, (ItemLike)RRItems.ointelhelmet, "ioh");
        this.simpleItem(itemModels, (ItemLike)RRItems.ointelchest, "ioc");
        this.simpleItem(itemModels, (ItemLike)RRItems.ointelpants, "iop");
        this.simpleItem(itemModels, (ItemLike)RRItems.ointelboots, "iob");
        this.simpleItem(itemModels, (ItemLike)RRItems.ohackerhelmet, "hoh");
        this.simpleItem(itemModels, (ItemLike)RRItems.ohackerchest, "hoc");
        this.simpleItem(itemModels, (ItemLike)RRItems.ohackerpants, "hop");
        this.simpleItem(itemModels, (ItemLike)RRItems.ohackerboots, "hob");
        this.simpleItem(itemModels, (ItemLike)RRItems.srebelhelmet, "rsh");
        this.simpleItem(itemModels, (ItemLike)RRItems.srebelchest, "rsc");
        this.simpleItem(itemModels, (ItemLike)RRItems.srebelpants, "rsp");
        this.simpleItem(itemModels, (ItemLike)RRItems.srebelboots, "rsb");
        this.simpleItem(itemModels, (ItemLike)RRItems.snukerhelmet, "nsh");
        this.simpleItem(itemModels, (ItemLike)RRItems.snukerchest, "nsc");
        this.simpleItem(itemModels, (ItemLike)RRItems.snukerpants, "nsp");
        this.simpleItem(itemModels, (ItemLike)RRItems.snukerboots, "nsb");
        this.simpleItem(itemModels, (ItemLike)RRItems.sintelhelmet, "ish");
        this.simpleItem(itemModels, (ItemLike)RRItems.sintelchest, "isc");
        this.simpleItem(itemModels, (ItemLike)RRItems.sintelpants, "isp");
        this.simpleItem(itemModels, (ItemLike)RRItems.sintelboots, "isb");
        this.simpleItem(itemModels, (ItemLike)RRItems.shackerhelmet, "hsh");
        this.simpleItem(itemModels, (ItemLike)RRItems.shackerchest, "hsc");
        this.simpleItem(itemModels, (ItemLike)RRItems.shackerpants, "hsp");
        this.simpleItem(itemModels, (ItemLike)RRItems.shackerboots, "hsb");
    }
}

