/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.datagen;

import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.datagen.BlockStateDataGen;
import io.github.kadir1243.rivalrebels.datagen.BlockTagsGen;
import io.github.kadir1243.rivalrebels.datagen.DamageSourceTags;
import io.github.kadir1243.rivalrebels.datagen.EntityTypeTagsGen;
import io.github.kadir1243.rivalrebels.datagen.EquipmentAssetGen;
import io.github.kadir1243.rivalrebels.datagen.ItemTagsGen;
import io.github.kadir1243.rivalrebels.datagen.LangGen;
import io.github.kadir1243.rivalrebels.datagen.LootTableDataGen;
import io.github.kadir1243.rivalrebels.datagen.RecipeDataGen;
import io.github.kadir1243.rivalrebels.datagen.SoundDataGen;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageType;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class DataGen {
    public static void onGatherClientData(GatherDataEvent.Client event) {
        event.createProvider(BlockStateDataGen::new);
        event.createProvider(LangGen::new);
        event.createProvider(SoundDataGen::new);
        event.createProvider(EquipmentAssetGen::new);
    }

    public static void onGatherServerData(GatherDataEvent.Server event) {
        event.createDatapackRegistryObjects(new RegistrySetBuilder().add(Registries.DAMAGE_TYPE, context -> {
            for (ResourceKey<DamageType> type : RivalRebelsDamageSource.RRDamageTypes.REGISTERED_DAMAGE_TYPES) {
                context.register(type, (Object)new DamageType("rivalrebels." + type.location().getPath(), 1.0f));
            }
        }));
        event.createProvider(DamageSourceTags::new);
        event.createBlockAndItemTags(BlockTagsGen::new, ItemTagsGen::new);
        event.createProvider(RecipeDataGen.RecipeRunner::new);
        event.createProvider(LootTableDataGen::new);
        event.createProvider(EntityTypeTagsGen::new);
    }
}

