/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels;

import io.github.kadir1243.rivalrebels.RivalRebels;
import io.github.kadir1243.rivalrebels.common.entity.RhodesType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class RRConfig {
    public static final ModConfigSpec SERVER_SPEC;
    public static final Server SERVER;
    public static final ModConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    public static final ModConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        Pair clientSpecPair = new ModConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ModConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
        Pair serverSpecPair = new ModConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ModConfigSpec)serverSpecPair.getRight();
        SERVER = (Server)serverSpecPair.getLeft();
    }

    public static class Common {
        private Common(ModConfigSpec.Builder builder) {
            builder.push("general");
            builder.pop();
        }
    }

    public static class Client {
        private final ModConfigSpec.ConfigValue<Float> nukeScale;
        private final ModConfigSpec.ConfigValue<Float> shroomScale;
        private final ModConfigSpec.BooleanValue antimatterFlash;
        private final ModConfigSpec.ConfigValue<String> bomberType;
        private final ModConfigSpec.BooleanValue goreEnabled;
        private final ModConfigSpec.ConfigValue<Integer> teslasegments;

        private Client(ModConfigSpec.Builder builder) {
            builder.push("client");
            builder.push("explosion");
            this.nukeScale = builder.define("nuke_scale", (Object)Float.valueOf(1.0f));
            this.shroomScale = builder.define("shroom_scale", (Object)Float.valueOf(1.0f));
            this.antimatterFlash = builder.define("antimatter_flash", true);
            builder.pop();
            builder.push("misc");
            this.bomberType = builder.comment("For the B2 bomber, set to 'b2', for Warfare Shuttle 'sh', for Tupolev-95 'tu'.").define("bomber_type", (Object)"b2", o -> o instanceof String && ("b2".equalsIgnoreCase(o.toString()) || "sh".equalsIgnoreCase(o.toString()) || "tu".equalsIgnoreCase(o.toString())));
            this.goreEnabled = builder.define("gore_enabled", true);
            this.teslasegments = builder.define("teslasegments", (Object)2);
            builder.pop();
            builder.pop();
        }

        public float getNukeScale() {
            return ((Float)this.nukeScale.get()).floatValue();
        }

        public float getShroomScale() {
            return ((Float)this.shroomScale.get()).floatValue();
        }

        public boolean isAntimatterFlash() {
            return (Boolean)this.antimatterFlash.get();
        }

        public String getBomberType() {
            return (String)this.bomberType.get();
        }

        public boolean isGoreEnabled() {
            return (Boolean)this.goreEnabled.get();
        }

        public int getTeslaSegments() {
            return (Integer)this.teslasegments.get();
        }
    }

    public static class Server {
        private final ModConfigSpec.BooleanValue rhodesRoundsBase;
        private final ModConfigSpec.BooleanValue flareExplodeOnBreak;
        private final ModConfigSpec.IntValue teleportDistance;
        private final ModConfigSpec.IntValue rhodesHealth;
        private final ModConfigSpec.IntValue landmineExplodeSize;
        private final ModConfigSpec.IntValue spawnDomeRadius;
        private final ModConfigSpec.IntValue bunkerRadius;
        private final ModConfigSpec.BooleanValue infiniteAmmo;
        private final ModConfigSpec.BooleanValue infiniteNukes;
        private final ModConfigSpec.IntValue chargeExplosionSize;
        private final ModConfigSpec.IntValue timedbombExplosionSize;
        private final ModConfigSpec.BooleanValue infiniteGrenades;
        private final ModConfigSpec.ConfigValue<List<? extends String>> rhodesTeams;
        private final ModConfigSpec.BooleanValue prefillrhodes;
        private final ModConfigSpec.ConfigValue<Integer> rhodesNukes;
        private final ModConfigSpec.ConfigValue<Integer> objectiveHealth;
        private final ModConfigSpec.ConfigValue<Integer> objectiveDistance;
        private final ModConfigSpec.ConfigValue<Integer> rhodesInRoundsChance;
        private final ModConfigSpec.BooleanValue freeb83nukes;
        private final ModConfigSpec.BooleanValue scoreboardEnabled;
        private final ModConfigSpec.BooleanValue stopSelfnukeinSP;
        private final ModConfigSpec.IntValue rhodesRandomAmmoBonus;
        private final ModConfigSpec.ConfigValue<Integer> rhodesRandomSeed;
        private final ModConfigSpec.BooleanValue rhodesAI;
        private final ModConfigSpec.IntValue rocketExplosionSize;
        private final ModConfigSpec.ConfigValue<Float> rhodesSpeedScale;
        private final ModConfigSpec.ConfigValue<Integer> teslaDecay;
        private final ModConfigSpec.IntValue nuclearBombStrength;
        private final ModConfigSpec.IntValue nuclearBombCountdown;
        private final ModConfigSpec.IntValue maximumResets;
        private final ModConfigSpec.ConfigValue<Integer> b2spirithealth;
        private final ModConfigSpec.IntValue timedbombTimer;
        private final ModConfigSpec.IntValue tsarBombaStrength;
        private final ModConfigSpec.IntValue b83Strength;
        private final ModConfigSpec.BooleanValue nukedrop;
        private final ModConfigSpec.IntValue tsarBombaSpeed;
        private final ModConfigSpec.ConfigValue<Integer> plasmoidDecay;
        private final ModConfigSpec.BooleanValue rhodesFF;
        private final ModConfigSpec.BooleanValue rhodesCC;
        private final ModConfigSpec.BooleanValue rhodesPromode;
        private final ModConfigSpec.ConfigValue<Integer> bombDamageToRhodes;
        private final ModConfigSpec.BooleanValue freeDragonAmmo;
        private final ModConfigSpec.BooleanValue rhodesScaleSpeed;
        private final ModConfigSpec.BooleanValue rhodesBlockBreak;
        private final ModConfigSpec.BooleanValue elevation;
        private final ModConfigSpec.ConfigValue<Integer> flamethrowerDecay;
        private final ModConfigSpec.ConfigValue<Integer> rpgDecay;
        private static final Collector<RhodesType, ?, List<RhodesType>> RHODES_TYPES_SHUFFLER = Collectors.collectingAndThen(Collectors.toList(), list -> {
            Collections.shuffle(list);
            return list;
        });

        private Server(ModConfigSpec.Builder builder) {
            builder.push("server");
            builder.comment("Measured in blocks.").push("buildsize");
            this.teleportDistance = builder.defineInRange("TeleportDistance", 150, 70, 500);
            this.spawnDomeRadius = builder.defineInRange("spawnDomeRadius", 20, 10, 30);
            this.bunkerRadius = builder.defineInRange("bunkerRadius", 10, 7, 15);
            this.objectiveDistance = builder.define("objectiveDistance", (Object)200);
            builder.pop();
            builder.comment("Miscellaneous.").push("misc");
            this.rhodesRoundsBase = builder.define("rhodesRoundsBase", true);
            this.flareExplodeOnBreak = builder.define("flareExplodeOnBreak", true);
            this.rhodesHealth = builder.defineInRange("rhodesHealth", 15000, 15000, Integer.MAX_VALUE);
            this.objectiveHealth = builder.define("objectiveHealth", (Object)15000);
            this.b2spirithealth = builder.define("b2spirithealth", (Object)1000);
            this.infiniteAmmo = builder.define("infiniteAmmo", false);
            this.infiniteNukes = builder.define("infiniteNukes", false);
            this.infiniteGrenades = builder.define("infiniteGrenades", false);
            this.rhodesTeams = builder.comment("Repeat the type for multiple occurences of the same rhodes. Leave Empty For Random Rhodes Types").defineList("rhodesTeams", List.of(), o -> RivalRebels.RHODES_TYPE_REGISTRY.containsKey(ResourceLocation.tryParse((String)o.toString())));
            this.prefillrhodes = builder.define("prefillrhodes", true);
            this.rhodesNukes = builder.define("rhodesNukes", (Object)8);
            this.rhodesInRoundsChance = builder.define("rhodesInRoundsChance", (Object)0);
            this.rhodesRandomAmmoBonus = builder.comment("Multiplies the Rhodes' random ammo bonus. Set to 0 to disable bonus.").defineInRange("rhodesRandomAmmoBonus", 1, 0, 5);
            this.rhodesRandomSeed = builder.define("rhodesRandomSeed", (Object)2168344);
            this.rhodesAI = builder.define("rhodesAIEnabled", true);
            this.rhodesSpeedScale = builder.define("rhodesSpeedScale", (Object)Float.valueOf(1.0f));
            this.freeb83nukes = builder.define("freeb83nukes", false);
            this.scoreboardEnabled = builder.define("scoreboardEnabled", true);
            this.stopSelfnukeinSP = builder.define("stopSelfnukeinSP", false);
            this.maximumResets = builder.defineInRange("MaximumResets", 2, 0, 100);
            this.rhodesFF = builder.define("rhodesFriendlyFire", true);
            this.rhodesCC = builder.define("rhodesTeamFriendlyFire", true);
            this.rhodesPromode = builder.define("rhodesPromode", false);
            this.freeDragonAmmo = builder.define("freeDragonAmmo", false);
            this.bombDamageToRhodes = builder.define("bombDamageToRhodes", (Object)20);
            this.rhodesScaleSpeed = builder.define("rhodesScaleSpeed", false);
            this.rhodesBlockBreak = builder.define("rhodesBlockBreak", true);
            builder.pop();
            builder.comment("Measured in blocks. Nuclear bomb just adds the specified number to its calculation.").push("ExplosionSize");
            this.landmineExplodeSize = builder.defineInRange("landmineExplodeSize", 2, 1, 15);
            this.chargeExplosionSize = builder.defineInRange("chargeExplosionSize", 5, 1, 15);
            this.timedbombExplosionSize = builder.defineInRange("timedbombExplosionSize", 6, 1, 20);
            this.rocketExplosionSize = builder.defineInRange("rocketExplosionSize", 4, 1, 10);
            this.nuclearBombStrength = builder.defineInRange("NuclearBombStrength", 10, 2, 30);
            this.tsarBombaStrength = builder.defineInRange("tsarBombaStrength", 24, 0, 50);
            this.b83Strength = builder.defineInRange("b83Strength", 15, 0, 50);
            this.nukedrop = builder.define("nukedrop", true);
            this.tsarBombaSpeed = builder.defineInRange("tsarBombaSpeed", 8, 4, Integer.MAX_VALUE);
            this.elevation = builder.define("elevation", true);
            builder.pop();
            builder.comment("Measured in ticks of existence. Tesla is in blocks.").push("decay");
            this.teslaDecay = builder.defineInRange("TeslaDecay", 250, 20, 400);
            this.plasmoidDecay = builder.define("plasmoidDecay", (Object)70);
            this.flamethrowerDecay = builder.define("FlamethrowerDecay", (Object)64);
            this.rpgDecay = builder.define("RPGDecay", (Object)200);
            builder.pop();
            builder.comment("Measured in seconds.").push("timing");
            this.nuclearBombCountdown = builder.defineInRange("NuclearBombCountdown", 25, 0, Integer.MAX_VALUE);
            this.timedbombTimer = builder.defineInRange("timedbombTimer", 25, 10, 300);
            builder.pop();
            builder.pop();
        }

        public int getFlamethrowerDecay() {
            return (Integer)this.flamethrowerDecay.get();
        }

        public int getRpgDecay() {
            return (Integer)this.rpgDecay.get();
        }

        public boolean isElevation() {
            return (Boolean)this.elevation.get();
        }

        public boolean isTeamFriendlyFireRhodesEnabled() {
            return (Boolean)this.rhodesCC.get();
        }

        public boolean isFriendlyFireRhodesEnabled() {
            return (Boolean)this.rhodesFF.get();
        }

        public boolean isRhodesPromode() {
            return (Boolean)this.rhodesPromode.get();
        }

        public int getBombDamageToRhodes() {
            return (Integer)this.bombDamageToRhodes.get();
        }

        public boolean isFreeDragonAmmo() {
            return (Boolean)this.freeDragonAmmo.get();
        }

        public boolean isRhodesScaleSpeed() {
            return (Boolean)this.rhodesScaleSpeed.get();
        }

        public boolean getRhodesBlockBreak() {
            return (Boolean)this.rhodesBlockBreak.get();
        }

        public int getTsarBombaSpeed() {
            return (Integer)this.tsarBombaSpeed.get();
        }

        public int getPlasmoidDecay() {
            return (Integer)this.plasmoidDecay.get();
        }

        public boolean isNukedrop() {
            return (Boolean)this.nukedrop.get();
        }

        public int getB83Strength() {
            return (Integer)this.b83Strength.get();
        }

        public int getTsarBombaStrength() {
            return (Integer)this.tsarBombaStrength.get();
        }

        public int getB2spirithealth() {
            return (Integer)this.b2spirithealth.get();
        }

        public int getTimedbombTimer() {
            return (Integer)this.timedbombTimer.get();
        }

        public int getTeslaDecay() {
            return (Integer)this.teslaDecay.get();
        }

        public int getNuclearBombStrength() {
            return (Integer)this.nuclearBombStrength.get();
        }

        public int getMaximumResets() {
            return (Integer)this.maximumResets.get();
        }

        public int getNuclearBombCountdown() {
            return (Integer)this.nuclearBombCountdown.get();
        }

        public boolean isRhodesRoundsBase() {
            return (Boolean)this.rhodesRoundsBase.get();
        }

        public int getTeleportDistance() {
            return (Integer)this.teleportDistance.get();
        }

        public float getRhodesSpeedScale() {
            return ((Float)this.rhodesSpeedScale.get()).floatValue();
        }

        public int getRocketExplosionSize() {
            return (Integer)this.rocketExplosionSize.get();
        }

        public boolean isFlareExplodeOnBreak() {
            return (Boolean)this.flareExplodeOnBreak.get();
        }

        public int getRhodesHealth() {
            return (Integer)this.rhodesHealth.get();
        }

        public int getLandmineExplodeSize() {
            return (Integer)this.landmineExplodeSize.get();
        }

        public int getSpawnDomeRadius() {
            return (Integer)this.spawnDomeRadius.get();
        }

        public int getBunkerRadius() {
            return (Integer)this.bunkerRadius.get();
        }

        public boolean isInfiniteAmmo() {
            return (Boolean)this.infiniteAmmo.get();
        }

        public boolean isInfiniteNukes() {
            return (Boolean)this.infiniteNukes.get();
        }

        public int getChargeExplosionSize() {
            return (Integer)this.chargeExplosionSize.get();
        }

        public int getTimedbombExplosionSize() {
            return (Integer)this.timedbombExplosionSize.get();
        }

        public boolean isInfiniteGrenades() {
            return (Boolean)this.infiniteGrenades.get();
        }

        public RhodesType[] getRhodesTeams() {
            List list = (List)this.rhodesTeams.get();
            if (list.isEmpty()) {
                return RivalRebels.RHODES_TYPE_REGISTRY.stream().collect(RHODES_TYPES_SHUFFLER).toArray(new RhodesType[0]);
            }
            return (RhodesType[])list.stream().map(ResourceLocation::tryParse).filter(Objects::nonNull).map(arg_0 -> RivalRebels.RHODES_TYPE_REGISTRY.get(arg_0)).filter(Optional::isPresent).map(Optional::get).map(Holder.Reference::value).toArray(RhodesType[]::new);
        }

        public boolean isPrefillrhodes() {
            return (Boolean)this.prefillrhodes.get();
        }

        public int getRhodesNukes() {
            return (Integer)this.rhodesNukes.get();
        }

        public int getObjectiveHealth() {
            return (Integer)this.objectiveHealth.get();
        }

        public int getObjectiveDistance() {
            return (Integer)this.objectiveDistance.get();
        }

        public float getRhodesInRoundsChance() {
            return (float)((Integer)this.rhodesInRoundsChance.get()).intValue() / 100.0f;
        }

        public boolean isFreeb83nukes() {
            return (Boolean)this.freeb83nukes.get();
        }

        public boolean isScoreboardEnabled() {
            return (Boolean)this.scoreboardEnabled.get();
        }

        public boolean isStopSelfnukeinSP() {
            return (Boolean)this.stopSelfnukeinSP.get();
        }

        public int getRhodesRandomAmmoBonus() {
            return (Integer)this.rhodesRandomAmmoBonus.get();
        }

        public int getRhodesRandomSeed() {
            return (Integer)this.rhodesRandomSeed.get();
        }

        public boolean isRhodesAIEnabled() {
            return (Boolean)this.rhodesAI.get();
        }
    }
}

