/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.gui;

import io.github.kadir1243.rivalrebels.client.renderhelper.RRTextures;
import io.github.kadir1243.rivalrebels.common.container.BombContainer;
import io.github.kadir1243.rivalrebels.common.util.Translations;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.phys.Vec2;

public abstract class BombContainerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    public BombContainerScreen(T menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        this.showTimer(guiGraphics);
        if (this.scaleName()) {
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().scale(0.666f, 0.666f);
        }
        this.renderName(guiGraphics);
        if (this.scaleName()) {
            guiGraphics.pose().popMatrix();
        }
    }

    public void showTimer(GuiGraphics graphics) {
        int seconds = this.getCountdown() / 20;
        int millis = this.getCountdown() % 20 * 3;
        String milli = millis < 10 ? "0" + millis : "" + millis;
        graphics.drawString(this.font, (Component)Translations.BOMB_TIMER.translate().append(": -" + seconds + ":" + milli), (int)this.getTimerPos().x, (int)this.getTimerPos().y, this.getTimerColor(), false);
    }

    public abstract Vec2 getTimerPos();

    public abstract int getTimerColor();

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public int getCountdown() {
        return ((BombContainer)this.menu).getCountdown();
    }

    public abstract void renderName(GuiGraphics var1);

    public boolean scaleName() {
        return true;
    }

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.getBackgroundTexture().blit(graphics, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, -1);
    }

    public abstract RRTextures.Texture getBackgroundTexture();
}

