/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.gui;

import io.github.kadir1243.rivalrebels.client.gui.GuiSpawn;
import io.github.kadir1243.rivalrebels.client.guihelper.GuiButton;
import io.github.kadir1243.rivalrebels.client.guihelper.GuiScroll;
import io.github.kadir1243.rivalrebels.client.renderhelper.RRTextures;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsClass;
import io.github.kadir1243.rivalrebels.mixin.client.GuiGraphicsAccessor;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix3x2fStack;

@OnlyIn(value=Dist.CLIENT)
public class GuiClass
extends Screen {
    private static final int xSizeOfTexture = 256;
    private static final int ySizeOfTexture = 256;
    private int posX;
    private int posY;
    private static final float[] sizelookup = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private Button nextButton;
    private Button doneButton;
    private GuiScroll gameScroll;
    private RivalRebelsClass rrclass;

    public GuiClass(RivalRebelsClass rrc) {
        super((Component)Component.empty());
        this.posX = (this.width - 256) / 2;
        this.posY = (this.height - 256) / 2;
        this.rrclass = rrc;
    }

    public void init() {
        this.posX = (this.width - 256) / 2;
        this.posY = (this.height - 256) / 2;
        this.nextButton = Button.builder((Component)Component.translatable((String)"RivalRebels.class.next"), button -> {
            switch (this.rrclass) {
                case HACKER: {
                    this.rrclass = RivalRebelsClass.REBEL;
                    break;
                }
                case INTEL: {
                    this.rrclass = RivalRebelsClass.HACKER;
                    break;
                }
                case NONE: {
                    this.rrclass = RivalRebelsClass.REBEL;
                    break;
                }
                case NUKER: {
                    this.rrclass = RivalRebelsClass.INTEL;
                    break;
                }
                case REBEL: {
                    this.rrclass = RivalRebelsClass.NUKER;
                }
            }
        }).bounds(this.posX + 188, this.posY + 102, 60, 11).build(GuiButton::new);
        this.doneButton = Button.builder((Component)Component.translatable((String)"RivalRebels.class.done"), button -> this.minecraft.setScreen((Screen)new GuiSpawn(this.rrclass))).bounds(this.posX + 188, this.posY + 119, 60, 11).build(GuiButton::new);
        this.gameScroll = (GuiScroll)Button.builder((Component)Component.empty(), button -> {}).bounds(this.posX + 243, this.posY + 9, 5, 11).build(builder -> new GuiScroll((Button.Builder)builder, 74.0f));
        this.addRenderableWidget((GuiEventListener)this.nextButton);
        this.addRenderableWidget((GuiEventListener)this.doneButton);
        this.addRenderableWidget((GuiEventListener)this.gameScroll);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int Y;
        int X;
        int i;
        Matrix3x2fStack pose = graphics.pose();
        if (this.rrclass == RivalRebelsClass.NONE) {
            this.rrclass = RivalRebelsClass.REBEL;
        }
        float f = 0.00390625f;
        this.renderTransparentBackground(graphics);
        graphics.fillGradient(this.posX, this.posY, this.posX + 256, this.posY + 256, -16777216, -16777216);
        this.drawPanel(graphics, this.posX + 162, this.posY + 40, 80, 74, this.gameScroll.getScroll(), this.gameScroll.limit, this.rrclass);
        graphics.fillGradient(this.posX + 160, this.posY + 9, this.posX + 244, this.posY + 38, -16777216, -16777216);
        ((GuiGraphicsAccessor)graphics).blit(RenderPipelines.GUI_TEXTURED, RRTextures.guitclass, this.posX, this.posX + 256, this.posY + 256, this.posY, 0.0f, 0.0f, 256.0f * f, 256.0f * f, 0);
        this.rrclass.resource.get().blit(graphics, this.posX + 12, this.posY + 12, 128.0f, 128.0f, 256, 256, -1);
        float scalefactor = 1.5f;
        pose.pushMatrix();
        pose.scale(scalefactor * 1.2f, scalefactor);
        graphics.drawCenteredString(this.font, this.rrclass.name, (int)((float)(this.posX + 76) / (scalefactor * 1.2f)), (int)((float)(this.posY + 16) / scalefactor), this.rrclass.color);
        pose.popMatrix();
        scalefactor = 0.666f;
        pose.pushMatrix();
        pose.scale(scalefactor, scalefactor);
        graphics.drawCenteredString(this.font, (Component)this.rrclass.getMiniDescription().translate(), (int)((float)(this.posX + 76) / scalefactor), (int)((float)(this.posY + 28) / scalefactor), this.rrclass.color);
        pose.popMatrix();
        scalefactor = 0.666f;
        pose.pushMatrix();
        pose.scale(scalefactor, scalefactor);
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"RivalRebels.class.description"), (int)((float)(this.posX + 181) / scalefactor), (int)((float)(this.posY + 28) / scalefactor), this.rrclass.color);
        pose.popMatrix();
        for (i = 0; i < sizelookup.length; ++i) {
            X = this.posX + 18 + i % 9 * 22;
            Y = this.posY + 158 + 22 * Mth.floor((double)((double)i / 9.0));
            float size = sizelookup[i];
            if (mouseX >= X && mouseY >= Y && mouseX < X + 16 && mouseY < Y + 16) {
                if ((double)size < 1.5) {
                    size += 0.1f;
                }
            } else if (size > 1.0f) {
                size -= 0.1f;
            }
            GuiClass.sizelookup[i] = size;
        }
        for (i = this.rrclass.getInventory().size() - 1; i >= 0; --i) {
            X = this.posX + 18 + i % 9 * 22;
            Y = this.posY + 158 + 22 * (i / 9);
            pose.pushMatrix();
            pose.translate((float)(X + 8), (float)(Y + 8));
            pose.scale(sizelookup[i], sizelookup[i]);
            pose.translate((float)(-X - 8), (float)(-Y - 8));
            graphics.renderItem(this.rrclass.getInventory().get(i), X, Y);
            ItemStack stack = this.rrclass.getInventory().get(i);
            if (!stack.isEmpty()) {
                graphics.drawString(this.font, Component.nullToEmpty((String)String.valueOf(stack.getCount())), X + 17 - this.font.width(String.valueOf(stack.getCount())), Y + 9, 0xFFFFFF);
            }
            if (sizelookup[i] > 1.0f) {
                graphics.fillGradient(X + 17, Y + 3, (int)((float)X + (float)(this.font.width((FormattedText)stack.getHoverName()) + 4) * (sizelookup[i] - 1.0f) * 2.0f + 15.0f), Y + 13, -1441722095, -1441722095);
                graphics.drawString(this.font, stack.getHoverName(), X + 18, Y + 4, 0xFFFFFF);
            }
            pose.popMatrix();
        }
        super.render(graphics, mouseX, mouseY, delta);
    }

    protected void drawPanel(GuiGraphics context, int x, int y, int width, int height, float scroll, float scrolllimit, RivalRebelsClass rrclass) {
        int length = 10;
        int dist = (int)(-(scroll / scrolllimit) * (float)(length * 10 - height));
        float scalefactor = 0.6666f;
        context.pose().pushMatrix();
        context.pose().scale(scalefactor, scalefactor);
        context.drawWordWrap(this.font, (FormattedText)rrclass.getDescription().translate(), (int)((double)x * 1.5), (int)((double)(y + dist) * 1.5), (int)((double)width * 1.5), 0xFFFFFF);
        context.pose().popMatrix();
    }
}

