/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.gui;

import io.github.kadir1243.rivalrebels.client.guihelper.GuiCustomButton;
import io.github.kadir1243.rivalrebels.client.guihelper.ReactorConnectedMachinesList;
import io.github.kadir1243.rivalrebels.client.renderhelper.RRTextures;
import io.github.kadir1243.rivalrebels.common.container.ContainerReactor;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.item.components.RRComponents;
import io.github.kadir1243.rivalrebels.common.noise.RivalRebelsSimplexNoise;
import io.github.kadir1243.rivalrebels.common.packet.ReactorMachinesPacket;
import io.github.kadir1243.rivalrebels.common.packet.ReactorStatePacket;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.joml.Vector2i;

@OnlyIn(value=Dist.CLIENT)
public class GuiReactor
extends AbstractContainerScreen<ContainerReactor> {
    private static final DecimalFormat df = new DecimalFormat("0.0");
    private static final RivalRebelsSimplexNoise SIMPLEX_NOISE = new RivalRebelsSimplexNoise(RandomSource.create());
    private static final List<ReactorMachinesPacket.MachineEntry> machineEntries = new ArrayList<ReactorMachinesPacket.MachineEntry>();
    private float frame = 0.0f;
    private float resolution = 4.0f;
    private GuiCustomButton power;
    private GuiCustomButton eject;
    private float melttick = 30.0f;
    private ReactorConnectedMachinesList dockWidget;

    public GuiReactor(ContainerReactor containerReactor, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)containerReactor, playerInventory, title);
        this.imageHeight = 200;
    }

    public static void onMachinesPacket(ReactorMachinesPacket packet, IPayloadContext context) {
        machineEntries.clear();
        machineEntries.addAll(packet.machines());
    }

    protected void init() {
        super.init();
        int posX = (this.width - 256) / 2;
        int posY = (this.height - 256) / 2;
        this.power = new GuiCustomButton(new ScreenRectangle(posX + 70, posY + 164, 22, 22), RRTextures.guittokamak, new Vector2i(212, 0), true, button -> Minecraft.getInstance().getConnection().send((CustomPacketPayload)new ReactorStatePacket(((ContainerReactor)this.menu).getPos(), ReactorStatePacket.Type.TOGGLE_ON)));
        this.eject = new GuiCustomButton(new ScreenRectangle(posX + 164, posY + 164, 22, 22), RRTextures.guittokamak, new Vector2i(234, 0), false, button -> Minecraft.getInstance().getConnection().send((CustomPacketPayload)new ReactorStatePacket(((ContainerReactor)this.menu).getPos(), ReactorStatePacket.Type.EJECT_CORE)));
        this.power.isPressed = ((ContainerReactor)this.menu).isOn();
        this.addRenderableWidget((GuiEventListener)this.power);
        this.addRenderableWidget((GuiEventListener)this.eject);
        this.dockWidget = new ReactorConnectedMachinesList(this.minecraft, 20, 70, 89 + this.width / 2, this.height / 2, 18);
        this.addRenderableWidget((GuiEventListener)this.dockWidget);
        for (ReactorMachinesPacket.MachineEntry entry : machineEntries) {
            this.dockWidget.addEntry(new ReactorConnectedMachinesList.WidgetEntry(entry.pos(), entry.block(), entry.enabled()));
        }
        machineEntries.clear();
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.pose().pushMatrix();
        graphics.pose().scale(1.25f, 1.0f);
        ((ContainerReactor)this.menu).core.locked = ((ContainerReactor)this.menu).isOn();
        ((ContainerReactor)this.menu).fuel.locked = ((ContainerReactor)this.menu).fuel.hasItem() && ((ContainerReactor)this.menu).isOn();
        graphics.drawString(this.font, "ToKaMaK", 10, 8, 0x444444, false);
        graphics.pose().popMatrix();
        graphics.drawString(this.font, "Teslas: " + df.format(((ContainerReactor)this.menu).getPower() - (float)((ContainerReactor)this.menu).getConsumed()), 120, 8, 0xFFFFFF, false);
        graphics.drawString(this.font, "Output/t: " + df.format(((ContainerReactor)this.menu).getLastTickConsumed()), 140, 18, 0xFFFFFF, false);
    }

    public void onClose() {
        super.onClose();
        Minecraft.getInstance().getConnection().send((CustomPacketPayload)new ReactorMachinesPacket(((ContainerReactor)this.menu).getPos(), this.dockWidget.children().stream().map(e -> new ReactorMachinesPacket.MachineEntry(e.getMachinePos(), e.getMachine(), e.isEnabledMachine())).toList()));
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        RRTextures.guittokamak.blit(context, this.width / 2 - 89, this.height / 2 - 103, 0.0f, 0.0f, 212, 208, -1);
        long time = System.currentTimeMillis();
        if (((ContainerReactor)this.menu).isOn() && ((ContainerReactor)this.menu).fuel.hasItem() && ((ContainerReactor)this.menu).core.getItem().has(RRComponents.CORE_TIME_MULTIPLIER)) {
            float radius = 10.0f;
            if (((ContainerReactor)this.menu).fuel.getItem().has(RRComponents.REACTOR_FUEL_LEFT)) {
                float timemult = ((Float)((ContainerReactor)this.menu).core.getItem().get(RRComponents.CORE_TIME_MULTIPLIER)).floatValue();
                radius += ((float)((Integer)((ContainerReactor)this.menu).fuel.getItem().get(RRComponents.ROD_POWER)).intValue() * timemult - (float)((Integer)((ContainerReactor)this.menu).fuel.getItem().getOrDefault(RRComponents.REACTOR_FUEL_LEFT, (Object)0)).intValue()) / ((float)((Integer)((ContainerReactor)this.menu).fuel.getItem().get(RRComponents.ROD_POWER)).intValue() * timemult) * 30.0f;
            }
            this.melttick = 30.0f;
            float brightness = 0.0f;
            if (((ContainerReactor)this.menu).core.getItem().is(RRItems.core1)) {
                brightness = -0.4f;
            }
            if (((ContainerReactor)this.menu).core.getItem().is(RRItems.core2)) {
                brightness = -0.25f;
            }
            if (((ContainerReactor)this.menu).core.getItem().is(RRItems.core3)) {
                brightness = -0.1f;
            }
            if (((ContainerReactor)this.menu).fuel.getItem().is(RRItems.NUCLEAR_ROD)) {
                this.drawNoiseSphere(context, 0.9f, 1.0f, 0.1f, 0.0f, 1.0f, 0.1f, this.frame, 4, (int)radius, (int)(50.0f - radius), this.resolution, 0.02f, brightness);
            }
            if (((ContainerReactor)this.menu).fuel.getItem().is(RRItems.hydrod)) {
                this.drawNoiseSphere(context, 1.0f, 1.0f, 1.0f, 0.7f, 0.0f, 1.0f, this.frame, 4, (int)radius, (int)(50.0f - radius), this.resolution, 0.02f, brightness);
            }
            if (((ContainerReactor)this.menu).fuel.getItem().is(RRItems.redrod)) {
                this.drawNoiseSphere(context, 1.0f, 0.8f, 0.0f, 1.0f, 0.0f, 0.0f, this.frame, 4, (int)radius, (int)(50.0f - radius), this.resolution, 0.02f, brightness);
            }
        } else if (((ContainerReactor)this.menu).isMelt() || ((ContainerReactor)this.menu).isOn() && !((ContainerReactor)this.menu).fuel.hasItem()) {
            if (this.melttick > 1.0f) {
                this.melttick -= 0.03f;
            }
            this.drawNoiseSphere(context, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, this.frame, 4, (int)(20.0f + Mth.sin((float)(this.frame / this.melttick)) * 20.0f), 10, this.resolution, 0.02f, 0.0f);
        } else if (((ContainerReactor)this.menu).fuel.hasItem() && ((ContainerReactor)this.menu).core.hasItem()) {
            this.drawInfographic(context, this.resolution, 15, 8, 5, 20, 0.666f, 0.25f, 0.32f);
        }
        long elapsed = System.currentTimeMillis() - time;
        if (elapsed > 30L) {
            if ((double)this.resolution == 0.25) {
                this.resolution = 0.125f;
            }
            if ((double)this.resolution == 0.5) {
                this.resolution = 0.25f;
            }
            if (this.resolution == 1.0f) {
                this.resolution = 0.5f;
            }
            if (this.resolution == 2.0f) {
                this.resolution = 1.0f;
            }
            if (this.resolution == 4.0f) {
                this.resolution = 2.0f;
            }
        }
        this.frame += 0.75f + (float)(((ContainerReactor)this.menu).getLastTickConsumed() / 100);
        this.power.isPressed = ((ContainerReactor)this.menu).isOn();
    }

    protected void drawNoiseSphere(GuiGraphics graphics, float red, float grn, float blu, float red1, float grn1, float blu1, float frame, int o, int radius, int outer, float resolution, float sscale, float startcol) {
        graphics.pose().pushMatrix();
        float pointSize = (float)this.minecraft.getWindow().getGuiScale() / resolution;
        radius = (int)((float)radius * resolution);
        int outerR = (int)((float)radius + (float)outer * resolution);
        int maxdist = outerR - radius;
        float hheight = this.height / 2 - 45;
        float hwidth = this.width / 2;
        float rradius = radius * radius;
        for (int x = 1 - outerR; x < outerR; ++x) {
            int xs = x * x;
            float X = (float)x / resolution + hwidth;
            for (int y = 1 - outerR; y < outerR; ++y) {
                int ys = y * y + xs;
                float Y = (float)y / resolution + hheight;
                float fdist = Mth.sqrt((float)ys);
                if (fdist >= (float)radius && fdist < (float)outerR) {
                    float v = 0.0f;
                    float a = 1.0f;
                    float s = sscale;
                    for (int e = 0; e < o; ++e) {
                        v += (float)((1.0 + SIMPLEX_NOISE.noise(X * s, Y * s, frame * s)) / 2.0) * a;
                        s *= 2.0f;
                        a /= 2.0f;
                    }
                    GuiReactor.drawPoint(graphics, pointSize, X, Y, 4.0f, ARGB.colorFromFloat((float)(v *= 1.0f - (fdist - (float)radius) / (float)maxdist), (float)GuiReactor.lerp(red, red1, v), (float)GuiReactor.lerp(grn, grn1, v), (float)GuiReactor.lerp(blu, blu1, v)));
                    continue;
                }
                float Z = Mth.sqrt((float)(rradius - (float)ys)) / resolution;
                float v = startcol;
                float a = 1.0f;
                float s = sscale;
                for (int e = 0; e < o; ++e) {
                    v += (float)((1.0 + SIMPLEX_NOISE.noise(X * s, Y * s, Z * s, frame * s)) / 2.0) * a;
                    s *= 2.0f;
                    a /= 2.0f;
                }
                GuiReactor.drawPoint(graphics, pointSize, X, Y, 4.0f, ARGB.colorFromFloat((float)v, (float)GuiReactor.lerp(red, red1, v), (float)GuiReactor.lerp(grn, grn1, v), (float)GuiReactor.lerp(blu, blu1, v)));
            }
        }
        graphics.pose().popMatrix();
    }

    private static void drawPoint(GuiGraphics graphics, float pointSize, float x, float y, float z, int color) {
        float halfSize = pointSize / 2.0f;
        graphics.fill((int)(x - halfSize), (int)(y - halfSize), (int)(x + halfSize), (int)(y + halfSize), color);
    }

    protected static float lerp(float delta, float start, float end) {
        return start * (1.0f - end) + delta * end;
    }

    protected void drawInfographic(GuiGraphics graphics, float resolution, int radius, int sep, int width1, int width2, float outerRatio, float innerRatio1, float innerRatio2) {
        float pointSize = 4.0f / resolution;
        radius = (int)((float)radius * resolution);
        sep = (int)((float)sep * resolution);
        width1 = (int)((float)width1 * resolution);
        width2 = (int)((float)width2 * resolution);
        innerRatio1 *= outerRatio;
        innerRatio2 *= outerRatio;
        innerRatio2 += outerRatio;
        outerRatio *= (float)Math.PI * 2;
        innerRatio1 *= (float)Math.PI * 2;
        innerRatio2 *= (float)Math.PI * 2;
        int midR1 = radius + width1;
        int midR2 = midR1 + sep;
        int outerR = midR2 + width2;
        float hheight = this.height / 2;
        float hwidth = this.width / 2;
        for (int x = 1 - outerR; x < outerR; ++x) {
            int xs = x * x;
            float X = (float)x / resolution;
            for (int y = 1 - outerR; y < outerR; ++y) {
                int color;
                float angle;
                float Y;
                int ys = y * y;
                float fdist = Mth.sqrt((float)(xs + ys));
                if (fdist >= (float)radius && fdist < (float)midR1) {
                    Y = (float)y / resolution;
                    angle = (float)(3.1415927410125732 + Mth.atan2((double)X, (double)Y));
                    color = angle <= outerRatio ? (angle <= innerRatio1 ? ARGB.colorFromFloat((float)0.25f, (float)0.25f, (float)1.0f, (float)1.0f) : ARGB.colorFromFloat((float)0.75f, (float)0.75f, (float)1.0f, (float)1.0f)) : (angle <= innerRatio2 ? ARGB.colorFromFloat((float)1.0f, (float)0.25f, (float)0.25f, (float)1.0f) : ARGB.colorFromFloat((float)1.0f, (float)0.75f, (float)0.75f, (float)1.0f));
                    GuiReactor.drawPoint(graphics, pointSize, hwidth + X, hheight + Y - 45.0f, 4.0f, color);
                    continue;
                }
                if (!(fdist >= (float)midR2) || !(fdist < (float)outerR)) continue;
                Y = (float)y / resolution;
                angle = (float)(3.1415927410125732 + Mth.atan2((double)X, (double)Y));
                color = angle <= outerRatio ? -16776961 : -65536;
                GuiReactor.drawPoint(graphics, pointSize, hwidth + X, hheight + Y - 45.0f, 4.0f, color);
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }
}

