/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.gui;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.kadir1243.rivalrebels.RRClient;
import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.client.renderhelper.RRTextures;
import io.github.kadir1243.rivalrebels.client.renderhelper.RenderTypes;
import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodes;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.item.components.BinocularData;
import io.github.kadir1243.rivalrebels.common.item.components.RRComponents;
import io.github.kadir1243.rivalrebels.common.item.weapon.ItemBinoculars;
import io.github.kadir1243.rivalrebels.common.noise.RivalRebelsCellularNoise;
import io.github.kadir1243.rivalrebels.common.util.Translations;
import io.github.kadir1243.rivalrebels.mixin.client.GuiGraphicsAccessor;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public class RivalRebelsRenderOverlay {
    public int tic = 0;
    public boolean r = false;
    public EntityRhodes rhodes = null;
    public float counter = 0.0f;

    public void init(IEventBus bus) {
        bus.addListener(RegisterGuiLayersEvent.class, event -> {
            event.registerBelowAll(RRIdentifiers.create("render_binoculars"), (guiGraphics, deltaTracker) -> this.renderItems(guiGraphics));
            event.registerAboveAll(RRIdentifiers.create("render_rhodes"), (guiGraphics, deltaTracker) -> this.renderRhodes(guiGraphics, (Player)Minecraft.getInstance().player, this.rhodes, deltaTracker));
        });
    }

    public void setOverlay(EntityRhodes rhodes) {
        if (rhodes.rider == Minecraft.getInstance().player) {
            this.counter = 10.0f;
            this.rhodes = rhodes;
        }
    }

    private void renderItems(GuiGraphics graphics) {
        Minecraft client = Minecraft.getInstance();
        LocalPlayer player = client.player;
        ItemStack stack = player.getInventory().getSelectedItem();
        if (stack.isEmpty()) {
            return;
        }
        if (stack.getItem() instanceof ItemBinoculars) {
            this.renderBinoculars(stack, graphics, (Player)player);
        }
    }

    private void renderRhodes(final GuiGraphics graphics, Player player, EntityRhodes rhodes, DeltaTracker tracker) {
        if (rhodes == null) {
            return;
        }
        float deltaTicks = tracker.getGameTimeDeltaPartialTick(true);
        this.counter = Mth.lerp((float)deltaTicks, (float)this.counter, (float)(this.counter - 1.0f));
        if (this.counter <= 0.0f) {
            this.counter = 0.0f;
            RRClient.rrro.rhodes = null;
        }
        Minecraft client = Minecraft.getInstance();
        Font fr = client.font;
        final int w = graphics.guiWidth();
        final int h = graphics.guiHeight();
        ((GuiGraphicsAccessor)graphics).blit(RenderPipelines.GUI_TEXTURED, RRTextures.guirhodesline.location(), 0, w, h, 0, 0.0f, 1.0f, 0.0f, 1.0f, ARGB.colorFromFloat((float)0.5f, (float)1.0f, (float)0.0f, (float)0.0f));
        ((GuiGraphicsAccessor)graphics).blit(RenderPipelines.GUI_TEXTURED, RRTextures.guirhodesout, 0, w, h, 0, 1.0f, 0.0f, 1.0f, 0.0f, ARGB.colorFromFloat((float)0.333f, (float)0.0f, (float)0.0f, (float)0.0f));
        if (GLFW.glfwGetKey((long)client.getWindow().getWindow(), (int)72) == 1) {
            ((GuiGraphicsAccessor)graphics).blit(RenderPipelines.GUI_TEXTURED, RRTextures.guirhodeshelp, Mth.floor((float)((float)w * 0.25f)), Mth.floor((float)((float)w * 0.75f)), Mth.floor((float)((float)h * 0.25f)), Mth.floor((float)((float)h * 0.75f)), -90.0f, 1.0f, 0.0f, 1.0f, 0);
        }
        if (!rhodes.getFlagTextureLocation().isBlank()) {
            float s = 8.0f;
            float wl = (float)w * 0.5f;
            float hl = (float)h * 0.05f;
            ((GuiGraphicsAccessor)graphics).blit(RenderPipelines.GUI_TEXTURED, RRIdentifiers.create("textures/" + rhodes.getFlagTextureLocation() + ".png"), Mth.floor((float)(wl - s)), Mth.floor((float)(wl + s)), Mth.floor((float)(hl - s)), Mth.floor((float)(hl + s)), -90.0f, 1.0f, 0.0f, 1.0f, 0);
        }
        MutableComponent text = Component.literal((String)"Rival Rebels");
        graphics.drawString(fr, (Component)text, (int)((double)w * 0.05), (int)((double)h * 0.05), 0xFFFFFF, false);
        text = Component.literal((String)"Robot: ").append(rhodes.getName());
        graphics.drawString(fr, (Component)text, (int)((double)w * 0.05), (int)((double)h * 0.1), 0xFFFFFF, false);
        text = ((Block)RRBlocks.reactor.get()).getName().append(": " + rhodes.getHealth());
        float val = rhodes.getHealth() / (float)RRConfig.SERVER.getRhodesHealth();
        graphics.drawString(fr, (Component)text, (int)((double)w * 0.05), (int)((double)h * 0.15), ((int)((1.0f - val) * 255.0f) & 0xFF) << 16 | ((int)(val * 255.0f) & 0xFF) << 8, false);
        float yaw = (player.getYRot() + 360000.0f) % 360.0f;
        text = yaw >= 315.0f || yaw < 45.0f ? Component.translatable((String)"RivalRebels.binoculars.south") : (yaw >= 45.0f && yaw < 135.0f ? Component.translatable((String)"RivalRebels.binoculars.west") : (yaw >= 135.0f && yaw < 225.0f ? Component.translatable((String)"RivalRebels.binoculars.north") : (yaw >= 225.0f && yaw < 315.0f ? Component.translatable((String)"RivalRebels.binoculars.east") : Component.nullToEmpty((String)"Whut"))));
        graphics.drawString(fr, (Component)text, (int)((double)w * 0.05), (int)((double)h * 0.2), 0xFFFFFF, false);
        text = RRItems.einsten.asItem().getName().copy().append(": " + rhodes.getEnergy());
        graphics.drawString(fr, (Component)text, (int)((double)w * 0.8), (int)((double)h * 0.05), rhodes.isAnyLaserEnabled() ? 0xFF3333 : 0xFFFFFF, false);
        text = Component.nullToEmpty((String)("Jet: " + rhodes.getEnergy()));
        graphics.drawString(fr, (Component)text, (int)((double)w * 0.8), (int)((double)h * 0.1), RRClient.RHODES_JUMP_KEY.isDown() ? 0x6666FF : 0xFFFFFF, false);
        text = ((Block)RRBlocks.forcefieldnode.get()).getName().append(": " + rhodes.getEnergy());
        graphics.drawString(fr, (Component)text, (int)((double)w * 0.8), (int)((double)h * 0.15), rhodes.isForceFieldEnabled() ? 0xBB88FF : 0xFFFFFF, false);
        text = RRItems.seekm202.asItem().getName().copy().append(": " + rhodes.getRocketCount());
        graphics.drawString(fr, (Component)text, (int)((double)w * 0.8), (int)((double)h * 0.2), 0xFFFFFF, false);
        text = rhodes.isPlasma() ? Component.nullToEmpty((String)("Plasma: " + rhodes.getFlameCount())) : ((MutableComponent)RRItems.fuel.asItem().getName()).append(": " + rhodes.getFlameCount());
        graphics.drawString(fr, (Component)text, (int)((double)w * 0.8), (int)((double)h * 0.25), 0xFFFFFF, false);
        graphics.drawString(fr, (Component)((Block)RRBlocks.nuclearBomb.get()).getName().copy().append(": " + rhodes.getNukeCount()), (int)((double)w * 0.8), (int)((double)h * 0.3), 0xFFFFFF, false);
        graphics.drawString(fr, Component.nullToEmpty((String)"Guard"), (int)((double)w * 0.8), (int)((double)h * 0.35), RRClient.RHODES_GUARD_KEY.isDown() ? 0xFFFF00 : 0xFFFFFF, false);
        text = rhodes.getName().copy().append(" ").append((Component)((Block)RRBlocks.controller.get()).getName()).append(": H");
        graphics.drawString(fr, (Component)text, (int)((double)w * 0.05), (int)((double)h * 0.95), GLFW.glfwGetKey((long)client.getWindow().getWindow(), (int)72) == 1 ? 0xFFFF00 : 0xFFFFFF, false);
        if (rhodes.isForceFieldEnabled()) {
            graphics.submitGuiElementRenderState(new GuiElementRenderState(){
                private final Matrix3x2f pose;
                @Nullable
                private final ScreenRectangle scissorArea;
                private final ScreenRectangle bounds;
                {
                    this.pose = new Matrix3x2f((Matrix3x2fc)graphics.pose());
                    this.scissorArea = graphics.peekScissorStack();
                    this.bounds = 1.getBounds(0, 0, w, h, this.pose, this.scissorArea);
                }

                public void buildVertices(VertexConsumer consumer, float z) {
                    consumer.addVertexWith2DPose(this.pose, 0.0f, (float)h, z).setColor(1.0f, 1.0f, 1.0f, 0.7f).setUv(0.0f, (float)h * 0.003f).setLight(0xF000F0);
                    consumer.addVertexWith2DPose(this.pose, (float)w, (float)h, z).setColor(1.0f, 1.0f, 1.0f, 0.7f).setUv((float)w * 0.003f, (float)h * 0.003f).setLight(0xF000F0);
                    consumer.addVertexWith2DPose(this.pose, (float)w, 0.0f, z).setColor(1.0f, 1.0f, 1.0f, 0.7f).setUv((float)w * 0.003f, 0.0f).setLight(0xF000F0);
                    consumer.addVertexWith2DPose(this.pose, 0.0f, 0.0f, z).setColor(1.0f, 1.0f, 1.0f, 0.7f).setUv(0.0f, 0.0f).setLight(0xF000F0);
                }

                public RenderPipeline pipeline() {
                    return RenderTypes.CELLULAR_NOISE_PIPELINE;
                }

                public TextureSetup textureSetup() {
                    return TextureSetup.singleTexture((GpuTextureView)RivalRebelsCellularNoise.getCurrentRandomId().getTextureView());
                }

                @Nullable
                public ScreenRectangle scissorArea() {
                    return this.scissorArea;
                }

                @Nullable
                public ScreenRectangle bounds() {
                    return this.bounds;
                }

                @Nullable
                private static ScreenRectangle getBounds(int x0, int y0, int x1, int y1, Matrix3x2f pose, @Nullable ScreenRectangle scissorArea) {
                    ScreenRectangle screenrectangle = new ScreenRectangle(x0, y0, x1 - x0, y1 - y0).transformMaxBounds(pose);
                    return scissorArea != null ? scissorArea.intersection(screenrectangle) : screenrectangle;
                }
            });
        }
    }

    private void renderBinoculars(ItemStack stack, GuiGraphics graphics, Player player) {
        if (!stack.has(RRComponents.BINOCULAR_DATA)) {
            return;
        }
        if (Minecraft.getInstance().mouseHandler.isRightPressed()) {
            ++this.tic;
            Font tr = Minecraft.getInstance().font;
            int w = graphics.guiWidth();
            int h = graphics.guiHeight();
            ((GuiGraphicsAccessor)graphics).blit(RenderPipelines.GUI_TEXTURED, RRTextures.guibinoculars, 0, w, h, 0, 0.0f, 1.0f, 0.0f, 1.0f, -1);
            ((GuiGraphicsAccessor)graphics).blit(RenderPipelines.GUI_TEXTURED, RRTextures.guibinocularsoverlay, 0, w, h, 0, 0.0f, 1.0f, 0.0f, 1.0f, ARGB.colorFromFloat((float)0.5f, (float)0.333f, (float)0.333f, (float)0.333f));
            BinocularData binocularData = (BinocularData)stack.get(RRComponents.BINOCULAR_DATA);
            BlockPos tpos = binocularData.tpos();
            int tasks = binocularData.tasks();
            int carpet = binocularData.carpet();
            double dist = binocularData.dist();
            BlockState id = player.level().getBlockState(tpos);
            Component text = Component.nullToEmpty((String)"X");
            if (!id.isAir()) {
                text = id.getBlock().getName();
            }
            graphics.drawString(tr, text, (int)((double)w * 0.5 - (double)((float)tr.width((FormattedText)text) / 2.0f)), (int)((double)h * 0.18), 65280, false);
            text = !ItemBinoculars.tooFar ? Component.literal((String)("(" + tpos.getX() + ", " + tpos.getY() + ", " + tpos.getZ() + ")")) : Component.empty();
            graphics.drawString(tr, text, (int)((double)w * 0.5 - (double)((float)tr.width((FormattedText)text) / 2.0f)), (int)((double)h * 0.13), 65280, false);
            if (this.tic % 30 == 0) {
                this.r = !this.r;
            }
            text = Component.nullToEmpty((String)"LTD RR");
            graphics.drawString(tr, text, (int)((double)w * 0.5 - (double)((float)tr.width((FormattedText)text) / 2.0f)), (int)((double)h * 0.8), 0xFFFFFF, false);
            text = Component.literal((String)((int)ItemBinoculars.distblock + "m"));
            graphics.drawString(tr, text, (int)((double)w * 0.637 - (double)((float)tr.width((FormattedText)text) / 2.0f)), (int)((double)h * 0.205), 0xFFFFFF, false);
            float yaw = (player.getYRot() + 360000.0f) % 360.0f;
            text = yaw >= 315.0f || yaw < 45.0f ? Component.translatable((String)"RivalRebels.binoculars.south") : (yaw >= 45.0f && yaw < 135.0f ? Component.translatable((String)"RivalRebels.binoculars.west") : (yaw >= 135.0f && yaw < 225.0f ? Component.translatable((String)"RivalRebels.binoculars.north") : (yaw >= 225.0f && yaw < 315.0f ? Component.translatable((String)"RivalRebels.binoculars.east") : Component.literal((String)"Whut"))));
            graphics.drawString(tr, text, (int)((double)w * 0.37 - (double)((float)tr.width((FormattedText)text) / 2.0f)), (int)((double)h * 0.205), 0xFFFFFF, false);
            if (ItemBinoculars.tooFar) {
                graphics.drawString(tr, (Component)Component.translatable((String)"RivalRebels.controller.range"), (int)((double)w * 0.5 - (double)((float)tr.width((FormattedText)Component.translatable((String)"RivalRebels.controller.range")) / 2.0f)), (int)((double)h * 0.85), 0xFF0000, false);
            } else if (ItemBinoculars.tooClose) {
                graphics.drawString(tr, (Component)Component.translatable((String)"RivalRebels.nextbattle.no"), (int)((double)w * 0.5 - (double)((float)tr.width((FormattedText)Component.translatable((String)"RivalRebels.nextbattle.no")) / 2.0f)), (int)((double)h * 0.85), 0xFF0000, false);
            } else if (ItemBinoculars.ready) {
                graphics.drawString(tr, (Component)Component.translatable((String)"RivalRebels.binoculars.target"), (int)((double)w * 0.5 - (double)((float)tr.width((FormattedText)Component.translatable((String)"RivalRebels.binoculars.target")) / 2.0f)), (int)((double)h * 0.85), 0xFF0000, false);
            }
            graphics.drawString(tr, (Component)Component.translatable((String)"RivalRebels.message.use").append(" ").append((Component)Translations.SHIFT_CLICK.translate()).append(" B-83 x2"), (int)((double)w * 0.05), (int)((double)h * 0.95), 0xFF0000, false);
            graphics.drawString(tr, (Component)Component.literal((String)"Press C to select bomb type"), (int)((double)w * 0.6), (int)((double)h * 0.95), 0xFF0000, false);
            if ((tasks > 0 || carpet > 0) && dist < 10.0) {
                float col = (float)(1.0 - dist / 10.0);
                ((GuiGraphicsAccessor)graphics).blit(RenderPipelines.GUI_TEXTURED, ItemBinoculars.c ? RRTextures.guicarpet : RRIdentifiers.ittaskb83, Mth.floor((double)((double)w * 0.72)), Mth.floor((double)((double)w * 0.72 + 16.0)), Mth.floor((double)((double)h * 0.85 + 16.0)), Mth.floor((double)((double)h * 0.85)), 0.0f, 1.0f, 0.0f, 1.0f, ARGB.colorFromFloat((float)1.0f, (float)col, (float)col, (float)col));
                text = Component.nullToEmpty((String)("x" + tasks));
                graphics.drawString(tr, text, (int)((double)w * 0.76), (int)((double)h * 0.85), ItemBinoculars.c ? 0xFFFF00 : 0xFF0000, false);
                text = Component.nullToEmpty((String)("x" + carpet));
                graphics.drawString(tr, text, (int)((double)w * 0.76), (int)((double)h * 0.9), ItemBinoculars.c ? 0xFF0000 : 0xFFFF00, false);
                text = Component.translatable((String)"RivalRebels.tacticalnuke.name");
                if (!this.r) {
                    graphics.drawString(tr, text, (int)((double)w * 0.5 - (double)((float)tr.width((FormattedText)text) / 2.0f)), (int)((double)h * 0.71), 65280, false);
                }
            } else if ((tasks > 0 || carpet > 0) && ItemBinoculars.hasLaptop) {
                text = ((Block)RRBlocks.controller.get()).getName().append(" ").append((Component)Component.translatable((String)"RivalRebels.controller.range"));
                graphics.drawString(tr, text, (int)((double)w * 0.63), (int)((double)h * 0.87), 0xFFFF00, false);
            }
        }
    }
}

