/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.guihelper;

import io.github.kadir1243.rivalrebels.client.guihelper.GuiButton;
import io.github.kadir1243.rivalrebels.client.renderhelper.RRTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiKnob
extends GuiButton {
    protected int degree;
    protected int maxdegreelimit = 360;
    protected int mindegreelimit = 0;
    protected boolean pressed;

    public GuiKnob(int x, int y, int minDegree, int maxDegree, int startDegree, boolean respectLimits, Component message) {
        super(x, y, 36, 36, message);
        if (respectLimits) {
            this.maxdegreelimit = maxDegree;
            this.mindegreelimit = minDegree;
        }
        this.degree = startDegree;
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.degree > this.maxdegreelimit) {
            this.degree = this.maxdegreelimit;
        }
        if (this.degree < this.mindegreelimit) {
            this.degree = this.mindegreelimit;
        }
        int state = 0;
        if (this.pressed || this.mouseClicked(mouseX, mouseY, 0)) {
            state = 36;
        }
        graphics.pose().pushMatrix();
        graphics.pose().translate((float)this.getX() + (float)this.width / 2.0f, (float)this.getY() + (float)this.height / 2.0f);
        graphics.pose().rotate((float)this.degree);
        graphics.pose().translate(-((float)this.getX() + (float)this.width / 2.0f), -((float)this.getY() + (float)this.height / 2.0f));
        RRTextures.guitbutton.blit(graphics, this.getX(), this.getY(), 76 + state, 0.0f, this.width, this.height, -1);
        graphics.pose().popMatrix();
    }

    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (Minecraft.getInstance().mouseHandler.isLeftPressed()) {
            if (this.mouseClicked(mouseX, mouseY, 0)) {
                this.pressed = true;
            }
            if (this.pressed) {
                this.degree = ((int)(Math.atan2((double)this.getY() - mouseY + (double)(this.height / 2), (double)this.getX() - mouseX + (double)(this.width / 2)) * 57.2957763671875) + 450) % 360 - 180;
            }
        } else {
            this.pressed = false;
            float movement = (float)(-deltaY * 0.375);
            this.degree = (int)((float)this.degree + movement);
        }
    }

    public void onRelease(double mouseX, double mouseY) {
        this.pressed = false;
    }

    public int getDegree() {
        return this.degree;
    }
}

