/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.guihelper;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ReactorConnectedMachinesList
extends AbstractSelectionList<WidgetEntry> {
    public ReactorConnectedMachinesList(Minecraft minecraft, int width, int height, int x, int y, int itemHeight) {
        super(minecraft, width, height, y, itemHeight);
        this.setX(x);
    }

    protected void updateWidgetNarration(NarrationElementOutput narration) {
    }

    public int addEntry(WidgetEntry entry) {
        return super.addEntry((AbstractSelectionList.Entry)entry);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WidgetEntry
    extends AbstractSelectionList.Entry<WidgetEntry> {
        private final BlockPos machinePos;
        private final Block machine;
        private boolean onMachine;

        public WidgetEntry(BlockPos machinePos, Block machine, boolean onMachine) {
            this.machinePos = machinePos;
            this.machine = machine;
            this.onMachine = onMachine;
        }

        public BlockPos getMachinePos() {
            return this.machinePos;
        }

        public Block getMachine() {
            return this.machine;
        }

        public void switchEnabledState() {
            this.onMachine = !this.onMachine;
        }

        public boolean isEnabledMachine() {
            return this.onMachine;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.isMouseOver(mouseX, mouseY) && button == 0) {
                this.switchEnabledState();
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            float alpha = 0.5f;
            if (this.onMachine) {
                alpha = 1.0f;
            }
            graphics.renderItem(this.machine.asItem().getDefaultInstance(), left + width / 2 - 13, top);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WidgetEntry)) {
                return false;
            }
            WidgetEntry that = (WidgetEntry)((Object)o);
            return Objects.equals(this.machine, that.machine);
        }

        public int hashCode() {
            return Objects.hashCode(this.machine);
        }
    }
}

