/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.itemrenders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.client.itemrenders.DynamicItemRenderer;
import io.github.kadir1243.rivalrebels.client.model.ObjModels;
import io.github.kadir1243.rivalrebels.client.renderhelper.QuadHelper;
import io.github.kadir1243.rivalrebels.client.renderhelper.RenderTypes;
import io.github.kadir1243.rivalrebels.common.item.components.RRComponents;
import java.util.function.Supplier;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class TeslaRenderer
implements DynamicItemRenderer {
    private static final DeltaTracker TIMER = Minecraft.getInstance().getDeltaTracker();
    private int spin;
    private final QuadCollection teslaModel = (QuadCollection)Minecraft.getInstance().getModelManager().getStandaloneModel(ObjModels.TESLA_MODEL);
    private final QuadCollection dynamoModel = (QuadCollection)Minecraft.getInstance().getModelManager().getStandaloneModel(ObjModels.DYNAMO_MODEL);
    private static final Supplier<QuadHelper.BakedData> BAKED_MODEL_CELLULAR_NOISE = QuadHelper.createBakedModel(buffer -> {
        buffer.addVertex(-1.0f, -1.0f, -1.0f).setColor(-1).setUv(0.0f, 0.0f);
        buffer.addVertex(-1.0f, 1.0f, -1.0f).setColor(-1).setUv(1.0f, 0.0f);
        buffer.addVertex(-1.0f, 1.0f, 1.0f).setColor(-1).setUv(1.0f, 1.0f);
        buffer.addVertex(-1.0f, -1.0f, 1.0f).setColor(-1).setUv(0.0f, 1.0f);
        buffer.addVertex(1.0f, -1.0f, -1.0f).setColor(-1).setUv(0.0f, 0.0f);
        buffer.addVertex(1.0f, -1.0f, 1.0f).setColor(-1).setUv(0.0f, 1.0f);
        buffer.addVertex(1.0f, 1.0f, 1.0f).setColor(-1).setUv(1.0f, 1.0f);
        buffer.addVertex(1.0f, 1.0f, -1.0f).setColor(-1).setUv(1.0f, 0.0f);
        buffer.addVertex(-1.0f, -1.0f, -1.0f).setColor(-1).setUv(0.0f, 0.0f);
        buffer.addVertex(-1.0f, -1.0f, 1.0f).setColor(-1).setUv(0.0f, 1.0f);
        buffer.addVertex(1.0f, -1.0f, 1.0f).setColor(-1).setUv(3.0f, 1.0f);
        buffer.addVertex(1.0f, -1.0f, -1.0f).setColor(-1).setUv(3.0f, 0.0f);
        buffer.addVertex(-1.0f, 1.0f, -1.0f).setColor(-1).setUv(0.0f, 0.0f);
        buffer.addVertex(1.0f, 1.0f, -1.0f).setColor(-1).setUv(3.0f, 0.0f);
        buffer.addVertex(1.0f, 1.0f, 1.0f).setColor(-1).setUv(3.0f, 1.0f);
        buffer.addVertex(-1.0f, 1.0f, 1.0f).setColor(-1).setUv(0.0f, 1.0f);
        buffer.addVertex(-1.0f, -1.0f, -1.0f).setColor(-1).setUv(0.0f, 0.0f);
        buffer.addVertex(1.0f, -1.0f, -1.0f).setColor(-1).setUv(3.0f, 0.0f);
        buffer.addVertex(1.0f, 1.0f, -1.0f).setColor(-1).setUv(3.0f, 1.0f);
        buffer.addVertex(-1.0f, 1.0f, -1.0f).setColor(-1).setUv(0.0f, 1.0f);
        buffer.addVertex(-1.0f, -1.0f, 1.0f).setColor(-1).setUv(0.0f, 0.0f);
        buffer.addVertex(-1.0f, 1.0f, 1.0f).setColor(-1).setUv(0.0f, 1.0f);
        buffer.addVertex(1.0f, 1.0f, 1.0f).setColor(-1).setUv(3.0f, 1.0f);
        buffer.addVertex(1.0f, -1.0f, 1.0f).setColor(-1).setUv(3.0f, 0.0f);
        buffer.addVertex(-1.0f, -1.0f, -1.0f).setColor(-1).setUv(0.0f, 0.0f);
        buffer.addVertex(-1.0f, 1.0f, -1.0f).setColor(-1).setUv(1.0f, 0.0f);
        buffer.addVertex(-1.0f, 1.0f, 1.0f).setColor(-1).setUv(1.0f, 1.0f);
        buffer.addVertex(-1.0f, -1.0f, 1.0f).setColor(-1).setUv(0.0f, 1.0f);
        buffer.addVertex(1.0f, -1.0f, -1.0f).setColor(-1).setUv(0.0f, 0.0f);
        buffer.addVertex(1.0f, -1.0f, 1.0f).setColor(-1).setUv(0.0f, 1.0f);
        buffer.addVertex(1.0f, 1.0f, 1.0f).setColor(-1).setUv(1.0f, 1.0f);
        buffer.addVertex(1.0f, 1.0f, -1.0f).setColor(-1).setUv(1.0f, 0.0f);
        buffer.addVertex(-1.0f, -1.0f, -1.0f).setColor(-1).setUv(0.0f, 0.0f);
        buffer.addVertex(-1.0f, -1.0f, 1.0f).setColor(-1).setUv(0.0f, 1.0f);
        buffer.addVertex(1.0f, -1.0f, 1.0f).setColor(-1).setUv(3.0f, 1.0f);
        buffer.addVertex(1.0f, -1.0f, -1.0f).setColor(-1).setUv(3.0f, 0.0f);
        buffer.addVertex(-1.0f, 1.0f, -1.0f).setColor(-1).setUv(0.0f, 0.0f);
        buffer.addVertex(1.0f, 1.0f, -1.0f).setColor(-1).setUv(3.0f, 0.0f);
        buffer.addVertex(1.0f, 1.0f, 1.0f).setColor(-1).setUv(3.0f, 1.0f);
        buffer.addVertex(-1.0f, 1.0f, 1.0f).setColor(-1).setUv(0.0f, 1.0f);
        buffer.addVertex(-1.0f, -1.0f, -1.0f).setColor(-1).setUv(0.0f, 0.0f);
        buffer.addVertex(1.0f, -1.0f, -1.0f).setColor(-1).setUv(3.0f, 0.0f);
        buffer.addVertex(1.0f, 1.0f, -1.0f).setColor(-1).setUv(3.0f, 1.0f);
        buffer.addVertex(-1.0f, 1.0f, -1.0f).setColor(-1).setUv(0.0f, 1.0f);
        buffer.addVertex(-1.0f, -1.0f, 1.0f).setColor(-1).setUv(0.0f, 0.0f);
        buffer.addVertex(-1.0f, 1.0f, 1.0f).setColor(-1).setUv(0.0f, 1.0f);
        buffer.addVertex(1.0f, 1.0f, 1.0f).setColor(-1).setUv(3.0f, 1.0f);
        buffer.addVertex(1.0f, -1.0f, 1.0f).setColor(-1).setUv(3.0f, 0.0f);
    });

    private static int getDegree(ItemStack item) {
        return (Integer)item.getOrDefault(RRComponents.TESLA_DIAL, (Object)0);
    }

    @Override
    public void render(ItemStack stack, ItemDisplayContext mode, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (mode == ItemDisplayContext.GUI) {
            matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(45.0f));
        }
        if (!stack.isEnchanted()) {
            int degree = TeslaRenderer.getDegree(stack);
            this.spin = (int)Mth.lerp((float)TIMER.getGameTimeDeltaTicks(), (float)this.spin, (float)((float)this.spin + (5.0f + (float)degree / 36.0f)));
            matrices.pushPose();
            matrices.translate(0.8f, 0.5f, -0.03f);
            matrices.scale(0.12f, 0.12f, 0.12f);
            VertexConsumer buffer = vertexConsumers.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.ettesla));
            ObjModels.render(this.teslaModel, buffer, matrices, -1, light, overlay);
            matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees((float)this.spin));
            ObjModels.render(this.dynamoModel, buffer, matrices, -1, light, overlay);
            matrices.popPose();
        } else {
            matrices.pushPose();
            VertexConsumer cellularNoise = vertexConsumers.getBuffer(RenderTypes.CELLULAR_NOISE);
            matrices.scale(1.01f, 1.01f, 1.01f);
            matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(45.0f));
            matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(10.0f));
            matrices.scale(0.6f, 0.2f, 0.2f);
            matrices.translate(-0.99f, 0.5f, 0.0f);
            ModelBlockRenderer.renderModel((PoseStack.Pose)matrices.last(), (VertexConsumer)cellularNoise, (BlockStateModel)BAKED_MODEL_CELLULAR_NOISE.get().blockStateModel(), (float)1.0f, (float)1.0f, (float)1.0f, (int)light, (int)overlay);
            matrices.popPose();
        }
    }
}

