/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mojang.math.Transformation;
import io.github.kadir1243.rivalrebels.client.renderhelper.QuadHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.pipeline.TransformingVertexPipeline;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ModelBlastRing {
    private static final Map<DataToRender, QuadHelper.BakedData> CACHE = new HashMap<DataToRender, QuadHelper.BakedData>();

    public static void renderModel(PoseStack matrices, VertexConsumer buffer, float size, int segments, float thickness, float height, float pitch, float yaw, float roll, float x, float y, float z, int color, int light, int overlay) {
        matrices.pushPose();
        matrices.translate(x, y, z);
        matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(pitch));
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(yaw));
        matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(roll));
        QuadHelper.BakedData bakedModel = CACHE.computeIfAbsent(new DataToRender(size, segments, thickness, height), key -> QuadHelper.createBakedModel(bakingBuffer -> {
            float innerangle = (float)Math.PI * 2 / (float)key.segments;
            Vector3f v1 = new Vector3f(0.0f, -key.height, key.size - key.thickness);
            Vector3f v2 = new Vector3f(0.0f, -key.height, key.size + key.thickness);
            Vector3f v3 = new Vector3f(Mth.sin((float)innerangle) * (key.size - key.thickness), -key.height, Mth.cos((float)innerangle) * (key.size - key.thickness));
            Vector3f v4 = new Vector3f(Mth.sin((float)innerangle) * (key.size + key.thickness), -key.height, Mth.cos((float)innerangle) * (key.size + key.thickness));
            Vector3f v5 = new Vector3f(0.0f, key.height, key.size - key.thickness);
            Vector3f v6 = new Vector3f(0.0f, key.height, key.size + key.thickness);
            Vector3f v7 = new Vector3f(Mth.sin((float)innerangle) * (key.size - key.thickness), key.height, Mth.cos((float)innerangle) * (key.size - key.thickness));
            Vector3f v8 = new Vector3f(Mth.sin((float)innerangle) * (key.size + key.thickness), key.height, Mth.cos((float)innerangle) * (key.size + key.thickness));
            for (float i = 0.0f; i < 360.0f; i += 360.0f / (float)key.segments) {
                TransformingVertexPipeline rotatedBuffer = new TransformingVertexPipeline(bakingBuffer, new Transformation(null, Axis.YP.rotationDegrees(i), null, null));
                QuadHelper.addFace((VertexConsumer)rotatedBuffer, v5, v6, v8, v7, color);
                QuadHelper.addFace((VertexConsumer)rotatedBuffer, v2, v1, v3, v4, color);
                QuadHelper.addFace((VertexConsumer)rotatedBuffer, v2, v4, v8, v6, color);
                QuadHelper.addFace((VertexConsumer)rotatedBuffer, v3, v1, v5, v7, color);
            }
        }).get());
        ModelBlockRenderer.renderModel((PoseStack.Pose)matrices.last(), (VertexConsumer)buffer, (BlockStateModel)bakedModel.blockStateModel(), (float)1.0f, (float)1.0f, (float)1.0f, (int)light, (int)overlay);
        matrices.popPose();
    }

    public static void renderModel(PoseStack matrices, VertexConsumer buffer, float size, int segments, float thickness, float height, float pitch, float yaw, float roll, float x, float y, float z, int light, int overlay) {
        ModelBlastRing.renderModel(matrices, buffer, size, segments, thickness, height, pitch, yaw, roll, x, y, z, -1, light, overlay);
    }

    public static void renderModel(PoseStack matrices, VertexConsumer buffer, float size, int segments, float thickness, float height, float pitch, float yaw, float roll, float x, float y, float z, int light) {
        ModelBlastRing.renderModel(matrices, buffer, size, segments, thickness, height, pitch, yaw, roll, x, y, z, -1, light, OverlayTexture.NO_OVERLAY);
    }

    private record DataToRender(float size, int segments, float thickness, float height) {
        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataToRender that = (DataToRender)o;
            return Float.compare(this.size(), that.size()) == 0 && this.segments() == that.segments() && Float.compare(this.height(), that.height()) == 0 && Float.compare(this.thickness(), that.thickness()) == 0;
        }

        @Override
        public int hashCode() {
            return Objects.hash(Float.valueOf(this.size()), this.segments(), Float.valueOf(this.thickness()), Float.valueOf(this.height()));
        }
    }
}

