/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.model.obj.ObjGeometry;
import net.neoforged.neoforge.client.model.obj.ObjLoader;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelKey;
import net.neoforged.neoforge.client.model.standalone.UnbakedStandaloneModel;

public class ObjModels {
    public static final StandaloneModelKey<QuadCollection> B2_JET_FOR_RHODES_MODEL = ObjModels.createKey("b2_jet_for_rhodes");
    public static final StandaloneModelKey<QuadCollection> HEAD_MODEL = ObjModels.createKey("head");
    public static final StandaloneModelKey<QuadCollection> TORSO_MODEL = ObjModels.createKey("torso");
    public static final StandaloneModelKey<QuadCollection> FLAG_MODEL = ObjModels.createKey("flag");
    public static final StandaloneModelKey<QuadCollection> UPPER_ARM_MODEL = ObjModels.createKey("upper_arm_rhodes");
    public static final StandaloneModelKey<QuadCollection> LOWER_ARM_MODEL = ObjModels.createKey("lower_arm_rhodes");
    public static final StandaloneModelKey<QuadCollection> RHODES_FLAMETHROWER_MODEL = ObjModels.createKey("flamethrower_rhodes");
    public static final StandaloneModelKey<QuadCollection> RHODES_ROCKET_LAUNCHER_MODEL = ObjModels.createKey("rocket_launcher_rhodes");
    public static final StandaloneModelKey<QuadCollection> THIGH_MODEL = ObjModels.createKey("thigh");
    public static final StandaloneModelKey<QuadCollection> SHIN_MODEL = ObjModels.createKey("shin");
    public static final StandaloneModelKey<QuadCollection> BOOSTER_MODEL = ObjModels.createKey("booster");
    public static final StandaloneModelKey<QuadCollection> RHODES_FLAME_MODEL = ObjModels.createKey("flame_rhodes");
    public static final StandaloneModelKey<QuadCollection> RHODES_LASER_MODEL = ObjModels.createKey("laser_rhodes");
    public static final StandaloneModelKey<QuadCollection> FF_HEAD_MODEL = ObjModels.createKey("ff_head");
    public static final StandaloneModelKey<QuadCollection> FF_TORSO_MODEL = ObjModels.createKey("ff_torso");
    public static final StandaloneModelKey<QuadCollection> FF_UPPER_ARM_MODEL = ObjModels.createKey("ff_upper_arm_rhodes");
    public static final StandaloneModelKey<QuadCollection> FF_LOWER_ARM_MODEL = ObjModels.createKey("ff_lower_arm_rhodes");
    public static final StandaloneModelKey<QuadCollection> FF_THIGH_MODEL = ObjModels.createKey("ff_thigh");
    public static final StandaloneModelKey<QuadCollection> FF_SHIN_MODEL = ObjModels.createKey("ff_shin");
    public static final StandaloneModelKey<QuadCollection> BOMB_MODEL = ObjModels.createKey("bomb");
    public static final StandaloneModelKey<QuadCollection> NUKE_MODEL = ObjModels.createKey("nuke");
    public static final StandaloneModelKey<QuadCollection> B2_FOR_SPIRIT_MODEL = ObjModels.createKey("b2_for_spirit");
    public static final StandaloneModelKey<QuadCollection> SHUTTLE_MODEL = ObjModels.createKey("shuttle");
    public static final StandaloneModelKey<QuadCollection> TUPOLEV_MODEL = ObjModels.createKey("tupolev");
    public static final StandaloneModelKey<QuadCollection> BATTERY_MODEL = ObjModels.createKey("battery");
    public static final StandaloneModelKey<QuadCollection> PLASMA_CANNON_MODEL = ObjModels.createKey("plasma_cannon");
    public static final StandaloneModelKey<QuadCollection> RODA_MODEL = ObjModels.createKey("roda");
    public static final StandaloneModelKey<QuadCollection> TESLA_MODEL = ObjModels.createKey("tesla");
    public static final StandaloneModelKey<QuadCollection> DYNAMO_MODEL = ObjModels.createKey("dynamo");
    public static final StandaloneModelKey<QuadCollection> B83_MODEL = ObjModels.createKey("b83");
    public static final StandaloneModelKey<QuadCollection> B2_FRAG_SIDE_1_MODEL = ObjModels.createKey("b2_frag_side_1");
    public static final StandaloneModelKey<QuadCollection> B2_FRAG_SIDE_2_MODEL = ObjModels.createKey("b2_frag_side_2");
    public static final StandaloneModelKey<QuadCollection> ELECTRODE_MODEL = ObjModels.createKey("electrode");
    public static final StandaloneModelKey<QuadCollection> TUBE_MODEL = ObjModels.createKey("tube");
    public static final StandaloneModelKey<QuadCollection> TRAY_MODEL = ObjModels.createKey("tray");
    public static final StandaloneModelKey<QuadCollection> ARM_MODEL = ObjModels.createKey("arm");
    public static final StandaloneModelKey<QuadCollection> ADS_DRAGON_MODEL = ObjModels.createKey("ads_dragon");
    public static final StandaloneModelKey<QuadCollection> ASTRO_BLASTER_BODY = ObjModels.createKey("astro_blaster_body");
    public static final StandaloneModelKey<QuadCollection> BLAST_SPHERE_MODEL = ObjModels.createKey("blast_sphere");

    @OnlyIn(value=Dist.CLIENT)
    private static StandaloneModelKey<QuadCollection> createKey(String name) {
        ResourceLocation location = RRIdentifiers.create(name + "_model");
        return new StandaloneModelKey(() -> ((ResourceLocation)location).toString());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void render(QuadCollection model, VertexConsumer buffer, PoseStack pose, int color, int light, int overlay) {
        if (model == null) {
            throw new NullPointerException("Model is null");
        }
        for (BakedQuad quad : model.getAll()) {
            buffer.putBulkData(pose.last(), quad, (float)ARGB.red((int)color), (float)ARGB.green((int)color), (float)ARGB.blue((int)light), (float)ARGB.alpha((int)color), light, overlay);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerModels(ModelEvent.RegisterStandalone event) {
        event.register(B2_JET_FOR_RHODES_MODEL, ObjModels.getModelFromObj("s"));
        event.register(HEAD_MODEL, ObjModels.getModelFromObj("rhodes/head"));
        event.register(TORSO_MODEL, ObjModels.getModelFromObj("rhodes/torso"));
        event.register(FLAG_MODEL, ObjModels.getModelFromObj("rhodes/flag"));
        event.register(UPPER_ARM_MODEL, ObjModels.getModelFromObj("rhodes/upperarm"));
        event.register(LOWER_ARM_MODEL, ObjModels.getModelFromObj("rhodes/lowerarm"));
        event.register(RHODES_FLAMETHROWER_MODEL, ObjModels.getModelFromObj("rhodes/flamethrower"));
        event.register(RHODES_ROCKET_LAUNCHER_MODEL, ObjModels.getModelFromObj("rhodes/rocketlauncher"));
        event.register(THIGH_MODEL, ObjModels.getModelFromObj("rhodes/thigh"));
        event.register(SHIN_MODEL, ObjModels.getModelFromObj("rhodes/shin"));
        event.register(BOOSTER_MODEL, ObjModels.getModelFromObj("booster"));
        event.register(RHODES_FLAME_MODEL, ObjModels.getModelFromObj("rhodes/flame"));
        event.register(RHODES_LASER_MODEL, ObjModels.getModelFromObj("rhodes/laser"));
        event.register(FF_HEAD_MODEL, ObjModels.getModelFromObj("rhodes/ffhead"));
        event.register(FF_TORSO_MODEL, ObjModels.getModelFromObj("rhodes/fftorso"));
        event.register(FF_UPPER_ARM_MODEL, ObjModels.getModelFromObj("rhodes/ffupperarm"));
        event.register(FF_LOWER_ARM_MODEL, ObjModels.getModelFromObj("rhodes/fflowerarm"));
        event.register(FF_THIGH_MODEL, ObjModels.getModelFromObj("rhodes/ffthigh"));
        event.register(FF_SHIN_MODEL, ObjModels.getModelFromObj("rhodes/ffshin"));
        event.register(BOMB_MODEL, ObjModels.getModelFromObj("t"));
        event.register(NUKE_MODEL, ObjModels.getModelFromObj("wacknuke"));
        event.register(B2_FOR_SPIRIT_MODEL, ObjModels.getModelFromObj("d"));
        event.register(SHUTTLE_MODEL, ObjModels.getModelFromObj("shuttle"));
        event.register(TUPOLEV_MODEL, ObjModels.getModelFromObj("tupolev"));
        event.register(BATTERY_MODEL, ObjModels.getModelFromObj("k"));
        event.register(PLASMA_CANNON_MODEL, ObjModels.getModelFromObj("m"));
        event.register(RODA_MODEL, ObjModels.getModelFromObj("e"));
        event.register(TESLA_MODEL, ObjModels.getModelFromObj("i"));
        event.register(DYNAMO_MODEL, ObjModels.getModelFromObj("j"));
        event.register(B83_MODEL, ObjModels.getModelFromObj("c"));
        event.register(B2_FRAG_SIDE_1_MODEL, ObjModels.getModelFromObj("f"));
        event.register(B2_FRAG_SIDE_2_MODEL, ObjModels.getModelFromObj("g"));
        event.register(ELECTRODE_MODEL, ObjModels.getModelFromObj("a"));
        event.register(TUBE_MODEL, ObjModels.getModelFromObj("l"));
        event.register(TRAY_MODEL, ObjModels.getModelFromObj("p"));
        event.register(ARM_MODEL, ObjModels.getModelFromObj("q"));
        event.register(ADS_DRAGON_MODEL, ObjModels.getModelFromObj("r"));
        event.register(ASTRO_BLASTER_BODY, ObjModels.getModelFromObj("astro_blaster_body"));
        event.register(BLAST_SPHERE_MODEL, ObjModels.getModelFromObj("blast_sphere"));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static UnbakedStandaloneModel<QuadCollection> getModelFromObj(final String location) {
        final ObjGeometry geometry = ObjLoader.INSTANCE.loadGeometry(new ObjGeometry.Settings(RRIdentifiers.getModelLocation(location), false, false, false, false, null));
        return new UnbakedStandaloneModel<QuadCollection>(){

            public QuadCollection bake(ModelBaker baker) {
                return geometry.bake(TextureSlots.EMPTY, baker, (ModelState)BlockModelRotation.X0_Y0, () -> location);
            }

            public void resolveDependencies(ResolvableModel.Resolver resolver) {
            }
        };
    }
}

