/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.common.entity.EntityFlameBall;
import io.github.kadir1243.rivalrebels.common.entity.EntityFlameBall1;
import io.github.kadir1243.rivalrebels.common.entity.EntityFlameBall2;
import io.github.kadir1243.rivalrebels.common.entity.EntityFlameBallGreen;
import io.github.kadir1243.rivalrebels.common.entity.FlameBallProjectile;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public abstract class FlameBallRenderer<T extends FlameBallProjectile>
extends EntityRenderer<T, State> {
    public FlameBallRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public State createRenderState() {
        return new State();
    }

    public void render(State renderState, PoseStack pose, MultiBufferSource bufferSource, int packedLight) {
        if (renderState.ageInTicks < 3.0f) {
            return;
        }
        pose.pushPose();
        pose.pushPose();
        float X = (float)(renderState.sequence % 4) / 4.0f;
        float Y = (float)(renderState.sequence - renderState.sequence % 4) / 16.0f;
        float size = this.getSize(renderState);
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)RRIdentifiers.etflamebluered));
        pose.mulPose((Quaternionfc)this.entityRenderDispatcher.cameraOrientation());
        pose.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        pose.pushPose();
        pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.rotation));
        buffer.addVertex(pose.last(), -size, 0.0f, -size).setColor(-1).setUv(X, Y).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose.last(), 0.0f, 1.0f, 0.0f);
        buffer.addVertex(pose.last(), size, 0.0f, -size).setColor(-1).setUv(X + 0.25f, Y).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose.last(), 0.0f, 1.0f, 0.0f);
        buffer.addVertex(pose.last(), size, 0.0f, size).setColor(-1).setUv(X + 0.25f, Y + 0.25f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose.last(), 0.0f, 1.0f, 0.0f);
        buffer.addVertex(pose.last(), -size, 0.0f, size).setColor(-1).setUv(X, Y + 0.25f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose.last(), 0.0f, 1.0f, 0.0f);
        pose.popPose();
        pose.popPose();
        pose.popPose();
    }

    public void extractRenderState(T p_entity, State reusedState, float partialTick) {
        super.extractRenderState(p_entity, (EntityRenderState)reusedState, partialTick);
        reusedState.sequence = ((FlameBallProjectile)((Object)p_entity)).sequence;
        reusedState.rotation = ((FlameBallProjectile)((Object)p_entity)).rotation;
    }

    public abstract float getSize(EntityRenderState var1);

    public ResourceLocation getTextureLocation(T entity) {
        if (entity instanceof EntityFlameBall1) {
            return RRIdentifiers.etflamebluered;
        }
        if (entity instanceof EntityFlameBall2) {
            return RRIdentifiers.etflameblue;
        }
        if (entity instanceof EntityFlameBall) {
            return RRIdentifiers.etflameball;
        }
        if (entity instanceof EntityFlameBallGreen) {
            return RRIdentifiers.etflameballgreen;
        }
        return null;
    }

    protected int getBlockLightLevel(T entity, BlockPos pos) {
        return 15;
    }

    public static class State
    extends EntityRenderState {
        public int sequence;
        public float rotation;
    }
}

