/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.client.model.ObjModels;
import io.github.kadir1243.rivalrebels.common.entity.EntityB2Frag;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class RenderB2Frag
extends EntityRenderer<EntityB2Frag, State> {
    private final QuadCollection b2FragSide1Model;
    private final QuadCollection b2FragSide2Model;

    public RenderB2Frag(EntityRendererProvider.Context manager) {
        super(manager);
        ModelManager modelManager = manager.getModelManager();
        this.b2FragSide1Model = (QuadCollection)modelManager.getStandaloneModel(ObjModels.B2_FRAG_SIDE_1_MODEL);
        this.b2FragSide2Model = (QuadCollection)modelManager.getStandaloneModel(ObjModels.B2_FRAG_SIDE_2_MODEL);
    }

    public void render(State renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.yRot));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(renderState.xRot));
        poseStack.scale(3.0f, 3.0f, 3.0f);
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.etb2spirit));
        if (renderState.type == 0) {
            ObjModels.render(this.b2FragSide1Model, buffer, poseStack, -1, packedLight, OverlayTexture.NO_OVERLAY);
        } else if (renderState.type == 1) {
            ObjModels.render(this.b2FragSide2Model, buffer, poseStack, -1, packedLight, OverlayTexture.NO_OVERLAY);
        }
        poseStack.popPose();
    }

    protected boolean affectedByCulling(EntityB2Frag p_365169_) {
        return false;
    }

    public boolean shouldRender(EntityB2Frag livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    public State createRenderState() {
        return new State();
    }

    public void extractRenderState(EntityB2Frag p_entity, State reusedState, float partialTick) {
        super.extractRenderState((Entity)p_entity, (EntityRenderState)reusedState, partialTick);
        reusedState.xRot = p_entity.getXRot(partialTick);
        reusedState.yRot = p_entity.getYRot(partialTick);
        reusedState.type = p_entity.type;
    }

    public static class State
    extends EntityRenderState {
        public float xRot;
        public float yRot;
        public int type;
    }
}

