/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderentity;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.kadir1243.rivalrebels.common.entity.EntityDebris;
import java.util.List;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.FallingBlockRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderDebris
extends EntityRenderer<EntityDebris, FallingBlockRenderState> {
    private final BlockRenderDispatcher dispatcher;

    public RenderDebris(EntityRendererProvider.Context manager) {
        super(manager);
        this.shadowRadius = 0.5f;
        this.dispatcher = manager.getBlockRenderDispatcher();
    }

    public FallingBlockRenderState createRenderState() {
        return new FallingBlockRenderState();
    }

    public void extractRenderState(EntityDebris p_entity, FallingBlockRenderState reusedState, float partialTick) {
        super.extractRenderState((Entity)p_entity, (EntityRenderState)reusedState, partialTick);
        reusedState.blockState = p_entity.getState();
        reusedState.blockPos = BlockPos.containing((double)p_entity.getX(), (double)p_entity.getBoundingBox().maxY, (double)p_entity.getZ());
        reusedState.level = p_entity.level();
    }

    public void render(FallingBlockRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        BlockState state = renderState.blockState;
        if (state == null || state.isAir()) {
            return;
        }
        poseStack.pushPose();
        BlockPos blockpos = renderState.blockPos;
        poseStack.translate(-0.5, 0.0, -0.5);
        if (state.getRenderShape() != RenderShape.INVISIBLE) {
            List list = this.dispatcher.getBlockModel(state).collectParts(renderState.level, blockpos, state, RandomSource.create((long)state.getSeed(blockpos)));
            this.dispatcher.getModelRenderer().tesselateBlock(renderState.level, list, state, blockpos, poseStack, bufferSource.getBuffer(ItemBlockRenderTypes.getMovingBlockRenderType((BlockState)state)), false, OverlayTexture.NO_OVERLAY);
        }
        poseStack.popPose();
    }
}

