/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.common.entity.EntityGasGrenade;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class RenderGasGrenade
extends EntityRenderer<EntityGasGrenade, State> {
    private static final RenderType RENDER_LAYER = RenderType.entitySolid((ResourceLocation)RRIdentifiers.etgasgrenade);

    public RenderGasGrenade(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(State renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.yRot - 90.0f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(renderState.xRot));
        int var11 = 0;
        float var12 = 0.0f;
        float var13 = 0.5f;
        float var14 = (float)(0 + var11 * 10) / 32.0f;
        float var15 = (float)(5 + var11 * 10) / 32.0f;
        float var16 = 0.0f;
        float var17 = 0.15625f;
        float var18 = (float)(5 + var11 * 10) / 32.0f;
        float var19 = (float)(10 + var11 * 10) / 32.0f;
        float var20 = 0.05625f;
        int overlay = OverlayTexture.NO_OVERLAY;
        VertexConsumer buffer = bufferSource.getBuffer(RENDER_LAYER);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(45.0f));
        poseStack.scale(var20, var20, var20);
        poseStack.translate(-4.0f, 0.0f, 0.0f);
        int defaultColor = -1;
        buffer.addVertex(poseStack.last(), -7.0f, -2.0f, -2.0f).setColor(defaultColor).setUv(var16, var18).setOverlay(overlay).setLight(packedLight).setNormal(poseStack.last(), var20, 0.0f, 0.0f);
        buffer.addVertex(poseStack.last(), -7.0f, -2.0f, 2.0f).setColor(defaultColor).setUv(var17, var18).setOverlay(overlay).setLight(packedLight).setNormal(poseStack.last(), var20, 0.0f, 0.0f);
        buffer.addVertex(poseStack.last(), -7.0f, 2.0f, 2.0f).setColor(defaultColor).setUv(var17, var19).setOverlay(overlay).setLight(packedLight).setNormal(poseStack.last(), var20, 0.0f, 0.0f);
        buffer.addVertex(poseStack.last(), -7.0f, 2.0f, -2.0f).setColor(defaultColor).setUv(var16, var19).setOverlay(overlay).setLight(packedLight).setNormal(poseStack.last(), var20, 0.0f, 0.0f);
        buffer.addVertex(poseStack.last(), -7.0f, 2.0f, -2.0f).setColor(defaultColor).setUv(var16, var18).setOverlay(overlay).setLight(packedLight).setNormal(poseStack.last(), -var20, 0.0f, 0.0f);
        buffer.addVertex(poseStack.last(), -7.0f, 2.0f, 2.0f).setColor(defaultColor).setUv(var17, var18).setOverlay(overlay).setLight(packedLight).setNormal(poseStack.last(), -var20, 0.0f, 0.0f);
        buffer.addVertex(poseStack.last(), -7.0f, -2.0f, 2.0f).setColor(defaultColor).setUv(var17, var19).setOverlay(overlay).setLight(packedLight).setNormal(poseStack.last(), -var20, 0.0f, 0.0f);
        buffer.addVertex(poseStack.last(), -7.0f, -2.0f, -2.0f).setColor(defaultColor).setUv(var16, var19).setOverlay(overlay).setLight(packedLight).setNormal(poseStack.last(), -var20, 0.0f, 0.0f);
        for (int var23 = 0; var23 < 4; ++var23) {
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            buffer.addVertex(poseStack.last(), -8.0f, -2.0f, 0.0f).setColor(defaultColor).setUv(var12, var14).setOverlay(overlay).setLight(packedLight).setNormal(poseStack.last(), 0.0f, 0.0f, var20);
            buffer.addVertex(poseStack.last(), 8.0f, -2.0f, 0.0f).setColor(defaultColor).setUv(var13, var14).setOverlay(overlay).setLight(packedLight).setNormal(poseStack.last(), 0.0f, 0.0f, var20);
            buffer.addVertex(poseStack.last(), 8.0f, 2.0f, 0.0f).setColor(defaultColor).setUv(var13, var15).setOverlay(overlay).setLight(packedLight).setNormal(poseStack.last(), 0.0f, 0.0f, var20);
            buffer.addVertex(poseStack.last(), -8.0f, 2.0f, 0.0f).setColor(defaultColor).setUv(var12, var15).setOverlay(overlay).setLight(packedLight).setNormal(poseStack.last(), 0.0f, 0.0f, var20);
        }
        poseStack.popPose();
    }

    public State createRenderState() {
        return new State();
    }

    public void extractRenderState(EntityGasGrenade p_entity, State reusedState, float partialTick) {
        super.extractRenderState((Entity)p_entity, (EntityRenderState)reusedState, partialTick);
        reusedState.xRot = p_entity.getXRot(partialTick);
        reusedState.yRot = p_entity.getYRot(partialTick);
    }

    public static class State
    extends EntityRenderState {
        public float xRot;
        public float yRot;
    }
}

