/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.client.renderhelper.RenderHelper;
import io.github.kadir1243.rivalrebels.common.entity.EntityGore;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class RenderGore
extends EntityRenderer<EntityGore, State> {
    private static final ResourceLocation player = ResourceLocation.withDefaultNamespace((String)"textures/entity/steve.png");
    private static final ResourceLocation creeper = ResourceLocation.withDefaultNamespace((String)"textures/entity/creeper/creeper.png");
    private static final ResourceLocation enderman = ResourceLocation.withDefaultNamespace((String)"textures/entity/enderman/enderman.png");
    private static final ResourceLocation ghast = ResourceLocation.withDefaultNamespace((String)"textures/entity/ghast/ghast.png");
    private static final ResourceLocation skeleton = ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/skeleton.png");
    private static final ResourceLocation slime = ResourceLocation.withDefaultNamespace((String)"textures/entity/slime/slime.png");
    private static final ResourceLocation magmacube = ResourceLocation.withDefaultNamespace((String)"textures/entity/slime/magmacube.png");
    private static final ResourceLocation spider = ResourceLocation.withDefaultNamespace((String)"textures/entity/spider/spider.png");
    private static final ResourceLocation cavespider = ResourceLocation.withDefaultNamespace((String)"textures/entity/spider/cave_spider.png");
    private static final ResourceLocation zombiepigman = ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_pigman.png");
    private static final ResourceLocation zombie = ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie/zombie.png");

    public RenderGore(EntityRendererProvider.Context renderManager) {
        super(renderManager);
        this.shadowRadius = 0.0f;
    }

    public void render(State renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-renderState.yRot + 180.0f));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.xRot));
        int mob = renderState.mob;
        int type = renderState.type;
        float size = renderState.size;
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.itemEntityTranslucentCull((ResourceLocation)this.getTextureLocation(renderState)));
        if (mob == 0) {
            if (type == 0) {
                RenderHelper.renderBox(poseStack, buffer, 8.0f, 8.0f, 8.0f, 0.0f, 0.0f, 64.0f, 32.0f, 16.0f, packedLight);
            } else if (type == 1) {
                RenderHelper.renderBox(poseStack, buffer, 4.0f, 12.0f, 8.0f, 16.0f, 16.0f, 64.0f, 32.0f, 16.0f, packedLight);
            } else if (type == 2) {
                RenderHelper.renderBox(poseStack, buffer, 4.0f, 12.0f, 4.0f, 40.0f, 16.0f, 64.0f, 32.0f, 16.0f, packedLight);
            } else if (type == 3) {
                RenderHelper.renderBox(poseStack, buffer, 4.0f, 12.0f, 4.0f, 0.0f, 16.0f, 64.0f, 32.0f, 16.0f, packedLight);
            }
        } else if (mob == 1) {
            if (type == 0) {
                RenderHelper.renderBox(poseStack, buffer, 8.0f, 8.0f, 8.0f, 0.0f, 0.0f, 64.0f, 64.0f, 16.0f, packedLight);
            } else if (type == 1) {
                RenderHelper.renderBox(poseStack, buffer, 4.0f, 12.0f, 8.0f, 16.0f, 16.0f, 64.0f, 64.0f, 16.0f, packedLight);
            } else if (type == 2) {
                RenderHelper.renderBox(poseStack, buffer, 4.0f, 12.0f, 4.0f, 40.0f, 16.0f, 64.0f, 64.0f, 16.0f, packedLight);
            } else if (type == 3) {
                RenderHelper.renderBox(poseStack, buffer, 4.0f, 12.0f, 4.0f, 0.0f, 16.0f, 64.0f, 64.0f, 16.0f, packedLight);
            }
        } else if (mob == 2) {
            if (type == 0) {
                RenderHelper.renderBox(poseStack, buffer, 8.0f, 8.0f, 8.0f, 0.0f, 0.0f, 64.0f, 64.0f, 16.0f, packedLight);
            } else if (type == 1) {
                RenderHelper.renderBox(poseStack, buffer, 4.0f, 12.0f, 8.0f, 16.0f, 16.0f, 64.0f, 64.0f, 16.0f, packedLight);
            } else if (type == 2) {
                RenderHelper.renderBox(poseStack, buffer, 4.0f, 12.0f, 4.0f, 40.0f, 16.0f, 64.0f, 64.0f, 16.0f, packedLight);
            } else if (type == 3) {
                RenderHelper.renderBox(poseStack, buffer, 4.0f, 12.0f, 4.0f, 0.0f, 16.0f, 64.0f, 64.0f, 16.0f, packedLight);
            }
        } else if (mob == 3) {
            if (type == 0) {
                RenderHelper.renderBox(poseStack, buffer, 8.0f, 8.0f, 8.0f, 0.0f, 0.0f, 64.0f, 32.0f, 16.0f, packedLight);
            } else if (type == 1) {
                RenderHelper.renderBox(poseStack, buffer, 4.0f, 12.0f, 8.0f, 16.0f, 16.0f, 64.0f, 32.0f, 16.0f, packedLight);
            } else if (type == 2) {
                RenderHelper.renderBox(poseStack, buffer, 2.0f, 10.0f, 2.0f, 40.0f, 16.0f, 64.0f, 32.0f, 16.0f, packedLight);
            } else if (type == 3) {
                RenderHelper.renderBox(poseStack, buffer, 2.0f, 10.0f, 2.0f, 0.0f, 16.0f, 64.0f, 32.0f, 16.0f, packedLight);
            }
        } else if (mob == 4) {
            if (type == 0) {
                RenderHelper.renderBox(poseStack, buffer, 8.0f, 8.0f, 8.0f, 0.0f, 0.0f, 64.0f, 32.0f, 16.0f, packedLight);
                poseStack.translate(0.0, -0.125, 0.0);
                poseStack.scale(0.875f, 0.875f, 0.875f);
                RenderHelper.renderBox(poseStack, buffer, 8.0f, 8.0f, 8.0f, 0.0f, 16.0f, 64.0f, 32.0f, 16.0f, packedLight);
            } else if (type == 1) {
                RenderHelper.renderBox(poseStack, buffer, 4.0f, 12.0f, 8.0f, 32.0f, 16.0f, 64.0f, 32.0f, 16.0f, packedLight);
            } else if (type == 2) {
                RenderHelper.renderBox(poseStack, buffer, 2.0f, 30.0f, 2.0f, 56.0f, 0.0f, 64.0f, 32.0f, 16.0f, packedLight);
            } else if (type == 3) {
                RenderHelper.renderBox(poseStack, buffer, 2.0f, 30.0f, 2.0f, 56.0f, 0.0f, 64.0f, 32.0f, 16.0f, packedLight);
            }
        } else if (mob == 5) {
            if (type == 0) {
                RenderHelper.renderBox(poseStack, buffer, 8.0f, 8.0f, 8.0f, 0.0f, 0.0f, 64.0f, 32.0f, 16.0f, packedLight);
            } else if (type == 1) {
                RenderHelper.renderBox(poseStack, buffer, 4.0f, 12.0f, 8.0f, 16.0f, 16.0f, 64.0f, 32.0f, 16.0f, packedLight);
            } else if (type == 3) {
                RenderHelper.renderBox(poseStack, buffer, 4.0f, 6.0f, 4.0f, 0.0f, 16.0f, 64.0f, 32.0f, 16.0f, packedLight);
            }
        } else if (mob == 6) {
            if (type == 0) {
                RenderHelper.renderBox(poseStack, bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(renderState))), 8.0f, 8.0f, 8.0f, 0.0f, 0.0f, 64.0f, 32.0f, 16.0f, packedLight);
            } else if (type == 1) {
                RenderHelper.renderBox(poseStack, bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(renderState))), 6.0f, 6.0f, 6.0f, 0.0f, 16.0f, 64.0f, 32.0f, 16.0f, packedLight);
            }
        } else if (mob == 7) {
            if (type == 0) {
                RenderHelper.renderBox(poseStack, buffer, 8.0f, 8.0f, 8.0f, 0.0f, 0.0f, 64.0f, 32.0f, 16.0f, packedLight);
            } else if (type == 1) {
                RenderHelper.renderBox(poseStack, buffer, 6.0f, 6.0f, 6.0f, 0.0f, 16.0f, 64.0f, 32.0f, 16.0f, packedLight);
            }
        } else if (mob == 8) {
            if (type == 0) {
                RenderHelper.renderBox(poseStack, buffer, 8.0f, 8.0f, 8.0f, 32.0f, 4.0f, 64.0f, 32.0f, 16.0f, packedLight);
            } else if (type == 1) {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                RenderHelper.renderBox(poseStack, buffer, 8.0f, 12.0f, 10.0f, 4.0f, 12.0f, 64.0f, 32.0f, 16.0f, packedLight);
            } else if (type == 3) {
                RenderHelper.renderBox(poseStack, buffer, 2.0f, 2.0f, 16.0f, 18.0f, 0.0f, 64.0f, 32.0f, 16.0f, packedLight);
            }
        } else if (mob == 9) {
            poseStack.scale(0.666f, 0.666f, 0.666f);
            if (type == 0) {
                RenderHelper.renderBox(poseStack, buffer, 8.0f, 8.0f, 8.0f, 32.0f, 4.0f, 64.0f, 32.0f, 16.0f, packedLight);
            } else if (type == 1) {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                RenderHelper.renderBox(poseStack, buffer, 8.0f, 12.0f, 10.0f, 4.0f, 12.0f, 64.0f, 32.0f, 16.0f, packedLight);
            } else if (type == 3) {
                RenderHelper.renderBox(poseStack, buffer, 2.0f, 2.0f, 16.0f, 18.0f, 0.0f, 64.0f, 32.0f, 16.0f, packedLight);
            }
        } else if (mob == 10) {
            if (type == 0) {
                RenderHelper.renderBox(poseStack, buffer, 16.0f, 16.0f, 16.0f, 0.0f, 0.0f, 64.0f, 32.0f, 4.0f, packedLight);
            } else if (type == 3) {
                RenderHelper.renderBox(poseStack, buffer, 2.0f, 14.0f, 2.0f, 0.0f, 0.0f, 64.0f, 32.0f, 4.0f, packedLight);
            }
        } else if (mob == 11) {
            if (type == 0) {
                RenderHelper.renderBox(poseStack, buffer, (int)(8.0f * size), (int)(8.0f * size), (int)(8.0f * size), 0.0f, 0.0f, 64.0f, 64.0f, 16.0f, packedLight);
            } else if (type == 1) {
                RenderHelper.renderBox(poseStack, buffer, (int)(4.0f * size), (int)(12.0f * size), (int)(8.0f * size), 0.0f, 0.0f, 64.0f, 64.0f, 16.0f, packedLight);
            } else if (type == 2) {
                RenderHelper.renderBox(poseStack, buffer, (int)(4.0f * size), (int)(12.0f * size), (int)(4.0f * size), 0.0f, 0.0f, 64.0f, 64.0f, 16.0f, packedLight);
            } else if (type == 3) {
                RenderHelper.renderBox(poseStack, buffer, (int)(4.0f * size), (int)(12.0f * size), (int)(4.0f * size), 0.0f, 0.0f, 64.0f, 64.0f, 16.0f, packedLight);
            }
        }
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(State entity) {
        return switch (entity.mob) {
            case 0 -> Objects.requireNonNullElse(entity.playerSkin, player);
            case 1 -> zombie;
            case 2 -> zombiepigman;
            case 3 -> skeleton;
            case 4 -> enderman;
            case 5 -> creeper;
            case 6 -> slime;
            case 7 -> magmacube;
            case 8 -> spider;
            case 9 -> cavespider;
            case 10 -> ghast;
            case 11 -> {
                if (entity.size < 1.0f) {
                    yield RRIdentifiers.btsplash5;
                }
                if (entity.size < 2.0f) {
                    yield RRIdentifiers.btsplash1;
                }
                yield RRIdentifiers.btsplash3;
            }
            default -> null;
        };
    }

    public boolean shouldRender(EntityGore livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    public State createRenderState() {
        return new State();
    }

    public void extractRenderState(EntityGore p_entity, State reusedState, float partialTick) {
        super.extractRenderState((Entity)p_entity, (EntityRenderState)reusedState, partialTick);
        reusedState.xRot = p_entity.getXRot(partialTick);
        reusedState.yRot = p_entity.getYRot(partialTick);
        reusedState.mob = p_entity.getMob();
        reusedState.type = p_entity.getTypeOfGore();
        reusedState.size = p_entity.getSize();
        reusedState.playerSkin = p_entity.playerSkin;
    }

    public static class State
    extends EntityRenderState {
        public float xRot;
        public float yRot;
        public int mob;
        public int type;
        public float size;
        public ResourceLocation playerSkin;
    }
}

