/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.client.model.ModelLaptop;
import io.github.kadir1243.rivalrebels.common.entity.EntityLaptop;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class RenderLaptop
extends EntityRenderer<EntityLaptop, State> {
    public RenderLaptop(EntityRendererProvider.Context manager) {
        super(manager);
    }

    public void render(State renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - renderState.yRot));
        ModelLaptop.renderModel(bufferSource, poseStack, -renderState.slide, packedLight, OverlayTexture.NO_OVERLAY);
        ModelLaptop.renderScreen(bufferSource, RRIdentifiers.etubuntu, poseStack, -renderState.slide, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    public State createRenderState() {
        return new State();
    }

    public void extractRenderState(EntityLaptop p_entity, State reusedState, float partialTick) {
        super.extractRenderState((Entity)p_entity, (EntityRenderState)reusedState, partialTick);
        reusedState.slide = (float)p_entity.slide;
        reusedState.yRot = p_entity.getYRot(partialTick);
    }

    public static class State
    extends EntityRenderState {
        public float slide;
        public float yRot;
    }
}

