/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.client.renderhelper.RenderTypes;
import io.github.kadir1243.rivalrebels.common.entity.EntityLightningLink;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class RenderLightningLink
extends EntityRenderer<EntityLightningLink, State> {
    static float red = 0.65f;
    static float green = 0.75f;
    static float blue = 1.0f;
    private static final int COLOR = ARGB.colorFromFloat((float)0.95f, (float)red, (float)green, (float)blue);

    public RenderLightningLink(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(State renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float segmentDistance = RRConfig.CLIENT.getTeslaSegments();
        float distance = (float)renderState.deltaMovement.x() * 100.0f;
        distance = 100.0f;
        if (distance > 0.0f) {
            RandomSource random = renderState.random;
            float radius = 0.07f;
            VertexConsumer buffer = bufferSource.getBuffer(RenderTypes.LIGHTNING_LINK);
            poseStack.pushPose();
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.yRot));
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-renderState.xRot));
            float AddedX = 0.0f;
            float AddedY = 0.0f;
            float prevAddedX = 0.0f;
            float prevAddedY = 0.0f;
            int addedZ = (int)distance;
            while (addedZ >= 0) {
                prevAddedX = AddedX;
                prevAddedY = AddedY;
                float dist = Mth.sqrt((float)((AddedX = (float)((double)AddedX + ((double)random.nextFloat() - 0.5) * 2.0)) * AddedX + (AddedY = (float)((double)AddedY + ((double)random.nextFloat() - 0.5) * 2.0)) * AddedY)) / 1.5f;
                if (dist != 0.0f) {
                    float tempAddedX = AddedX / dist;
                    float tempAddedY = AddedY / dist;
                    if (Mth.abs((float)tempAddedX) < Mth.abs((float)AddedX)) {
                        AddedX = tempAddedX;
                    }
                    if (Mth.abs((float)tempAddedY) < Mth.abs((float)AddedY)) {
                        AddedY = tempAddedY;
                    }
                }
                if (addedZ <= 0) {
                    AddedY = 0.0f;
                    AddedX = 0.0f;
                }
                for (float o = 0.0f; o <= radius; o += radius / 8.0f) {
                    buffer.addVertex(poseStack.last(), AddedX + o, AddedY - o, (float)addedZ).setColor(COLOR);
                    buffer.addVertex(poseStack.last(), AddedX + o, AddedY + o, (float)addedZ).setColor(COLOR);
                    buffer.addVertex(poseStack.last(), prevAddedX + o, prevAddedY + o, (float)addedZ + segmentDistance).setColor(COLOR);
                    buffer.addVertex(poseStack.last(), prevAddedX + o, prevAddedY - o, (float)addedZ + segmentDistance).setColor(COLOR);
                    buffer.addVertex(poseStack.last(), AddedX - o, AddedY - o, (float)addedZ).setColor(COLOR);
                    buffer.addVertex(poseStack.last(), AddedX + o, AddedY - o, (float)addedZ).setColor(COLOR);
                    buffer.addVertex(poseStack.last(), prevAddedX + o, prevAddedY - o, (float)addedZ + segmentDistance).setColor(COLOR);
                    buffer.addVertex(poseStack.last(), prevAddedX - o, prevAddedY - o, (float)addedZ + segmentDistance).setColor(COLOR);
                    buffer.addVertex(poseStack.last(), AddedX - o, AddedY + o, (float)addedZ).setColor(COLOR);
                    buffer.addVertex(poseStack.last(), AddedX - o, AddedY - o, (float)addedZ).setColor(COLOR);
                    buffer.addVertex(poseStack.last(), prevAddedX - o, prevAddedY - o, (float)addedZ + segmentDistance).setColor(COLOR);
                    buffer.addVertex(poseStack.last(), prevAddedX - o, prevAddedY + o, (float)addedZ + segmentDistance).setColor(COLOR);
                    buffer.addVertex(poseStack.last(), AddedX + o, AddedY + o, (float)addedZ).setColor(COLOR);
                    buffer.addVertex(poseStack.last(), AddedX - o, AddedY + o, (float)addedZ).setColor(COLOR);
                    buffer.addVertex(poseStack.last(), prevAddedX - o, prevAddedY + o, (float)addedZ + segmentDistance).setColor(COLOR);
                    buffer.addVertex(poseStack.last(), prevAddedX + o, prevAddedY + o, (float)addedZ + segmentDistance).setColor(COLOR);
                }
                addedZ = (int)((float)addedZ - segmentDistance);
            }
            poseStack.popPose();
        }
    }

    public boolean shouldRender(EntityLightningLink livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    protected int getBlockLightLevel(EntityLightningLink entity, BlockPos pos) {
        return 15;
    }

    public State createRenderState() {
        return new State();
    }

    public void extractRenderState(EntityLightningLink p_entity, State reusedState, float partialTick) {
        super.extractRenderState((Entity)p_entity, (EntityRenderState)reusedState, partialTick);
        reusedState.xRot = p_entity.getXRot(partialTick);
        reusedState.yRot = p_entity.getYRot(partialTick);
        reusedState.deltaMovement = p_entity.getDeltaMovement();
        reusedState.random = p_entity.getRandom();
    }

    public static class State
    extends EntityRenderState {
        public float xRot;
        public float yRot;
        public Vec3 deltaMovement;
        public RandomSource random;
    }
}

