/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.RivalRebels;
import io.github.kadir1243.rivalrebels.client.model.ModelBlastSphere;
import io.github.kadir1243.rivalrebels.client.model.ObjModels;
import io.github.kadir1243.rivalrebels.client.renderhelper.RenderTypes;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodes;
import io.github.kadir1243.rivalrebels.common.entity.RhodesType;
import io.github.kadir1243.rivalrebels.common.entity.RhodesTypes;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsPlayer;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsTeam;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class RenderRhodes
extends EntityRenderer<EntityRhodes, State> {
    private static final ResourceLocation flame = RRIdentifiers.create("textures/entity/flame.png");
    private final QuadCollection headModel;
    private final QuadCollection b2jetForRhodesModel;
    private final QuadCollection torsoModel;
    private final QuadCollection flagModel;
    private final QuadCollection upperArmModel;
    private final QuadCollection lowerArmModel;
    private final QuadCollection flameThrowerModel;
    private final QuadCollection rocketLauncherModel;
    private final QuadCollection thighModel;
    private final QuadCollection shinModel;
    private final QuadCollection flameModel;
    private final QuadCollection boosterModel;
    private final QuadCollection laserModel;
    private final QuadCollection b2ForSpiritModel;
    private final QuadCollection ffheadModel;
    private final QuadCollection ffTorsoModel;
    private final QuadCollection ffUpperArmModel;
    private final QuadCollection ffLowerArmModel;
    private final QuadCollection ffThighModel;
    private final QuadCollection ffShinModel;
    private final QuadCollection shuttleModel;

    public RenderRhodes(EntityRendererProvider.Context context) {
        super(context);
        ModelManager modelManager = context.getModelManager();
        this.headModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.HEAD_MODEL);
        this.b2jetForRhodesModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.B2_JET_FOR_RHODES_MODEL);
        this.torsoModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.TORSO_MODEL);
        this.flagModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.FLAG_MODEL);
        this.upperArmModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.UPPER_ARM_MODEL);
        this.lowerArmModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.LOWER_ARM_MODEL);
        this.flameThrowerModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.RHODES_FLAMETHROWER_MODEL);
        this.rocketLauncherModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.RHODES_ROCKET_LAUNCHER_MODEL);
        this.thighModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.THIGH_MODEL);
        this.shinModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.SHIN_MODEL);
        this.flameModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.RHODES_FLAME_MODEL);
        this.boosterModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.BOOSTER_MODEL);
        this.laserModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.RHODES_LASER_MODEL);
        this.b2ForSpiritModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.B2_FOR_SPIRIT_MODEL);
        this.ffheadModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.FF_HEAD_MODEL);
        this.ffTorsoModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.FF_TORSO_MODEL);
        this.ffUpperArmModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.FF_UPPER_ARM_MODEL);
        this.ffLowerArmModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.FF_LOWER_ARM_MODEL);
        this.ffThighModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.FF_THIGH_MODEL);
        this.ffShinModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.FF_SHIN_MODEL);
        this.shuttleModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.SHUTTLE_MODEL);
    }

    public boolean shouldRender(EntityRhodes livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    protected int getBlockLightLevel(EntityRhodes entity, BlockPos pos) {
        return super.getBlockLightLevel((Entity)entity, pos.atY(255));
    }

    protected int getSkyLightLevel(EntityRhodes entity, BlockPos pos) {
        return super.getSkyLightLevel((Entity)entity, pos.atY(255));
    }

    protected void renderNameTag(State renderState, Component displayName, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        int color = 0;
        if (renderState.rider != null) {
            RivalRebelsPlayer rrp = RivalRebels.round.rrplayerlist.getForGameProfile(renderState.rider.getGameProfile());
            color = switch (rrp.rrteam) {
                default -> throw new MatchException(null, null);
                case RivalRebelsTeam.OMEGA -> 0x44FF44;
                case RivalRebelsTeam.SIGMA -> 0x4444FF;
                case RivalRebelsTeam.NONE -> -1;
            };
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, 16.0f, 0.0f);
        poseStack.mulPose((Quaternionfc)this.entityRenderDispatcher.cameraOrientation());
        poseStack.scale(0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.last().pose();
        float f = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        int j = (int)(f * 255.0f) << 24;
        Font font = this.getFont();
        float x = -font.width((FormattedText)displayName) / 2;
        font.drawInBatch(displayName, x, 0.0f, color, false, matrix4f, bufferSource, Font.DisplayMode.SEE_THROUGH, j, packedLight);
        font.drawInBatch(displayName, x, 0.0f, color, false, matrix4f, bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        poseStack.popPose();
    }

    public State createRenderState() {
        return new State();
    }

    public void render(State renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (renderState.health > 0.0f) {
            poseStack.pushPose();
            poseStack.scale(renderState.scale, renderState.scale, renderState.scale);
            Component name = renderState.displayName;
            if (renderState.rider != null) {
                name = name.copy().append(" - ").append(renderState.rider.getDisplayName());
            }
            this.renderNameTag(renderState, name, poseStack, bufferSource, packedLight);
            RhodesType rhodesType = (RhodesType)renderState.variant.value();
            if (rhodesType == RhodesTypes.Space) {
                poseStack.pushPose();
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.bodyyaw));
                poseStack.translate(0.0f, 10.0f, 0.0f);
                ObjModels.render(this.boosterModel, bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.etbooster)), poseStack, -1, packedLight, OverlayTexture.NO_OVERLAY);
                poseStack.pushPose();
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
                poseStack.translate(0.0f, 4.0f, -2.0f);
                poseStack.scale(2.2f, 2.2f, 2.2f);
                if (renderState.b2Energy > 0) {
                    ObjModels.render(this.shuttleModel, bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.etb2spirit)), poseStack, -1, packedLight, OverlayTexture.NO_OVERLAY);
                }
                poseStack.popPose();
                poseStack.popPose();
            } else {
                VertexConsumer noiseBuffer = bufferSource.getBuffer(RenderTypes.CELLULAR_NOISE);
                VertexConsumer textureBuffer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)rhodesType.getTexture()));
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.bodyyaw));
                float leftlegheight = -7.73244f + Mth.cos((float)((renderState.leftthighpitch + 11.99685f) * ((float)Math.PI / 180))) * 7.3316913f + Mth.cos((float)((renderState.leftthighpitch + renderState.leftshinpitch - 12.215306f) * ((float)Math.PI / 180))) * 8.521366f;
                float rightlegheight = -7.73244f + Mth.cos((float)((renderState.rightthighpitch + 11.99685f) * ((float)Math.PI / 180))) * 7.3316913f + Mth.cos((float)((renderState.rightthighpitch + renderState.rightshinpitch - 12.215306f) * ((float)Math.PI / 180))) * 8.521366f;
                poseStack.pushPose();
                int colorOfRhodes = rhodesType.getColor();
                poseStack.translate(0.0f, Math.max(leftlegheight, rightlegheight), 0.0f);
                poseStack.pushPose();
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
                poseStack.translate(0.0f, 4.0f, -2.0f);
                if (renderState.b2Energy > 0) {
                    poseStack.pushPose();
                    poseStack.scale(2.5f, 2.5f, 2.5f);
                    ObjModels.render(this.b2ForSpiritModel, bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.etb2spirit)), poseStack, colorOfRhodes, packedLight, OverlayTexture.NO_OVERLAY);
                    poseStack.popPose();
                }
                if (renderState.jet && renderState.b2Energy > 0) {
                    poseStack.pushPose();
                    poseStack.scale(2.5f, 2.5f, 2.5f);
                    ObjModels.render(this.b2jetForRhodesModel, bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)flame)), poseStack, colorOfRhodes, packedLight, OverlayTexture.NO_OVERLAY);
                    poseStack.popPose();
                }
                poseStack.popPose();
                ObjModels.render(this.torsoModel, textureBuffer, poseStack, colorOfRhodes, packedLight, OverlayTexture.NO_OVERLAY);
                poseStack.pushPose();
                poseStack.translate(-6.4f, 0.0f, 0.0f);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.rightarmyaw));
                poseStack.scale(-1.0f, 1.0f, 1.0f);
                ObjModels.render(this.upperArmModel, textureBuffer, poseStack, colorOfRhodes, packedLight, OverlayTexture.NO_OVERLAY);
                poseStack.pushPose();
                poseStack.translate(0.0f, -1.5f, 0.0f);
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.rightarmpitch));
                ObjModels.render(this.lowerArmModel, textureBuffer, poseStack, colorOfRhodes, packedLight, OverlayTexture.NO_OVERLAY);
                poseStack.scale(-1.0f, 1.0f, 1.0f);
                ObjModels.render(this.flameThrowerModel, textureBuffer, poseStack, colorOfRhodes, packedLight, OverlayTexture.NO_OVERLAY);
                poseStack.popPose();
                poseStack.popPose();
                poseStack.pushPose();
                poseStack.translate(6.4f, 0.0f, 0.0f);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.leftarmyaw));
                ObjModels.render(this.upperArmModel, textureBuffer, poseStack, colorOfRhodes, packedLight, OverlayTexture.NO_OVERLAY);
                poseStack.pushPose();
                poseStack.translate(0.0f, -1.5f, 0.0f);
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.leftarmpitch));
                ObjModels.render(this.lowerArmModel, textureBuffer, poseStack, colorOfRhodes, packedLight, OverlayTexture.NO_OVERLAY);
                ObjModels.render(this.rocketLauncherModel, textureBuffer, poseStack, colorOfRhodes, packedLight, OverlayTexture.NO_OVERLAY);
                poseStack.popPose();
                poseStack.popPose();
                poseStack.pushPose();
                poseStack.translate(0.0f, -7.26756f, -0.27904f);
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.rightthighpitch));
                poseStack.scale(-1.0f, 1.0f, 1.0f);
                ObjModels.render(this.thighModel, textureBuffer, poseStack, colorOfRhodes, packedLight, OverlayTexture.NO_OVERLAY);
                poseStack.pushPose();
                poseStack.translate(0.0f, -7.17156f, -1.52395f);
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.rightshinpitch));
                ObjModels.render(this.shinModel, textureBuffer, poseStack, colorOfRhodes, packedLight, OverlayTexture.NO_OVERLAY);
                if (renderState.isBurning) {
                    ObjModels.render(this.flameModel, bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)flame)), poseStack, colorOfRhodes, packedLight, OverlayTexture.NO_OVERLAY);
                }
                poseStack.popPose();
                poseStack.popPose();
                poseStack.pushPose();
                poseStack.translate(0.0f, -7.26756f, -0.27904f);
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.leftthighpitch));
                ObjModels.render(this.thighModel, textureBuffer, poseStack, colorOfRhodes, packedLight, OverlayTexture.NO_OVERLAY);
                poseStack.pushPose();
                poseStack.translate(0.0f, -7.17156f, -1.52395f);
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.leftshinpitch));
                ObjModels.render(this.shinModel, textureBuffer, poseStack, colorOfRhodes, packedLight, OverlayTexture.NO_OVERLAY);
                if (renderState.isBurning) {
                    ObjModels.render(this.flameModel, bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)flame)), poseStack, colorOfRhodes, packedLight, OverlayTexture.NO_OVERLAY);
                }
                poseStack.popPose();
                poseStack.popPose();
                poseStack.pushPose();
                poseStack.translate(0.0f, 5.23244f, 0.0f);
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.headpitch));
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.viewYRot));
                ObjModels.render(this.headModel, textureBuffer, poseStack, colorOfRhodes, packedLight, OverlayTexture.NO_OVERLAY);
                int color = ARGB.colorFromFloat((float)0.5f, (float)1.0f, (float)0.0f, (float)0.0f);
                if (renderState.topLaserEnabled) {
                    ObjModels.render(this.laserModel, bufferSource.getBuffer(RenderTypes.LASER_RENDER_TYPE), poseStack, color, packedLight, OverlayTexture.NO_OVERLAY);
                } else if (renderState.bottomLaserEnabled) {
                    poseStack.scale(1.0f, -1.0f, 1.0f);
                    ObjModels.render(this.laserModel, bufferSource.getBuffer(RenderTypes.LASER_RENDER_TYPE), poseStack, color, packedLight, OverlayTexture.NO_OVERLAY);
                }
                poseStack.popPose();
                poseStack.popPose();
                poseStack.pushPose();
                poseStack.translate(0.0f, Math.max(leftlegheight, rightlegheight), 0.0f);
                if (!renderState.flagTextureLocation.isBlank()) {
                    try {
                        ObjModels.render(this.flagModel, bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.create(renderState.flagTextureLocation + ".png"))), poseStack, -1, packedLight, OverlayTexture.NO_OVERLAY);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (renderState.forceFieldEnabled) {
                    ObjModels.render(this.ffTorsoModel, noiseBuffer, poseStack, -1, packedLight, OverlayTexture.NO_OVERLAY);
                    poseStack.pushPose();
                    poseStack.translate(-6.4f, 0.0f, 0.0f);
                    poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.rightarmyaw));
                    poseStack.scale(-1.0f, 1.0f, 1.0f);
                    ObjModels.render(this.ffUpperArmModel, noiseBuffer, poseStack, -1, packedLight, OverlayTexture.NO_OVERLAY);
                    poseStack.pushPose();
                    poseStack.translate(0.0f, -1.5f, 0.0f);
                    poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.rightarmpitch));
                    ObjModels.render(this.ffLowerArmModel, noiseBuffer, poseStack, -1, packedLight, OverlayTexture.NO_OVERLAY);
                    poseStack.popPose();
                    poseStack.popPose();
                    poseStack.pushPose();
                    poseStack.translate(6.4f, 0.0f, 0.0f);
                    poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.leftarmyaw));
                    ObjModels.render(this.ffUpperArmModel, noiseBuffer, poseStack, -1, packedLight, OverlayTexture.NO_OVERLAY);
                    poseStack.pushPose();
                    poseStack.translate(0.0f, -1.5f, 0.0f);
                    poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.leftarmpitch));
                    ObjModels.render(this.ffLowerArmModel, noiseBuffer, poseStack, -1, packedLight, OverlayTexture.NO_OVERLAY);
                    poseStack.popPose();
                    poseStack.popPose();
                    poseStack.pushPose();
                    poseStack.translate(0.0f, -7.26756f, -0.27904f);
                    poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.rightthighpitch));
                    poseStack.scale(-1.0f, 1.0f, 1.0f);
                    ObjModels.render(this.ffThighModel, noiseBuffer, poseStack, -1, packedLight, OverlayTexture.NO_OVERLAY);
                    poseStack.pushPose();
                    poseStack.translate(0.0f, -7.17156f, -1.52395f);
                    poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.rightshinpitch));
                    ObjModels.render(this.ffShinModel, noiseBuffer, poseStack, -1, packedLight, OverlayTexture.NO_OVERLAY);
                    poseStack.popPose();
                    poseStack.popPose();
                    poseStack.pushPose();
                    poseStack.translate(0.0f, -7.26756f, -0.27904f);
                    poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.leftthighpitch));
                    ObjModels.render(this.ffThighModel, noiseBuffer, poseStack, -1, packedLight, OverlayTexture.NO_OVERLAY);
                    poseStack.pushPose();
                    poseStack.translate(0.0f, -7.17156f, -1.52395f);
                    poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.leftshinpitch));
                    ObjModels.render(this.ffShinModel, noiseBuffer, poseStack, -1, packedLight, OverlayTexture.NO_OVERLAY);
                    poseStack.popPose();
                    poseStack.popPose();
                    poseStack.pushPose();
                    poseStack.translate(0.0f, 5.23244f, 0.0f);
                    poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.headpitch));
                    poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.viewYRot));
                    ObjModels.render(this.ffheadModel, noiseBuffer, poseStack, -1, packedLight, OverlayTexture.NO_OVERLAY);
                    poseStack.popPose();
                }
                poseStack.popPose();
            }
            poseStack.popPose();
        }
        if (renderState.health < 1.0f) {
            VertexConsumer lightning = bufferSource.getBuffer(RenderTypes.RHODES_LIGHTNING);
            poseStack.pushPose();
            float elev = Mth.sin((float)((renderState.health - renderState.partialTick) * -0.03141593f)) * 15.0f;
            poseStack.pushPose();
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(elev * 2.0f));
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(elev * 3.0f));
            ModelBlastSphere.renderModel(poseStack, lightning, elev, ARGB.colorFromFloat((float)1.0f, (float)1.0f, (float)0.25f, (float)0.0f));
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(elev * -2.0f));
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(elev * 4.0f));
            ModelBlastSphere.renderModel(poseStack, lightning, elev - 0.2f, ARGB.colorFromFloat((float)1.0f, (float)1.0f, (float)0.5f, (float)0.0f));
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(elev * -3.0f));
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(elev * 2.0f));
            ModelBlastSphere.renderModel(poseStack, lightning, elev - 0.4f, -65536);
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(elev * -1.0f));
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(elev * 3.0f));
            ModelBlastSphere.renderModel(poseStack, lightning, elev - 0.6f, -256);
            poseStack.popPose();
            poseStack.popPose();
        }
    }

    public void extractRenderState(EntityRhodes p_entity, State reusedState, float partialTick) {
        super.extractRenderState((Entity)p_entity, (EntityRenderState)reusedState, partialTick);
        float ptt = Math.min(((float)p_entity.ticksSinceLastPacket + partialTick) / 5.0f, 1.0f);
        if (p_entity.tickCount < 10) {
            ptt = 1.0f;
        }
        reusedState.ptt = ptt;
        reusedState.rider = p_entity.rider;
        reusedState.ticksSinceLastPacket = p_entity.ticksSinceLastPacket;
        reusedState.health = p_entity.getHealth();
        reusedState.scale = p_entity.getScale();
        reusedState.displayName = p_entity.getDisplayName();
        reusedState.variant = p_entity.getVariant();
        reusedState.flagTextureLocation = p_entity.getFlagTextureLocation();
        reusedState.leftthighpitch = p_entity.getleftthighpitch(ptt);
        reusedState.rightthighpitch = p_entity.getrightthighpitch(ptt);
        reusedState.leftshinpitch = p_entity.getleftshinpitch(ptt);
        reusedState.rightshinpitch = p_entity.getrightshinpitch(ptt);
        reusedState.rightarmpitch = p_entity.getrightarmpitch(ptt);
        reusedState.rightarmyaw = p_entity.getrightarmyaw(ptt);
        reusedState.leftarmpitch = p_entity.getleftarmpitch(ptt);
        reusedState.leftarmyaw = p_entity.getleftarmyaw(ptt);
        reusedState.headpitch = p_entity.getheadpitch(ptt);
        reusedState.bodyyaw = p_entity.getbodyyaw(ptt);
        reusedState.viewYRot = p_entity.getViewYRot(ptt);
        reusedState.b2Energy = p_entity.getB2Energy();
        reusedState.isBurning = p_entity.isFire();
        reusedState.topLaserEnabled = p_entity.isTopLaserEnabled();
        reusedState.bottomLaserEnabled = p_entity.isBottomLaserEnabled();
        reusedState.forceFieldEnabled = p_entity.isForceFieldEnabled();
        reusedState.jet = p_entity.jet;
    }

    public static class State
    extends EntityRenderState {
        public Player rider;
        public float health;
        public float scale;
        public int ticksSinceLastPacket;
        public Component displayName;
        public Holder<RhodesType> variant;
        public float ptt;
        public float leftthighpitch;
        public float rightthighpitch;
        public float leftshinpitch;
        public float rightshinpitch;
        public float rightarmpitch;
        public float rightarmyaw;
        public float leftarmpitch;
        public float leftarmyaw;
        public float headpitch;
        public float bodyyaw;
        public float viewYRot;
        public String flagTextureLocation;
        public int b2Energy;
        public boolean isBurning;
        public boolean jet;
        public boolean forceFieldEnabled;
        public boolean bottomLaserEnabled;
        public boolean topLaserEnabled;
    }
}

